/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import Arachnophilia.ArachComp;
import Arachnophilia.ArachConstants;
import Arachnophilia.ArachDocument;
import Arachnophilia.ComSwitchboard;
import Arachnophilia.ConfigValues;
import Arachnophilia.EntityProcessor;
import Arachnophilia.ErrorMessageLogger;
import Arachnophilia.FileListHandler;
import Arachnophilia.FindReplacePanel;
import Arachnophilia.FontChooser;
import Arachnophilia.InitFileHandler;
import Arachnophilia.MacroHandler;
import Arachnophilia.MacroKeyHandler;
import Arachnophilia.MyJPopupMenu;
import Arachnophilia.RecentFileList;
import Arachnophilia.RightClickProcessor;
import Arachnophilia.SearchReplace;
import Arachnophilia.SplashWindow;
import Arachnophilia.TextInputDialog;
import BrowserStuff.BrowserLauncher;
import CompilerReplyPanel.ReplyPanel;
import FilePicker.PickerDialog;
import FileTypes.FileTypes;
import HTMLBeautify.BeautifyUtils;
import HTMLValidator.HTMLValidator;
import ListTableWizards.TableWizardFrame;
import MacroManager.MacroEditor;
import MacroManager.MacroEditorFrame;
import MacroManager.MacroTreePanel;
import SpellCheck.SpellCheckFrame;
import TipOfTheDay.TipJFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Arachnophilia
extends JFrame
implements DropTargetListener {
    public static final String errorLogFileName = "ArachErrorLog.txt";
    public static final String tempFilePrefix = "~ArachBrowserTemp";
    public static final String ftpLogFileName = ".ArachnophiliaFTPUploadFileList.log";
    public static final String customDictName = "CustomDictionary.txt";
    public static final String userAppDir = ".Arachnophilia";
    public static final String iniFileName = "Arach.ini";
    public static final String jarName = "Arachnophilia.jar";
    public static final String dataDirName = "ArachConf";
    public static final String templateDirName = "Templates";
    public static final String macroDirName = "Macros";
    public static final String iconDirName = "Icons";
    public static final String spellCheckDataDirName = "SpellCheckData";
    public static final String docDirName = "Documentation";
    public static final String docImagesDirName = "Documentation/images";
    public static final String docStylesDirName = "Documentation/styles";
    public static final String customClassDirName = "CustomClasses";
    public static final String macroFileName = "Macros.xml";
    public static final String[] dirList = new String[]{"ArachConf", "Templates", "Macros", "SpellCheckData", "Documentation", "Documentation/images", "Documentation/styles", "CustomClasses"};
    public static final String defaultStatusMessage = "Done.";
    private Vector<String> comArgs;
    Dimension screenSize;
    Dimension appSize;
    public Map renderHints = new HashMap();
    public ImageIcon frameIcon;
    public FileListHandler fileHandler;
    public ComSwitchboard comSwitchboard;
    public FileTypes fileTypes;
    public String appDir;
    public String userHome = ArachConstants.USERHOME;
    public String basePath;
    public InitFileHandler initFileHandler;
    public String configPath;
    public String fileTypePath;
    public String ftpSitePath;
    public String macroPath;
    public String errorLogPath;
    public ConfigValues configValues;
    public BeautifyUtils beautifyUtils;
    public HTMLValidator htmlValidator;
    public EntityProcessor entityProcessor = null;
    private BrowserLauncher browserLauncher;
    public RightClickProcessor rightClickProcessor;
    public RecentFileList recentFileList = null;
    public ArachDocument currentSelectedDocument = null;
    public ArachDocument latestOpenedDocument = null;
    public FindReplacePanel findReplacePanel;
    public MacroHandler macroHandler;
    public MacroKeyHandler macroKeyHandler;
    private JPanel toolBarPanel;
    public MacroEditor macroEditor;
    public SpellCheckFrame spellCheckFrame = null;
    boolean macroEditShowing = false;
    boolean progressBarInUse = false;
    public boolean haveFocus = true;
    private boolean rejectResize = true;
    public TableWizardFrame tableWizard = null;
    private Timer autoSaveTimer = null;
    SplashWindow installWindow = null;
    MacroEditorFrame macroEditorFrame = null;
    private JPanel borderPanel;
    private JPanel bottomPanel;
    private JSplitPane contentSplitPane;
    private JPanel macroPanel;
    private JMenuBar mainMenuBar;
    private JPanel mainPanel;
    private JPopupMenu plainDocPopup;
    private JSplitPane rightSplitPane;
    private JTabbedPane rightTabbedPane;
    private JPopupMenu rootPopup;
    private JLabel statusBar;
    private JPopupMenu syntaxDocPopup;
    private JToolBar toolBar;
    private JPanel topMainPanel;

    public Arachnophilia(String[] stringArray) {
        this.comArgs = new Vector<String>(Arrays.asList(stringArray));
        this.basePath = this.getConfigDir(this.userHome);
        this.testJavaVersion();
        this.setDefaultCloseOperation(0);
        this.appDir = this.locateAppDir();
        this.fileTypePath = this.basePath + ArachConstants.SYSTEM_FILESEP + dataDirName + ArachConstants.SYSTEM_FILESEP + "FileData.txt";
        this.errorLogPath = this.basePath + ArachConstants.SYSTEM_FILESEP + errorLogFileName;
        this.ftpSitePath = this.basePath + ArachConstants.SYSTEM_FILESEP + dataDirName + ArachConstants.SYSTEM_FILESEP + "FTPSiteData.txt";
        this.macroPath = this.basePath + ArachConstants.SYSTEM_FILESEP + macroDirName + ArachConstants.SYSTEM_FILESEP + macroFileName;
        this.configPath = this.basePath + ArachConstants.SYSTEM_FILESEP + dataDirName + ArachConstants.SYSTEM_FILESEP + iniFileName;
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ArachComp.setMain(this);
        this.frameIcon = new ImageIcon(this.getClass().getResource("/Icons/Arach.gif"));
        this.setIconImage(this.frameIcon.getImage());
        this.unpackJarTest(this.basePath, this.configPath, this.appDir, jarName, dirList);
        this.initPhase2();
    }

    private void initPhase2() {
        ErrorMessageLogger.setPath(this.errorLogPath);
        this.fileTypes = new FileTypes(this.fileTypePath);
        this.configValues = new ConfigValues(this);
        this.initFileHandler = new InitFileHandler(this.configPath, this);
        this.initFileHandler.read(this.configValues);
        this.setAntiAliasing();
        ArachComp.setupLookAndFeel(this.configValues.lookAndFeelName);
        this.toolBarPanel = new JPanel();
        this.macroHandler = new MacroHandler(this);
        this.comSwitchboard = new ComSwitchboard(this);
        this.macroKeyHandler = new MacroKeyHandler(this);
        this.beautifyUtils = new BeautifyUtils(this);
        this.htmlValidator = new HTMLValidator(this);
        this.entityProcessor = new EntityProcessor(this);
        this.browserLauncher = new BrowserLauncher(this);
        this.recentFileList = new RecentFileList(this, this.configValues.recentFileListSize, null);
        this.recentFileList.putAll(this.configValues.recentFileList);
        Font font = new Font(this.configValues.programFontName, this.configValues.programFontStyle, this.configValues.programFontSize);
        ArachComp.setProgramFont(font);
        this.macroEditor = new MacroEditor(this);
        this.setTitle("Arachnophilia 5.4");
        this.initComponents();
        this.rightClickProcessor = new RightClickProcessor(this);
        this.showToolBarPanel(this.configValues.showToolBarPanel);
        this.topMainPanel.add((Component)this.toolBarPanel, "North");
        this.getContentPane().remove(this.toolBar);
        this.toolBar.setFloatable(true);
        String string = ArachConstants.barPositions[this.configValues.toolBarPosition];
        this.toolBar.setOrientation(string.equals("North") || string.equals("South") ? 0 : 1);
        this.getContentPane().add((Component)this.toolBar, string);
        this.findReplacePanel = new FindReplacePanel(this);
        this.topMainPanel.add((Component)this.findReplacePanel, "South");
        if (this.configValues.mainDividerMinimized) {
            this.contentSplitPane.setDividerLocation(0.0);
        }
        this.setFont(font);
        this.setJMenuBar(this.mainMenuBar);
        this.fileHandler = new FileListHandler(this.rightTabbedPane, this);
        new DropTarget(this, 3, this);
        this.showCompilerPanel(false, null);
        new DropTarget(this.rightTabbedPane, 3, this);
        this.configValues.lastNewFileType = this.setDefaultFileType(this.configValues.lastNewFileType);
        this.configValues.lastOpenedFileType = this.setDefaultFileType(this.configValues.lastOpenedFileType);
        if (this.comArgs.size() > 0) {
            this.openStringVector(this.comArgs);
        } else {
            this.openStringArray(this.configValues.openFileList);
        }
        this.pack();
        this.rejectResize = false;
        if (this.configValues.maximized) {
            this.setBounds(this.configValues.appBounds);
            this.setExtendedState(6);
            this.testAppDimensions(false);
        } else {
            this.setBounds(this.configValues.appBounds);
            this.testAppDimensions(true);
        }
        this.configureAutoSave();
        this.setVisible(true);
        if (this.installWindow != null) {
            this.installWindow.requestFocus();
            this.installWindow.toFront();
        }
        if (this.configValues.showTipOfTheDay) {
            new TipJFrame(this);
        }
        this.updateStatusBar("");
    }

    String getConfigDir(String string) {
        if (this.comArgs.size() > 0 && new File(this.comArgs.get(0)).isDirectory()) {
            string = this.comArgs.remove(0);
        }
        return string + ArachConstants.SYSTEM_FILESEP + userAppDir;
    }

    public void setAntiAliasing() {
        this.renderHints = new HashMap();
        if (this.configValues.useAntiAliasing) {
            this.renderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        if (this.fileHandler != null) {
            this.fileHandler.refreshCurrentDisplayedDocument();
        }
    }

    private void testJavaVersion() {
        boolean bl;
        String string = System.getProperty("java.version");
        boolean bl2 = bl = this.convertVersionString(string) >= this.convertVersionString("1.5.0");
        if (!bl) {
            JOptionPane.showMessageDialog(this, "Very Sorry!\n\nArachnophilia 5.4 requires a Java runtime engine (JRE)\nwith a version of 1.5.0 or better.\nThis machine has a version " + string + " JRE.\n" + "Please acquire the correct JRE at http://java.com.", "Wrong Java Runtime Version", 2);
            System.exit(0);
        }
    }

    private int convertVersionString(String string) {
        try {
            int n;
            int n2;
            int n3 = string.length();
            for (n2 = 0; n2 < n3 && !Character.isDigit(string.charAt(n2)); ++n2) {
            }
            StringBuffer stringBuffer = new StringBuffer();
            char c = ' ';
            while (true) {
                block10: {
                    block9: {
                        if (n2 >= n3) break block9;
                        char c2 = string.charAt(n2);
                        c = c2;
                        if (Character.isDigit(c2)) break block10;
                    }
                    if (c != 46) break;
                }
                if (Character.isDigit(c)) {
                    stringBuffer.append(c);
                }
                ++n2;
            }
            for (n = Integer.parseInt(stringBuffer.toString()); n > 0 && n < 100; n *= 10) {
            }
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void configureAutoSave() {
        if (this.autoSaveTimer != null) {
            this.autoSaveTimer.stop();
            this.autoSaveTimer = null;
        }
        if (this.configValues.autoSaveIntervalSeconds != 0) {
            this.autoSaveTimer = new Timer(this.configValues.autoSaveIntervalSeconds * 1000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Arachnophilia.this.saveAllChangedDocs();
                }
            });
            this.autoSaveTimer.start();
        }
    }

    public boolean requestFocusEnabled() {
        return true;
    }

    public MacroTreePanel getMacroPanel() {
        return (MacroTreePanel)this.macroPanel;
    }

    private void setInstallFocus() {
        if (this.installWindow != null) {
            this.installWindow.requestFocus();
        }
    }

    public void testAppDimensions(boolean bl) {
        if (this.configValues.maximized) {
            return;
        }
        boolean bl2 = true;
        if (this.configValues.appBounds.width < 75 || this.configValues.appBounds.height < 75) {
            bl2 = false;
        }
        if (this.configValues.appBounds.width + this.configValues.appBounds.x > this.screenSize.width + 16 || this.configValues.appBounds.height + this.configValues.appBounds.y > this.screenSize.height + 16) {
            bl2 = false;
        }
        if (this.configValues.appBounds.x < -40 || this.configValues.appBounds.y < -40) {
            bl2 = false;
        }
        if (!bl2) {
            this.setScreenDefaults(this.configValues, this.screenSize);
            this.setBounds(this.configValues.appBounds);
        }
    }

    private String locateAppDir() {
        String string;
        URL uRL;
        File file;
        String string2;
        String string3 = this.getClass().getName();
        String string4 = "";
        int n = string3.lastIndexOf(".");
        if (n != -1) {
            string4 = string3.substring(0, n);
            string3 = string3.substring(n + 1);
        }
        if ((n = (string2 = (file = new File((uRL = this.getClass().getResource(string3 + ".class")).getPath())).getPath()).lastIndexOf(ArachConstants.SYSTEM_FILESEP)) != -1) {
            string2 = string2.substring(0, n);
            if (string4.length() > 0 && (n = string2.lastIndexOf(string4)) != -1 && (n = (string2 = string2.substring(0, n)).lastIndexOf(ArachConstants.SYSTEM_FILESEP, n)) != -1) {
                string2 = string2.substring(0, n);
            }
            if ((n = string2.lastIndexOf(".jar")) != -1 && (n = string2.lastIndexOf(ArachConstants.SYSTEM_FILESEP, n)) != -1) {
                string2 = string2.substring(0, n);
            }
        }
        if ((n = string2.indexOf(string = "file:")) != -1) {
            string2 = string2.substring(n + string.length());
        }
        string2 = new SearchReplace().srchRplc(string2, "%20", " ");
        return string2;
    }

    public MyJPopupMenu getDocPopup(boolean bl) {
        if (bl) {
            return (MyJPopupMenu)this.plainDocPopup;
        }
        return (MyJPopupMenu)this.syntaxDocPopup;
    }

    public void showMacroEditPanel(boolean bl, boolean bl2) {
        MacroTreePanel macroTreePanel = this.getMacroPanel();
        if (macroTreePanel != null) {
            macroTreePanel.setEditCheckBox(bl);
        }
        this.macroEditShowing = bl;
        if (this.configValues.showMacroEditorInFrame) {
            if (this.rightTabbedPane != null) {
                this.rightTabbedPane.remove(this.macroEditor);
            }
            if (bl) {
                this.macroEditorFrame = new MacroEditorFrame(this, this.macroEditor);
                this.macroEditorFrame.toFront();
            } else if (this.macroEditorFrame != null) {
                this.macroEditorFrame.getContentPane().remove(this.macroEditor);
                this.macroEditorFrame.setVisible(false);
                this.macroEditorFrame.dispose();
                this.macroEditorFrame = null;
            }
        } else {
            if (this.macroEditorFrame != null) {
                this.macroEditorFrame.getContentPane().remove(this.macroEditor);
                this.macroEditorFrame.setVisible(false);
                this.macroEditorFrame.dispose();
                this.macroEditorFrame = null;
            }
            if (bl) {
                if (this.rightTabbedPane.getComponentCount() > 0 && this.rightTabbedPane.getComponentAt(0) instanceof MacroEditor) {
                    if (bl2) {
                        this.rightTabbedPane.setSelectedComponent(this.macroEditor);
                    }
                    return;
                }
                this.rightTabbedPane.insertTab("Macro Editor", null, this.macroEditor, "Macro Editor", 0);
                this.rightTabbedPane.setSelectedComponent(this.macroEditor);
            } else if (this.rightTabbedPane != null) {
                this.rightTabbedPane.remove(this.macroEditor);
            }
        }
    }

    public void showToolBarPanel(boolean bl) {
        this.configValues.showToolBarPanel = bl;
        this.toolBarPanel.setVisible(bl);
    }

    public JPanel getToolBarPanel() {
        return this.toolBarPanel;
    }

    public void clearCompilerPanel() {
        Component component = this.rightSplitPane.getBottomComponent();
        if (component != null && component instanceof ReplyPanel) {
            ReplyPanel replyPanel = (ReplyPanel)component;
            replyPanel.clearDataList();
        }
    }

    public void showCompilerPanel(boolean bl, JPanel jPanel) {
        Component component = this.rightSplitPane.getBottomComponent();
        if (component != null && component instanceof ReplyPanel) {
            ((ReplyPanel)component).destroyThread();
        }
        int n = this.rightSplitPane.getDividerLocation();
        this.rightSplitPane.setBottomComponent(null);
        if (bl) {
            this.rightSplitPane.setBottomComponent(jPanel);
            if (this.rightSplitPane.getDividerSize() == 0) {
                this.rightSplitPane.setDividerLocation(0.66);
                this.rightSplitPane.setDividerSize(10);
            } else {
                this.rightSplitPane.setDividerLocation(n);
            }
        } else {
            this.rightSplitPane.setDividerLocation(1.0);
            this.rightSplitPane.setDividerSize(0);
        }
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    private int setDefaultFileType(int n) {
        if (n < 0) {
            n = this.fileTypes.getFileTypeForName("Text");
        }
        return n;
    }

    public void unpackJarTest(String string, String string2, String string3, String string4, String[] stringArray) {
        File file = new File(string);
        File file2 = new File(string2);
        if (!file2.exists()) {
            this.installWindow = new SplashWindow(this);
            if (!file.exists()) {
                this.installWindow.append("Creating directory " + file.getName());
                file.mkdir();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.unpackJarTest2(string, string3, string4, stringArray[i], this.installWindow);
            }
            this.installWindow.append("*** Installation complete ***");
        }
    }

    public void unpackJarTest2(String string, String string2, String string3, String string4, SplashWindow splashWindow) {
        String string5 = string + ArachConstants.SYSTEM_FILESEP + string4;
        try {
            File file = new File(string5);
            if (!file.exists()) {
                this.installWindow.append("Creating directory " + file.getName());
                file.mkdir();
            }
            String string6 = string2 + "/" + string3;
            ZipFile zipFile = new ZipFile(string6);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                String string7;
                ZipEntry zipEntry = enumeration.nextElement();
                String string8 = zipEntry.toString();
                int n = string8.lastIndexOf("/");
                if (n == -1 || !(string7 = string8.substring(0, n)).equals(string4)) continue;
                splashWindow.append("Moving " + string8);
                String string9 = string8.substring(n + 1);
                String string10 = string5 + "/" + string9;
                n = string9.indexOf(46);
                if (n == -1) continue;
                if (this.testIsBinary(string10)) {
                    this.copyZipBinaryFile(zipFile, zipEntry, string10);
                    continue;
                }
                this.copyZipTextFile(zipFile, zipEntry, string10);
            }
            zipFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean testIsBinary(String string) {
        return string.endsWith(".class") || string.endsWith(".zip") || string.endsWith(".gif") || string.endsWith(".jpg") || string.endsWith(".png");
    }

    public void undo() {
        if (this.currentSelectedDocument != null) {
            this.currentSelectedDocument.undo();
        }
    }

    public void redo() {
        if (this.currentSelectedDocument != null) {
            this.currentSelectedDocument.redo();
        }
    }

    public void copyZipBinaryFile(ZipFile zipFile, ZipEntry zipEntry, String string) {
        try {
            int n;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string)));
            int n2 = 8192;
            byte[] byArray = new byte[n2];
            while ((n = bufferedInputStream.read(byArray, 0, n2)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void copyZipTextFile(ZipFile zipFile, ZipEntry zipEntry, String string) {
        try {
            int n;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 8192;
            byte[] byArray = new byte[n2];
            while ((n = bufferedInputStream.read(byArray, 0, n2)) != -1) {
                stringBuffer.append(new String(byArray, 0, n));
            }
            bufferedInputStream.close();
            String string2 = stringBuffer.toString();
            string2 = ArachComp.toJavaLineEndings(string2);
            string2 = ArachComp.toSystemLineEndings(string2);
            if (string.indexOf(docDirName) >= 0 && string.indexOf(".html") >= 0) {
                string2 = string2.replaceAll("\\(user home directory\\)", this.userHome);
            }
            File file = new File(string);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            bufferedWriter.write(string2);
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void readZipMacroFile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.appDir + "/" + jarName;
        try {
            ZipFile zipFile = new ZipFile(string2);
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry != null) {
                int n;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(zipEntry)));
                int n2 = 8192;
                char[] cArray = new char[n2];
                while ((n = bufferedReader.read(cArray, 0, n2)) != -1) {
                    stringBuffer.append(cArray);
                }
                bufferedReader.close();
                String string3 = ArachComp.toJavaLineEndings(stringBuffer.toString());
                this.getMacroPanel().mjt.readRescueMacroString(string, string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void getRescueMacroSet() {
        this.readZipMacroFile("Macros/Macros.xml");
    }

    public void updateStatusBar(String string) {
        this.statusBar.setText(string + " Encoding: " + this.configValues.fileEncoding);
    }

    private void openStringArray(String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file;
                if (stringArray[i].length() <= 0 || !(file = new File(stringArray[i])).exists() || !file.isFile()) continue;
                this.openDoc(file, true, false);
            }
            this.fileHandler.setFocusTo(this.latestOpenedDocument);
        }
    }

    private void openStringVector(Vector<String> vector) {
        this.openStringArray(vector.toArray(new String[0]));
    }

    private void openFileArray(File[] fileArray) {
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                this.openDoc(fileArray[i], true, false);
            }
            this.fileHandler.setFocusTo(this.latestOpenedDocument);
        }
    }

    private void setScreenDefaults(ConfigValues configValues, Dimension dimension) {
        int n = dimension.width / 8;
        int n2 = dimension.height / 8;
        configValues.appBounds.width = dimension.width - n * 2;
        configValues.appBounds.height = dimension.height - n2 * 2;
        configValues.appBounds.x = n;
        configValues.appBounds.y = n2;
    }

    public boolean processRightClick(MouseEvent mouseEvent, ArachDocument arachDocument) {
        return this.rightClickProcessor.processRightClickEvent(mouseEvent, arachDocument);
    }

    private void initComponents() {
        this.mainMenuBar = new JMenuBar();
        this.rootPopup = new MyJPopupMenu();
        this.syntaxDocPopup = new MyJPopupMenu();
        this.plainDocPopup = new MyJPopupMenu();
        this.toolBar = new JToolBar();
        this.borderPanel = new JPanel();
        this.mainPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.statusBar = new JLabel();
        this.contentSplitPane = new JSplitPane();
        this.macroPanel = new MacroTreePanel(this);
        this.rightSplitPane = new JSplitPane();
        this.rightTabbedPane = new JTabbedPane();
        this.topMainPanel = new JPanel();
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                Arachnophilia.this.formComponentMoved(componentEvent);
            }

            public void componentResized(ComponentEvent componentEvent) {
                Arachnophilia.this.formComponentResized(componentEvent);
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                Arachnophilia.this.formFocusGained(focusEvent);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                Arachnophilia.this.formKeyPressed(keyEvent);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Arachnophilia.this.exitForm(windowEvent);
            }
        });
        this.getContentPane().add((Component)this.toolBar, "North");
        this.borderPanel.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new BorderLayout());
        this.bottomPanel.setLayout(new BorderLayout());
        this.statusBar.setToolTipText("Status of activities");
        this.bottomPanel.add((Component)this.statusBar, "Center");
        this.mainPanel.add((Component)this.bottomPanel, "South");
        this.contentSplitPane.setMinimumSize(new Dimension(8, 12));
        this.contentSplitPane.setOneTouchExpandable(true);
        this.macroPanel.setBackground(Color.white);
        this.contentSplitPane.setLeftComponent(this.macroPanel);
        this.rightSplitPane.setDividerLocation(1000);
        this.rightSplitPane.setOrientation(0);
        this.rightSplitPane.setOneTouchExpandable(true);
        this.rightTabbedPane.setTabPlacement(3);
        this.rightTabbedPane.setToolTipText("<html>Double-click to open a document,<br>right-click for context menu,<br>or drag &amp; drop files</html>");
        this.rightTabbedPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Arachnophilia.this.rightTabbedPaneMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Arachnophilia.this.rightTabbedPaneMouseReleased(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                Arachnophilia.this.rightTabbedPaneMouseClicked(mouseEvent);
            }
        });
        this.rightSplitPane.setTopComponent(this.rightTabbedPane);
        this.contentSplitPane.setRightComponent(this.rightSplitPane);
        this.mainPanel.add((Component)this.contentSplitPane, "Center");
        this.topMainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.topMainPanel, "North");
        this.borderPanel.add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.borderPanel, "Center");
    }

    private void formComponentMoved(ComponentEvent componentEvent) {
        this.handleResize();
    }

    private void formComponentResized(ComponentEvent componentEvent) {
        this.handleResize();
    }

    private void rightTabbedPaneMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            this.openDoc();
        }
    }

    private void formFocusGained(FocusEvent focusEvent) {
        this.setInstallFocus();
        if (this.currentSelectedDocument != null) {
            this.currentSelectedDocument.requestFocus();
        }
    }

    private void formKeyPressed(KeyEvent keyEvent) {
        this.handleKey(keyEvent);
    }

    private void rightTabbedPaneMouseReleased(MouseEvent mouseEvent) {
        this.launchPanePopup(mouseEvent);
    }

    private void rightTabbedPaneMousePressed(MouseEvent mouseEvent) {
        this.launchPanePopup(mouseEvent);
    }

    private void detectDividerLocation() {
        Dimension dimension = this.contentSplitPane.getLeftComponent().getSize();
        this.configValues.mainDividerMinimized = (double)dimension.width < 4.0;
    }

    private void handleResize() {
        if (this.rejectResize) {
            return;
        }
        int n = this.getExtendedState();
        boolean bl = this.configValues.maximized = n == 6;
        if (!this.configValues.maximized) {
            this.configValues.appBounds = this.getBounds();
        }
    }

    public void toggleLineWrap() {
        if (this.currentSelectedDocument != null) {
            this.currentSelectedDocument.toggleLineWrap();
        }
    }

    public void toggleLineNumbers() {
        if (this.currentSelectedDocument != null) {
            this.currentSelectedDocument.toggleLineNumbers();
        }
    }

    public void toggleEOLMarks() {
        if (this.currentSelectedDocument != null) {
            this.currentSelectedDocument.toggleEOLMarks();
        }
    }

    public void changeDisplayModes(boolean bl) {
        if (this.currentSelectedDocument != null) {
            this.currentSelectedDocument.changeDisplayModes(bl);
        }
    }

    public JComponent getMenu(String string) {
        if (string.equals("_SyntaxDocPopup")) {
            return this.syntaxDocPopup;
        }
        if (string.equals("_PlainDocPopup")) {
            return this.plainDocPopup;
        }
        if (string.equals("_RootPopup")) {
            return this.rootPopup;
        }
        return this.mainMenuBar;
    }

    private void handleKey(KeyEvent keyEvent) {
        this.macroKeyHandler.execute(keyEvent);
    }

    public void setEditFont() {
        if (this.fileHandler.openCount() > 0) {
            JOptionPane.showMessageDialog(this, "Please close all documents before changing editor fonts.", "Documents open", 0);
            return;
        }
        Font font = new Font(this.configValues.editFontName, this.configValues.editFontStyle, this.configValues.editFontSize);
        FontChooser fontChooser = new FontChooser((Frame)this, true, font, "Choose Editing Font");
        if (fontChooser.showDialog()) {
            this.configValues.editFontName = fontChooser.currentFont.getName();
            this.configValues.editFontStyle = fontChooser.currentFont.getStyle();
            this.configValues.editFontSize = fontChooser.currentFont.getSize();
            ArachDocument[] arachDocumentArray = this.fileHandler.docArray();
            int n = arachDocumentArray.length;
            for (int i = 0; i < n; ++i) {
                arachDocumentArray[i].setNewFont();
            }
        }
    }

    public void openDoc() {
        this.promptDoc(this.configValues.lastOpenedFileType);
    }

    public void newDoc() {
        this.newDoc(this.configValues.lastNewFileType, true);
    }

    public void launchBrowser(String string) {
        boolean bl;
        block6: {
            bl = false;
            if (string.length() > 0) {
                try {
                    URL uRL = new URL(string);
                    this.browserLauncher.launchDefaultBrowserWithURL(uRL.toString());
                    bl = true;
                }
                catch (MalformedURLException malformedURLException) {
                    if (!new File(string).exists()) break block6;
                    this.browserLauncher.launchBrowser(null, string);
                    bl = true;
                }
            }
        }
        if (!bl) {
            if (this.currentSelectedDocument != null) {
                this.currentSelectedDocument.launchBrowser(string);
            } else {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this, "You cannot launch a browser\nwithout a document to view.\nPlease open an HTML\ndocument and try again.", "No open document", 1);
            }
        }
    }

    public void replace(String string) {
        if (string != null) {
            this.findReplacePanel.getReplaceList().getEditor().setItem(string);
        }
        this.findReplacePanel.doReplace(true);
    }

    public void findFirst(String string) {
        if (string != null) {
            this.findReplacePanel.getFindList().getEditor().setItem(string);
        }
        this.findReplacePanel.doFirstFind(true);
    }

    public void findNext(String string) {
        if (string != null) {
            this.findReplacePanel.getFindList().getEditor().setItem(string);
        }
        this.findReplacePanel.doNextFind(true);
    }

    private void launchPanePopup(MouseEvent mouseEvent) {
        if (this.rootPopup.isPopupTrigger(mouseEvent)) {
            ((MyJPopupMenu)this.rootPopup).show(this.rightTabbedPane, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void setTabSize(int n) {
        Object object;
        if (n == 0) {
            object = String.valueOf(this.configValues.tabSize);
            if ((object = new TextInputDialog(this).showDialog("Change tab size", "The entered tab size is used to expand displayed tabs, and as a guide to convert tabs to spaces.", (String)object)) != null) {
                n = Integer.parseInt((String)object);
            }
        }
        if (n > 0) {
            this.configValues.tabSize = n;
            object = this.fileHandler.docArray();
            for (int i = 0; i < ((ArachDocument[])object).length; ++i) {
                ArachDocument arachDocument = object[i];
                if (arachDocument == null) continue;
                arachDocument.setTabSize();
                arachDocument.repaint();
            }
        }
    }

    public void editSelectAll() {
        ArachDocument arachDocument = this.currentSelectedDocument;
        if (arachDocument != null) {
            arachDocument.textComp.selectAll();
        }
    }

    public void setProgramFont() {
        FontChooser fontChooser = new FontChooser((Frame)this, true, this.getFont(), "Choose Program Font");
        if (fontChooser.showDialog()) {
            ArachComp.setProgramFont(fontChooser.currentFont);
            this.setFont(fontChooser.currentFont);
            SwingUtilities.updateComponentTreeUI(this.getContentPane());
            ArachComp.resetFont(this, fontChooser.currentFont);
            this.invalidate();
            this.repaint();
        }
    }

    public void createHTMLDocForRTFConversion(String string) {
        String string2 = this.basePath + "/" + templateDirName + "/RTFConversionTemplate.html";
        int n = this.fileTypes.getFileTypeForName("HTML");
        this.fileHandler.newDoc(string2, this, n, false, false);
        this.currentSelectedDocument.textComp.replaceSelection(string);
    }

    public void createHTMLDocFromString(String string) {
        this.createDocWithString("HTML", string);
    }

    public void listKeyMappings() {
        this.createDocWithString("Text", this.macroKeyHandler.listDefs());
    }

    public void listSystemCommands() {
        this.createDocWithString("Text", this.comSwitchboard.formatCommandList());
    }

    public void createDocWithString(String string, String string2) {
        int n = this.fileTypes.getFileTypeForName(string);
        boolean bl = this.newDoc(n, true);
        if (bl && this.currentSelectedDocument != null) {
            this.currentSelectedDocument.textComp.setText(string2);
            this.currentSelectedDocument.textComp.setCaretPosition(0);
            this.currentSelectedDocument.docChanged = false;
            this.currentSelectedDocument.updateTitle();
        }
    }

    public boolean newDoc(int n, boolean bl) {
        boolean bl2;
        if (!this.fileTypes.isValidTextFile(n)) {
            n = this.fileTypes.getFileTypeForName("Text");
        }
        String string = "";
        if (bl) {
            string = this.basePath + "/" + templateDirName + "/template." + this.fileTypes.fileTemplateSuffs[n];
        }
        if (bl2 = this.createNewEditorDoc(string, n, false)) {
            this.configValues.lastNewFileType = n;
        }
        return bl2;
    }

    private boolean createNewEditorDoc(String string, int n, boolean bl) {
        boolean bl2 = this.fileTypes.isValidTextFile(n);
        if (bl2) {
            bl2 = this.fileHandler.newDoc(string, this, n, bl, false);
        }
        return bl2;
    }

    public void promptDoc(int n) {
        PickerDialog pickerDialog;
        String string = this.configValues.fileTypePaths[n];
        this.fileTypes.setFileType(n);
        if (string.length() > 0) {
            File file = new File(string);
            pickerDialog = new PickerDialog(this, file, this.fileTypes, 0);
        } else {
            pickerDialog = new PickerDialog(this, this.fileTypes, 0);
        }
        pickerDialog.setDialogTitle("Open " + this.fileTypes.fileTypeNames[n] + " file");
        int n2 = pickerDialog.showOpenDialog();
        if (n2 == 1) {
            File[] fileArray = pickerDialog.getSelectedFiles();
            this.openFileArray(fileArray);
        }
    }

    public boolean openDoc(File file, boolean bl, boolean bl2) {
        boolean bl3 = false;
        ArachDocument arachDocument = this.fileHandler.findExisting(file);
        if (arachDocument != null) {
            this.latestOpenedDocument = arachDocument;
            bl3 = true;
        } else {
            try {
                String string = file.getCanonicalPath();
                int n = this.fileTypes.getFileType(string);
                if (n >= 0 && n < this.configValues.fileTypePaths.length) {
                    this.configValues.fileTypePaths[n] = ArachComp.pathFromFullPath(file.getPath());
                    this.configValues.fileTypePaths[0] = ArachComp.pathFromFullPath(file.getPath());
                    bl3 = this.createNewEditorDoc(string, n, bl);
                    if (!bl3) {
                        JOptionPane.showMessageDialog(this, string + "\nThis file type cannot be opened for text editing.", "Cannot edit this file type", 0);
                    }
                    if (bl && bl3) {
                        this.recentFileList.put(string);
                        this.configValues.lastOpenedFileType = n;
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (bl3 && bl2) {
            this.fileHandler.setFocusTo(this.latestOpenedDocument);
        }
        return bl3;
    }

    public boolean saveAllChangedDocs() {
        boolean bl = true;
        ArachDocument[] arachDocumentArray = this.fileHandler.docArray();
        for (int i = 0; i < arachDocumentArray.length; ++i) {
            if (this.saveDoc(arachDocumentArray[i], false, false, false)) continue;
            bl = false;
        }
        return bl;
    }

    public boolean saveActiveDoc(boolean bl, boolean bl2) {
        ArachDocument arachDocument = this.currentSelectedDocument;
        return this.saveDoc(arachDocument, bl, false, bl2);
    }

    private boolean saveDoc(ArachDocument arachDocument, boolean bl, boolean bl2, boolean bl3) {
        if (arachDocument != null) {
            if (!arachDocument.isFile) {
                bl = true;
            }
            if (bl) {
                return arachDocument.saveFileAs(bl3);
            }
            return arachDocument.saveFile(bl2, bl3, true);
        }
        return false;
    }

    public void closeCurrentDoc() {
        this.closeDoc(this.currentSelectedDocument);
    }

    public void closeDoc(ArachDocument arachDocument) {
        if (arachDocument != null) {
            arachDocument.saveClose(true);
        }
    }

    public void closeAllDocs() {
        ArachDocument[] arachDocumentArray = this.fileHandler.docArray();
        for (int i = 0; i < arachDocumentArray.length; ++i) {
            ArachDocument arachDocument = arachDocumentArray[i];
            arachDocument.saveClose(true);
        }
    }

    public void editCut() {
        ArachDocument arachDocument = this.currentSelectedDocument;
        if (arachDocument != null) {
            arachDocument.undoPush();
            arachDocument.textComp.cut();
        }
    }

    public void editCopy() {
        ArachDocument arachDocument = this.currentSelectedDocument;
        if (arachDocument != null) {
            arachDocument.textComp.copy();
        }
    }

    public void editPaste() {
        ArachDocument arachDocument = this.currentSelectedDocument;
        if (arachDocument != null) {
            arachDocument.undoPush();
            arachDocument.textComp.paste();
        }
    }

    private void exitForm(WindowEvent windowEvent) {
        this.quit();
    }

    public void quit() {
        if (this.exitTest()) {
            System.exit(0);
        }
    }

    private boolean exitTest() {
        ArachDocument arachDocument;
        int n;
        boolean bl = true;
        Dimension dimension = this.toolBar.getSize();
        Point point = this.toolBar.getLocation();
        this.configValues.toolBarPosition = dimension.width > dimension.height ? (point.y > 0 ? 2 : 0) : (point.x > 0 ? 1 : 3);
        ArachDocument[] arachDocumentArray = this.fileHandler.docArray();
        int n2 = arachDocumentArray.length;
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < n2; ++n) {
            arachDocument = arachDocumentArray[n];
            if (!arachDocument.isFile) continue;
            String string = arachDocument.fullPath;
            vector.add(string);
        }
        for (n = 0; n < n2; ++n) {
            arachDocument = arachDocumentArray[n];
            if (arachDocument.saveClose(true)) continue;
            bl = false;
        }
        if (bl) {
            this.detectDividerLocation();
            this.configValues.toolBarPosition = this.computeToolBarPosition(this.toolBar);
            this.configValues.programFontName = this.getFont().getName();
            this.configValues.programFontStyle = this.getFont().getStyle();
            this.configValues.programFontSize = this.getFont().getSize();
            this.configValues.openFileListSize = vector.size();
            this.configValues.openFileList = vector.toArray(new String[vector.size()]);
            this.configValues.recentFileList = this.recentFileList.getAll();
            this.handleResize();
            this.findReplacePanel.saveStrings();
            this.macroEditor.saveOnExit();
            this.getMacroPanel().saveOnExit();
            if (this.spellCheckFrame != null) {
                this.spellCheckFrame.saveAndQuit();
            }
            this.initFileHandler.write(this.configValues);
        }
        return bl;
    }

    private int computeToolBarPosition(JToolBar jToolBar) {
        int n = 0;
        int n2 = jToolBar.getOrientation();
        Dimension dimension = this.getSize();
        Rectangle rectangle = jToolBar.getBounds();
        n = n2 == 1 ? (rectangle.x > dimension.width / 2 ? 1 : 3) : (rectangle.y > dimension.height / 2 ? 2 : 0);
        return n;
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        dropTargetDropEvent.acceptDrop(1);
        Vector<File> vector = new Vector<File>();
        if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            try {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : list) {
                    if (!file.isFile()) continue;
                    vector.add(file);
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                System.out.println(unsupportedFlavorException);
            }
        } else {
            try {
                String string;
                InputStreamReader inputStreamReader = (InputStreamReader)transferable.getTransferData(DataFlavor.selectBestTextFlavor(dropTargetDropEvent.getCurrentDataFlavors()));
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((string = bufferedReader.readLine()) != null) {
                    File file = new File(string = string.replaceFirst("file:", ""));
                    if (!file.isFile()) continue;
                    vector.add(file);
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        if (vector.size() > 0) {
            dropTargetDropEvent.dropComplete(true);
            this.openFileArray(vector.toArray(new File[0]));
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public static void main(String[] stringArray) {
        new Arachnophilia(stringArray);
    }
}

