/*
 * Decompiled with CFR 0.152.
 */
package RTFConverter;

import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;

class HTMLStateMachine {
    String[] alignNames = new String[]{"left", "center", "right"};
    public boolean acceptFonts = true;
    private String fontName = "";
    private int alignment = -1;
    private boolean bold = false;
    private boolean italic = false;
    private boolean underline = false;
    private Color color = null;
    private int size = -1;
    private double firstLineIndent = 0.0;
    private double oldLeftIndent = 0.0;
    private double oldRightIndent = 0.0;
    private double leftIndent = 0.0;
    private double rightIndent = 0.0;
    private boolean firstLine = false;

    HTMLStateMachine() {
    }

    public void updateState(AttributeSet attributeSet, StringBuffer stringBuffer, Element element) {
        String string = element.getName();
        if (string.equalsIgnoreCase("paragraph")) {
            this.firstLine = true;
        }
        this.leftIndent = this.updateDouble(attributeSet, this.leftIndent, StyleConstants.LeftIndent);
        this.rightIndent = this.updateDouble(attributeSet, this.rightIndent, StyleConstants.RightIndent);
        if (this.leftIndent != this.oldLeftIndent || this.rightIndent != this.oldRightIndent) {
            this.closeIndentTable(stringBuffer, this.oldLeftIndent, this.oldRightIndent);
        }
        this.bold = this.updateBoolean(attributeSet, StyleConstants.Bold, "b", this.bold, stringBuffer);
        this.italic = this.updateBoolean(attributeSet, StyleConstants.Italic, "i", this.italic, stringBuffer);
        this.underline = this.updateBoolean(attributeSet, StyleConstants.Underline, "u", this.underline, stringBuffer);
        this.size = this.updateFontSize(attributeSet, this.size, stringBuffer);
        this.color = this.updateFontColor(attributeSet, this.color, stringBuffer);
        if (this.acceptFonts) {
            this.fontName = this.updateFontName(attributeSet, this.fontName, stringBuffer);
        }
        this.alignment = this.updateAlignment(attributeSet, this.alignment, stringBuffer);
        this.firstLineIndent = this.updateDouble(attributeSet, this.firstLineIndent, StyleConstants.FirstLineIndent);
        if (this.leftIndent != this.oldLeftIndent || this.rightIndent != this.oldRightIndent) {
            this.openIndentTable(stringBuffer, this.leftIndent, this.rightIndent);
            this.oldLeftIndent = this.leftIndent;
            this.oldRightIndent = this.rightIndent;
        }
    }

    private void openIndentTable(StringBuffer stringBuffer, double d, double d2) {
        if (d != 0.0 || d2 != 0.0) {
            this.closeSubsetTags(stringBuffer);
            stringBuffer.append("<table><tr>");
            String string = this.getSpaceTab((int)(d / 4.0));
            if (string.length() > 0) {
                stringBuffer.append("<td>" + string + "</td>");
            }
            stringBuffer.append("<td>");
        }
    }

    private void closeIndentTable(StringBuffer stringBuffer, double d, double d2) {
        if (d != 0.0 || d2 != 0.0) {
            this.closeSubsetTags(stringBuffer);
            stringBuffer.append("</td>");
            String string = this.getSpaceTab((int)(d2 / 4.0));
            if (string.length() > 0) {
                stringBuffer.append("<td>" + string + "</td>");
            }
            stringBuffer.append("</tr></table>");
        }
    }

    public void closeTags(StringBuffer stringBuffer) {
        this.closeSubsetTags(stringBuffer);
        this.closeTag(this.alignment, -1, "div", stringBuffer);
        this.alignment = -1;
        this.closeIndentTable(stringBuffer, this.oldLeftIndent, this.oldRightIndent);
    }

    private void closeSubsetTags(StringBuffer stringBuffer) {
        this.closeTag(this.bold, "b", stringBuffer);
        this.closeTag(this.italic, "i", stringBuffer);
        this.closeTag(this.underline, "u", stringBuffer);
        this.closeTag(this.color, "font", stringBuffer);
        this.closeTag(this.fontName, "font", stringBuffer);
        this.closeTag(this.size, -1, "font", stringBuffer);
        this.bold = false;
        this.italic = false;
        this.underline = false;
        this.color = null;
        this.fontName = "";
        this.size = -1;
    }

    private void closeTag(boolean bl, String string, StringBuffer stringBuffer) {
        if (bl) {
            stringBuffer.append("</" + string + ">");
        }
    }

    private void closeTag(Color color, String string, StringBuffer stringBuffer) {
        if (color != null) {
            stringBuffer.append("</" + string + ">");
        }
    }

    private void closeTag(String string, String string2, StringBuffer stringBuffer) {
        if (string.length() > 0) {
            stringBuffer.append("</" + string2 + ">");
        }
    }

    private void closeTag(int n, int n2, String string, StringBuffer stringBuffer) {
        if (n > n2) {
            stringBuffer.append("</" + string + ">");
        }
    }

    private int updateAlignment(AttributeSet attributeSet, int n, StringBuffer stringBuffer) {
        Object object = attributeSet.getAttribute(StyleConstants.Alignment);
        if (object != null) {
            int n2 = (Integer)object;
            if (n2 == 3) {
                n2 = 0;
            }
            if (n2 != n && n2 >= 0 && n2 <= 2) {
                if (n > -1) {
                    stringBuffer.append("</div>");
                }
                stringBuffer.append("<div align=\"" + this.alignNames[n2] + "\">");
                n = n2;
            }
        }
        return n;
    }

    private Color updateFontColor(AttributeSet attributeSet, Color color, StringBuffer stringBuffer) {
        Object object = attributeSet.getAttribute(StyleConstants.Foreground);
        if (object != null) {
            Color color2 = (Color)object;
            if (color2 != color) {
                if (color != null) {
                    stringBuffer.append("</font>");
                }
                if (color2 != null) {
                    stringBuffer.append("<font color=\"#" + this.makeColorString(color2) + "\">");
                }
            }
            color = color2;
        }
        return color;
    }

    private String updateFontName(AttributeSet attributeSet, String string, StringBuffer stringBuffer) {
        Object object = attributeSet.getAttribute(StyleConstants.FontFamily);
        if (object != null) {
            String string2 = (String)object;
            if (!string2.equals(string)) {
                if (!string.equals("")) {
                    stringBuffer.append("</font>");
                }
                stringBuffer.append("<font face=\"" + string2 + "\">");
            }
            string = string2;
        }
        return string;
    }

    private double updateDouble(AttributeSet attributeSet, double d, Object object) {
        Object object2 = attributeSet.getAttribute(object);
        if (object2 != null) {
            d = ((Float)object2).floatValue();
        }
        return d;
    }

    private int updateFontSize(AttributeSet attributeSet, int n, StringBuffer stringBuffer) {
        Object object = attributeSet.getAttribute(StyleConstants.FontSize);
        if (object != null) {
            int n2 = (Integer)object;
            if (n2 != n) {
                if (n != -1) {
                    stringBuffer.append("</font>");
                }
                stringBuffer.append("<font size=\"" + n2 / 4 + "\">");
            }
            n = n2;
        }
        return n;
    }

    private boolean updateBoolean(AttributeSet attributeSet, Object object, String string, boolean bl, StringBuffer stringBuffer) {
        Object object2 = attributeSet.getAttribute(object);
        if (object2 != null) {
            boolean bl2 = (Boolean)object2;
            if (bl2 != bl) {
                if (bl2) {
                    stringBuffer.append("<" + string + ">");
                } else {
                    stringBuffer.append("</" + string + ">");
                }
            }
            bl = bl2;
        }
        return bl;
    }

    private String makeColorString(Color color) {
        String string = Long.toString(color.getRGB() & 0xFFFFFF, 16);
        if (string.length() < 6) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = string.length(); i < 6; ++i) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
            string = stringBuffer.toString();
        }
        return string;
    }

    public String performFirstLineIndent(String string) {
        if (this.firstLine) {
            if (this.firstLineIndent != 0.0) {
                int n = (int)(this.firstLineIndent / 4.0);
                string = this.getSpaceTab(n) + string;
            }
            this.firstLine = false;
        }
        return string;
    }

    public String getSpaceTab(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("&nbsp;");
        }
        return stringBuffer.toString();
    }
}

