/*
 * Decompiled with CFR 0.152.
 */
package FileTypes;

import Arachnophilia.ArachDocument;
import Arachnophilia.Arachnophilia;
import FileTypes.SetFileTypeDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SetFileType
extends JPanel {
    Arachnophilia main;
    ArachDocument doc;
    SetFileTypeDialog parent;
    boolean needInit = true;
    int fileType;
    String[] initialData;
    private JPanel southPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JScrollPane centerPane;
    private JList fileTypeList;
    private JScrollPane northPane;
    private JTextArea messageArea;

    public SetFileType(Arachnophilia arachnophilia, SetFileTypeDialog setFileTypeDialog, ArachDocument arachDocument) {
        this.main = arachnophilia;
        this.parent = setFileTypeDialog;
        this.doc = arachDocument;
        this.initialData = this.main.fileTypes.getFileTypeNames();
        this.initComponents();
        this.fileType = this.doc.getFileType();
        Rectangle rectangle = this.fileTypeList.getCellBounds(0, 0);
        int n = rectangle.height * this.initialData.length;
        Dimension dimension = new Dimension(this.fileTypeList.getSize().width, n);
        this.fileTypeList.setPreferredSize(dimension);
        if (this.fileType >= 0) {
            this.fileTypeList.setSelectedIndex(this.fileType);
        }
        String string = "Choose a file type for the current document. This choice affects syntax coloring and code beautification. Press \"OK\" to accept the current choice.";
        this.messageArea.setText(string);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.needInit) {
            this.needInit = false;
            this.fileTypeList.ensureIndexIsVisible(this.fileType);
        }
    }

    private void acceptChoice() {
        int n = this.fileTypeList.getSelectedIndex();
        this.doc.changeFileType(n);
        this.parent.quit();
    }

    private void cancelChoice() {
        this.parent.quit();
    }

    private void initComponents() {
        this.southPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.centerPane = new JScrollPane();
        this.fileTypeList = new JList<String>(this.initialData);
        this.northPane = new JScrollPane();
        this.messageArea = new JTextArea();
        this.setLayout(new BorderLayout());
        this.okButton.setText("OK");
        this.okButton.setToolTipText("Accept the present choice");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetFileType.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.southPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Discard this choice, make no change");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetFileType.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.southPanel.add(this.cancelButton);
        this.add((Component)this.southPanel, "South");
        this.centerPane.setPreferredSize(new Dimension(400, 100));
        this.fileTypeList.setPreferredSize(new Dimension(500, 200));
        this.fileTypeList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SetFileType.this.fileTypeListMouseClicked(mouseEvent);
            }
        });
        this.centerPane.setViewportView(this.fileTypeList);
        this.add((Component)this.centerPane, "Center");
        this.northPane.setPreferredSize(new Dimension(400, 100));
        this.messageArea.setBackground(new Color(204, 204, 204));
        this.messageArea.setEditable(false);
        this.messageArea.setLineWrap(true);
        this.messageArea.setWrapStyleWord(true);
        this.messageArea.setMargin(new Insets(8, 8, 8, 8));
        this.messageArea.setPreferredSize(new Dimension(500, 200));
        this.northPane.setViewportView(this.messageArea);
        this.add((Component)this.northPane, "North");
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.cancelChoice();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.acceptChoice();
    }

    private void fileTypeListMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            this.acceptChoice();
        }
    }
}

