/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import java.util.Collections;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LiTagResolver {
    static String lineEnding;
    static String targetTag;
    static Pattern sourceTagPat;
    static Pattern allGroups;
    static Pattern openGroup;
    static Pattern closeGroup;

    private LiTagResolver() {
    }

    static int regexFind(String string, Pattern pattern, int n) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find(n)) {
            return matcher.start();
        }
        return -1;
    }

    static int findClosingLi(String string, int n) {
        int n2 = 0;
        do {
            ++n;
            if ((n = LiTagResolver.regexFind(string, allGroups, n)) < 0) continue;
            if (LiTagResolver.regexFind(string, openGroup, n) == n) {
                ++n2;
            }
            if (n2 == 0 && LiTagResolver.regexFind(string, allGroups, n) == n) {
                return n;
            }
            if (LiTagResolver.regexFind(string, closeGroup, n) != n) continue;
            --n2;
        } while (n >= 0);
        return n;
    }

    public static String resolve(String string) {
        Stack<Integer> stack = new Stack<Integer>();
        string = string.replaceAll("</li>", "");
        int n = 0;
        int n2 = 0;
        do {
            if ((n = LiTagResolver.regexFind(string, sourceTagPat, n)) >= 0 && (n2 = LiTagResolver.findClosingLi(string, n)) >= 0) {
                stack.push(new Integer(n2));
            }
            if (n < 0) continue;
            ++n;
        } while (n != -1);
        Collections.sort(stack);
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = targetTag + "\n";
        while (!stack.empty()) {
            int n3 = (Integer)stack.pop();
            stringBuffer.insert(n3, string2);
        }
        return stringBuffer.toString();
    }

    static {
        targetTag = "</li>";
        sourceTagPat = Pattern.compile("<li\\b");
        allGroups = Pattern.compile("</?(li|ol|ul)\\b");
        openGroup = Pattern.compile("<(ul|ol)\\b");
        closeGroup = Pattern.compile("</(ul|ol)\\b");
    }
}

