/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import Arachnophilia.ArachComp;
import Arachnophilia.ArachDocument;
import Arachnophilia.Arachnophilia;
import Arachnophilia.CodeBeautifier;
import Arachnophilia.DocContentHandler;
import Arachnophilia.DocToHTMLConverter;
import Arachnophilia.EscapeUnescapeStringHandler;
import Arachnophilia.JumpToOppositeTag;
import Arachnophilia.LiTagResolver;
import Arachnophilia.SearchReplace;
import Arachnophilia.TextInterface;
import CustomClassFunctions.CustomClassHandler;
import FileTypes.SetFileTypeDialog;
import GotoFunctions.Goto;
import java.awt.Color;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;

public final class DocumentProcessingFunctions {
    Arachnophilia main;
    int selectionStart;
    int selectionEnd;
    int firstLine;
    int cp;
    int origLen;
    int finalLen;
    ArachDocument doc;
    String content;
    DocContentHandler docHandler;
    SearchReplace searchReplace;
    boolean selectionValid = false;

    DocumentProcessingFunctions(Arachnophilia arachnophilia) {
        this.main = arachnophilia;
        this.docHandler = new DocContentHandler(arachnophilia);
        this.searchReplace = new SearchReplace();
        this.doc = this.main.currentSelectedDocument;
    }

    public int checkRange(int n, TextInterface textInterface) {
        int n2 = textInterface.getLength();
        n = n < 0 ? 0 : n;
        n = n > n2 ? n2 : n;
        return n;
    }

    private String blockInOutDent(String string, int n) {
        String string2 = ArachComp.getTabString();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 10;
        Vector vector = ArachComp.parseDelimLine(string, "\n");
        int n3 = vector.size();
        int n4 = string2.length();
        int n5 = vector.size();
        for (int i = 0; i < n5; ++i) {
            String string3 = i < n5 - 1 ? "\n" : "";
            String string4 = (String)vector.get(i);
            int n6 = string4.length();
            if (n > 0) {
                stringBuffer.append(string2 + string4 + string3);
                continue;
            }
            if (n6 >= n4 && string4.substring(0, n4).equals(string2)) {
                stringBuffer.append(string4.substring(n4) + string3);
                continue;
            }
            stringBuffer.append(string4 + string3);
        }
        return stringBuffer.toString();
    }

    public void scanToWordEnd(ArachDocument arachDocument, int n) {
        int n2 = arachDocument.textComp.getLength();
        boolean bl = false;
        for (int i = arachDocument.textComp.getCaretPosition(); i >= 0 && i < n2; i += n) {
            String string = arachDocument.textComp.getText(i, 1);
            if (string == null || string.length() <= 0) continue;
            char c = string.charAt(0);
            if (Character.isWhitespace(c)) {
                if (bl) {
                    arachDocument.textComp.setCaretPosition(i);
                    break;
                }
                bl = false;
                continue;
            }
            if (bl) continue;
            bl = true;
        }
    }

    public void jumpToLineEnd(ArachDocument arachDocument, int n) {
        try {
            int n2;
            int n3 = arachDocument.textComp.getCaretPosition();
            int n4 = arachDocument.textComp.getCaretLine();
            int n5 = arachDocument.textComp.getLineCount();
            if (n < 0) {
                n2 = arachDocument.textComp.getLineStartOffset(n4);
                if (n2 == n3 && n4 > 0) {
                    n2 = arachDocument.textComp.getLineStartOffset(n4 - 1);
                }
            } else {
                n2 = arachDocument.textComp.getLineEndOffset(n4) - 1;
                if (n2 == n3 && n4 < n5) {
                    n2 = arachDocument.textComp.getLineEndOffset(n4 + 1) - 1;
                }
            }
            if (n2 >= 0 && n2 < arachDocument.textComp.getLength() - 1) {
                arachDocument.textComp.setCaretPosition(n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void jumpToDocEnd(ArachDocument arachDocument, int n) {
        int n2 = n < 0 ? 0 : arachDocument.textComp.getLength() - 1;
        arachDocument.textComp.setCaretPosition(n2);
    }

    public void setFileType(String string) {
        if (this.main.currentSelectedDocument != null) {
            if (string.length() > 0) {
                int n = this.main.fileTypes.getFileTypeForName(string);
                this.main.currentSelectedDocument.changeFileType(n);
            } else {
                new SetFileTypeDialog(this.main, this.main.currentSelectedDocument);
            }
        }
    }

    public String makeOrderedList(String string) {
        return this.makeList("ol", string);
    }

    public String makeUnorderedList(String string) {
        return this.makeList("ul", string);
    }

    private String makeList(String string, String string2) {
        this.content = this.docHandler.getContent();
        if (this.content != null) {
            Vector vector = ArachComp.parseDelimLine(this.content, "\n");
            int n = vector.size();
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = ArachComp.getTabString();
            String string4 = "";
            String string5 = "";
            for (int i = 0; i < n; ++i) {
                int n2;
                String string6 = "";
                String string7 = (String)vector.get(i);
                for (n2 = 0; n2 < string7.length() && Character.isWhitespace(string7.charAt(n2)); ++n2) {
                }
                if (n2 > 0 && n2 < string7.length()) {
                    string6 = string7.substring(0, n2);
                    string7 = string7.substring(n2);
                    if (i == 0) {
                        string4 = string6;
                    } else if (i == n - 1) {
                        string5 = string6;
                    }
                }
                stringBuffer.append(string6 + string3);
                String string8 = string7.toLowerCase().trim();
                if (string7.length() > 0) {
                    if (string8.length() > 0 && string8.indexOf("<li") == -1 && string8.indexOf("<ul") == -1 && string8.indexOf("<ol") == -1 && string8.indexOf("</ul") == -1 && string8.indexOf("</ol") == -1) {
                        stringBuffer.append("<li>" + string7 + "</li>");
                    } else {
                        stringBuffer.append(string7);
                    }
                }
                if (i >= n - 1) continue;
                stringBuffer.append("\n");
            }
            this.content = string2.length() > 0 ? string4 + "<" + string + " type=\"" + string2 + "\">\n" + stringBuffer.toString() + "\n" + string5 + "</" + string + ">" : string4 + "<" + string + ">\n" + stringBuffer.toString() + "\n" + string5 + "</" + string + ">";
            this.docHandler.setContent(this.content);
        }
        return "";
    }

    public String RunCustomClassArg(String string) {
        String string2 = string;
        String string3 = "";
        int n = string.indexOf(",");
        if (n != -1) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        return new CustomClassHandler(this.main).processRequest(string2, string3);
    }

    public String RunCustomClassDoc(String string) {
        this.content = this.docHandler.getContent();
        if (this.content != null) {
            this.content = new CustomClassHandler(this.main).processRequest(string, this.content);
            this.docHandler.setContent(this.content);
        }
        return "";
    }

    public void jumpTo(int n, int n2) {
        if (this.main.currentSelectedDocument != null) {
            ArachDocument arachDocument = this.main.currentSelectedDocument;
            switch (n2) {
                case 0: {
                    this.scanToWordEnd(arachDocument, n);
                    break;
                }
                case 1: {
                    this.jumpToLineEnd(arachDocument, n);
                    break;
                }
                case 2: {
                    this.jumpToDocEnd(arachDocument, n);
                }
            }
            arachDocument.requestFocus();
        }
    }

    public void gotoLine(String string) {
        if (this.main.currentSelectedDocument != null) {
            ArachDocument arachDocument = this.main.currentSelectedDocument;
            if (string.length() > 0) {
                try {
                    int n = Integer.parseInt(string);
                    arachDocument.gotoLine(n - 1);
                }
                catch (Exception exception) {}
            } else {
                Goto goto_ = new Goto(this.main);
                int n = goto_.gotoLine;
                if (n != -1) {
                    arachDocument.gotoLine(n - 1);
                }
            }
            arachDocument.requestFocus();
        }
    }

    public void blockInOutDent(int n) {
        String string = this.docHandler.getContent();
        if (string != null) {
            string = this.blockInOutDent(string, n);
            this.docHandler.setContent(string);
        }
    }

    public void blockTab() {
        this.content = this.docHandler.getContent();
        if (this.content != null) {
            if (this.docHandler.textSelected()) {
                this.content = this.blockInOutDent(this.content, 11);
                this.docHandler.setContent(this.content);
            } else {
                this.doc.textComp.replaceSelection("\t");
            }
        }
    }

    public void blockReverseTab() {
        this.content = this.docHandler.getContent();
        if (this.content != null && this.docHandler.textSelected()) {
            this.content = this.blockInOutDent(this.content, 0);
            this.docHandler.setContent(this.content);
        }
    }

    public String createFileLink(String string) {
        String string2 = "";
        if (this.main.currentSelectedDocument != null) {
            ArachDocument arachDocument = this.main.currentSelectedDocument;
            string2 = this.main.rightClickProcessor.createFileLink(arachDocument, string);
        }
        return string2;
    }

    public void beautifyHTML() {
        String string = this.docHandler.getContent();
        if (string != null) {
            string = this.main.beautifyUtils.beautifyHTML(string);
            this.docHandler.setContent(string);
        }
    }

    public void validateHTML() {
        String string = this.docHandler.getContent();
        if (string != null) {
            this.main.htmlValidator.validateHTML(string);
        }
    }

    public void replaceLiTags() {
        String string = this.docHandler.getContent();
        if (string != null) {
            string = LiTagResolver.resolve(string);
            this.docHandler.setContent(string);
        }
    }

    public void jumpToOppositeTag() {
        String string = this.docHandler.getContent();
        if (string != null) {
            JumpToOppositeTag.jump(this.docHandler.getDoc());
        }
    }

    public String insertFullGraphicTag() {
        ArachDocument arachDocument;
        String string;
        String string2 = "";
        if (this.main.currentSelectedDocument != null && (string = this.main.rightClickProcessor.createGraphicLink(arachDocument = this.main.currentSelectedDocument)).length() > 0) {
            string2 = "<img src=\"" + string + "\" width=\"\" height=\"\" title=\"\" alt=\"|\"/>";
            string2 = this.main.rightClickProcessor.sizeAllGraphicTagsInString(arachDocument, string2);
        }
        return string2;
    }

    public String insertGraphicLink() {
        String string = "";
        if (this.main.currentSelectedDocument != null) {
            ArachDocument arachDocument = this.main.currentSelectedDocument;
            string = this.main.rightClickProcessor.createGraphicLink(arachDocument);
        }
        return string;
    }

    public void sizeGraphics() {
        String string = this.docHandler.getContent();
        if (string != null) {
            string = this.main.rightClickProcessor.sizeAllGraphicTagsInString(this.doc, string);
            this.docHandler.setContent(string);
        }
    }

    public void tabsToSpaces() {
        String string = this.docHandler.getContent();
        if (string != null) {
            String string2 = ArachComp.makeSpaceTab();
            string = this.searchReplace.srchRplc(string, "\t", string2);
            this.docHandler.setContent(string);
        }
    }

    public void spacesToTabs() {
        String string = this.docHandler.getContent();
        if (string != null) {
            String string2 = ArachComp.makeSpaceTab();
            string = this.searchReplace.srchRplc(string, string2, "\t");
            this.docHandler.setContent(string);
        }
    }

    public void convertDocToHTML() {
        if (this.main.currentSelectedDocument != null) {
            DocToHTMLConverter docToHTMLConverter = new DocToHTMLConverter(this.main);
            String string = docToHTMLConverter.convertDoc(this.main.currentSelectedDocument);
            if (string.length() > 0) {
                this.main.createHTMLDocFromString(string);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public void beautifyCode() {
        String string = this.docHandler.getContent();
        if (string != null) {
            string = new CodeBeautifier(this.main).beautifyCodeString(this.main.currentSelectedDocument, string, this.docHandler.getDoc().name);
            this.docHandler.setContent(string);
        }
    }

    public String getSelection() {
        String string = this.docHandler.getContent();
        if (string != null) {
            return string;
        }
        return "";
    }

    public String launchColorSelectorDialog(String string) {
        Color color;
        String string2 = "Choose a color";
        int n = 0;
        if (string.length() > 0) {
            try {
                n = Integer.parseInt(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = string;
            }
        }
        if ((color = JColorChooser.showDialog(this.main, string2, new Color(n))) == null) {
            color = new Color(n);
        }
        return ArachComp.colorIntToString(color.getRGB());
    }

    public void processMacrosInDocument() {
        String string = this.docHandler.getContent();
        if (string != null) {
            string = this.main.comSwitchboard.exec(string, 0);
            this.docHandler.setContent(string);
        }
    }

    public String processMacrosInString(String string) {
        return this.main.comSwitchboard.exec(string, 0);
    }

    public void wordCount() {
        String string = this.docHandler.getContent();
        if (string != null) {
            int n = 1;
            int n2 = 0;
            boolean bl = false;
            int n3 = string.length();
            for (int i = 0; i < n3; ++i) {
                boolean bl2;
                char c = string.charAt(i);
                if (c == '\n') {
                    ++n;
                }
                boolean bl3 = bl2 = Character.isLetterOrDigit(c) || c == '\'' || c == '-';
                if (bl) {
                    if (bl2) continue;
                    ++n2;
                    bl = false;
                    continue;
                }
                if (!bl2) continue;
                bl = true;
            }
            if (bl) {
                ++n2;
            }
            JOptionPane.showMessageDialog(this.main, n2 + " words," + n + " lines," + n3 + " characters.", "Word Count", 0);
        }
    }

    public void toLowerCase() {
        String string = this.docHandler.getContent();
        if (string != null) {
            string = string.toLowerCase();
            this.docHandler.setContent(string);
        }
    }

    public void toUpperCase() {
        String string = this.docHandler.getContent();
        if (string != null) {
            string = string.toUpperCase();
            this.docHandler.setContent(string);
        }
    }

    public void convertTextToHTML() {
        String string = this.docHandler.getContent();
        if (string != null) {
            string = this.main.entityProcessor.entityToString(string, true);
            string = this.searchReplace.srchRplc(string, "\n", "<br/>\n");
            string = "<html><head><title></title></head><body>\n" + string + "</body></html>\n";
            this.docHandler.setContent(string);
        }
    }

    public void convertHTMLToText() {
        String string = this.docHandler.getContent();
        if (string != null) {
            string = this.searchReplace.srchRplc(string, "\n", " ");
            string = this.searchReplace.srchRplc(string, "\t", "");
            string = this.searchReplace.srchRplc(string, "&nbsp;", " ");
            string = this.searchReplace.srchRplc(string, "</p>", "</p>\n\n", false);
            string = this.searchReplace.srchRplc(string, "<br/>", "<br/>\n", false);
            string = this.searchReplace.srchRplc(string, "</td>", "</td>\n", false);
            string = this.searchReplace.srchRplc(string, "</div>", "</div>\n", false);
            StringBuffer stringBuffer = new StringBuffer();
            int n = string.length();
            boolean bl = false;
            char c = 'x';
            for (int i = 0; i < n; ++i) {
                char c2 = string.charAt(i);
                if (c2 == '<') {
                    bl = true;
                }
                if (!bl) {
                    stringBuffer.append(c2);
                    c = c2;
                }
                if (c2 != '>') continue;
                bl = false;
                if (i >= n - 1 || Character.isWhitespace(string.charAt(i + 1)) || Character.isWhitespace(c)) continue;
                stringBuffer.append(' ');
            }
            string = this.main.entityProcessor.entityToChar(stringBuffer.toString(), true);
            Vector vector = ArachComp.parseDelimLine(string, "\n");
            n = vector.size();
            stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)vector.get(i);
                stringBuffer.append(string2.trim() + " \n");
            }
            this.docHandler.setContent(stringBuffer.toString());
        }
    }

    public void tagDelimsEscape() {
        String string = this.docHandler.getContent();
        if (string != null) {
            string = this.searchReplace.srchRplc(string, "<", "&lt;");
            string = this.searchReplace.srchRplc(string, ">", "&gt;");
            this.docHandler.setContent(string);
        }
    }

    public void tagDelimsUnescape() {
        String string = this.docHandler.getContent();
        if (string != null) {
            string = this.searchReplace.srchRplc(string, "&lt;", "<");
            string = this.searchReplace.srchRplc(string, "&gt;", ">");
            this.docHandler.setContent(string);
        }
    }

    public void leftFlushLines() {
        String string = this.docHandler.getContent();
        if (string != null) {
            Vector vector = ArachComp.parseDelimLine(string, "\n", false);
            StringBuffer stringBuffer = new StringBuffer();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                int n2;
                String string2 = (String)vector.get(i);
                for (n2 = 0; n2 < string2.length() && Character.isWhitespace(string2.charAt(n2)); ++n2) {
                }
                string2 = string2.substring(n2);
                stringBuffer.append(string2);
                if (i >= n - 1) continue;
                stringBuffer.append("\n");
            }
            this.docHandler.setContent(stringBuffer.toString());
        }
    }

    public void compressText() {
        String string = this.docHandler.getContent();
        if (string != null) {
            string = this.main.beautifyUtils.compressText(string);
            this.docHandler.setContent(string);
        }
    }

    public void changeTagCase(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.docHandler.getContent();
        if (string != null) {
            int n;
            int n2 = string.length();
            int n3 = 0;
            int n4 = 0;
            while ((n = string.indexOf("<", n3)) != -1) {
                n3 = n + 1;
                char c = string.charAt(n3);
                if (c != '!') {
                    if (c == '/' || c == '!') {
                        ++n3;
                    }
                    while (n3 < n2 && Character.isLetter(string.charAt(n3))) {
                        ++n3;
                    }
                    if (n3 >= n2) continue;
                    stringBuffer.append(string.substring(n4, n));
                    n4 = n;
                    String string2 = string.substring(n, n3);
                    if (bl) {
                        stringBuffer.append(string2.toUpperCase());
                    } else {
                        stringBuffer.append(string2.toLowerCase());
                    }
                    n4 = n3;
                    continue;
                }
                ++n3;
            }
            stringBuffer.append(string.substring(n4));
            this.docHandler.setContent(stringBuffer.toString());
        }
    }

    public void escapeText() {
        String string = this.docHandler.getContent();
        if (string != null) {
            string = EscapeUnescapeStringHandler.escapeString(string);
            this.docHandler.setContent(string);
        }
    }

    public void unescapeText() {
        String string = this.docHandler.getContent();
        if (string != null) {
            string = EscapeUnescapeStringHandler.unescapeString(string);
            this.docHandler.setContent(string);
        }
    }

    public void entityToChar() {
        String string = this.docHandler.getContent();
        if (string != null) {
            string = this.main.entityProcessor.entityToChar(string, this.docHandler.isHTML());
            this.docHandler.setContent(string);
        }
    }

    public void entityToString() {
        this.content = this.docHandler.getContent();
        if (this.content != null) {
            this.content = this.main.entityProcessor.entityToString(this.content, this.docHandler.isHTML());
            this.docHandler.setContent(this.content);
        }
    }
}

