/*
 * Decompiled with CFR 0.152.
 */
package TipOfTheDay;

import Arachnophilia.ArachComp;
import Arachnophilia.Arachnophilia;
import Arachnophilia.MyJButton;
import Arachnophilia.MyJLabel;
import Arachnophilia.MyJTextArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;

public class TipJFrame
extends JFrame {
    Arachnophilia main;
    String[] tips;
    int top;
    private JPanel bottomPanel;
    private JButton closeButton;
    private JButton iconButton;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JPanel middlePanel;
    private JButton nextButton;
    private JButton prevButton;
    private JCheckBox showTipCheckBox;
    private JTextArea tipTextArea;
    private JPanel topPanel;

    public TipJFrame(Arachnophilia arachnophilia) {
        this.main = arachnophilia;
        this.initComponents();
        this.tipTextArea.setBackground(Color.white);
        this.setIconImage(arachnophilia.getIconImage());
        this.setTitle("Arachnophilia 5.4");
        this.showTipCheckBox.setSelected(this.main.configValues.showTipOfTheDay);
        String string = this.main.basePath + "/ArachConf/TipsOfTheDay.txt";
        String string2 = ArachComp.readProgramFile(string, false);
        if (string2 != null) {
            string2 = this.main.comSwitchboard.exec(string2, 0);
            this.tips = ArachComp.parseDelimLine(string2, "*", true).toArray(new String[0]);
            this.top = this.tips.length;
            if (this.top > 0) {
                this.showTip(0);
                this.pack();
                this.setSize(500, 350);
                Rectangle rectangle = this.main.getBounds();
                int n = rectangle.width / 8;
                int n2 = rectangle.height / 8;
                this.setLocation(rectangle.x + n, rectangle.y + n2);
                this.setVisible(true);
            } else {
                this.quit();
            }
        }
    }

    private void showTip(int n) {
        this.main.configValues.currentTip += n;
        int n2 = this.main.configValues.currentTip;
        if (n2 < 0) {
            n2 += this.top * 1000;
        }
        String string = this.tips[n2 %= this.top];
        this.tipTextArea.setText(string);
        this.tipTextArea.setCaretPosition(0);
    }

    private void setShowTip() {
        this.main.configValues.showTipOfTheDay = this.showTipCheckBox.getSelectedObjects() != null;
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.iconButton = new JButton();
        this.jLabel1 = new MyJLabel(this.main);
        this.middlePanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tipTextArea = new MyJTextArea(this.main);
        this.bottomPanel = new JPanel();
        this.showTipCheckBox = new JCheckBox();
        this.prevButton = new MyJButton();
        this.nextButton = new MyJButton();
        this.closeButton = new MyJButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TipJFrame.this.exitForm(windowEvent);
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                TipJFrame.this.formWindowDeactivated(windowEvent);
            }
        });
        this.topPanel.setLayout(new FlowLayout(0));
        this.topPanel.setBackground(Color.white);
        this.iconButton.setBackground(Color.white);
        this.iconButton.setIcon(new ImageIcon(this.getClass().getResource("/Arachnophilia/arach.gif")));
        this.iconButton.setText(" ");
        this.iconButton.setToolTipText("Arachie says \"Hi\"");
        this.iconButton.setBorder(null);
        this.topPanel.add(this.iconButton);
        this.jLabel1.setFont(new Font("Dialog", 0, 18));
        this.jLabel1.setText("Arachnophilia Tip of the Day");
        this.topPanel.add(this.jLabel1);
        this.getContentPane().add((Component)this.topPanel, "North");
        this.middlePanel.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(new EtchedBorder());
        this.tipTextArea.setEditable(false);
        this.tipTextArea.setFont(new Font("Monospaced", 0, 12));
        this.tipTextArea.setLineWrap(true);
        this.tipTextArea.setWrapStyleWord(true);
        this.tipTextArea.setMargin(new Insets(4, 4, 4, 4));
        this.jScrollPane1.setViewportView(this.tipTextArea);
        this.middlePanel.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.middlePanel, "Center");
        this.showTipCheckBox.setText("Show tips at startup");
        this.showTipCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TipJFrame.this.showTipCheckBoxActionPerformed(actionEvent);
            }
        });
        this.bottomPanel.add(this.showTipCheckBox);
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/Icons/Left.gif")));
        this.prevButton.setToolTipText("Previous tip");
        this.prevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TipJFrame.this.prevButtonActionPerformed(actionEvent);
            }
        });
        this.bottomPanel.add(this.prevButton);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/Icons/Right.gif")));
        this.nextButton.setToolTipText("Next tip");
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TipJFrame.this.nextButtonActionPerformed(actionEvent);
            }
        });
        this.bottomPanel.add(this.nextButton);
        this.closeButton.setText("Close");
        this.closeButton.setToolTipText("Close this dialog");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TipJFrame.this.closeButtonActionPerformed(actionEvent);
            }
        });
        this.bottomPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.pack();
    }

    private void formWindowDeactivated(WindowEvent windowEvent) {
        this.quit();
    }

    private void showTipCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.setShowTip();
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.quit();
    }

    private void nextButtonActionPerformed(ActionEvent actionEvent) {
        this.showTip(1);
    }

    private void prevButtonActionPerformed(ActionEvent actionEvent) {
        this.showTip(-1);
    }

    private void exitForm(WindowEvent windowEvent) {
        this.quit();
    }

    private void quit() {
        ++this.main.configValues.currentTip;
        this.setVisible(false);
        this.dispose();
    }
}

