/*
 * Decompiled with CFR 0.152.
 */
package MacroManager;

import Arachnophilia.ArachComp;
import MacroManager.KeyDescription;
import javax.swing.ImageIcon;

public final class MacroTreeNodeData {
    public String name = "";
    public String title = "";
    public String toolTip = "";
    public KeyDescription keyboardHook = new KeyDescription();
    public String icon = "";
    public String content = "";
    public ImageIcon imageIcon = null;
    public boolean isToolBar = false;
    public boolean isMenu = false;
    public boolean isHidden = false;
    public boolean isSeparator = false;
    public boolean showTitleAndIcon = false;

    public MacroTreeNodeData() {
    }

    public MacroTreeNodeData(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.name = string;
        this.title = string2;
        this.toolTip = string3;
        this.keyboardHook = new KeyDescription(string4);
        this.content = string5;
        this.icon = string6;
        this.isToolBar = bl;
        this.isMenu = bl2;
        this.isHidden = bl3;
        this.isSeparator = bl4;
        this.showTitleAndIcon = bl5;
        this.init();
    }

    public MacroTreeNodeData(String string, String string2, String string3, KeyDescription keyDescription, String string4, String string5, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.name = string;
        this.title = string2;
        this.toolTip = string3;
        if (keyDescription != null) {
            this.keyboardHook = (KeyDescription)keyDescription.clone();
        }
        this.content = string4;
        this.icon = string5;
        this.isToolBar = bl;
        this.isMenu = bl2;
        this.isHidden = bl3;
        this.isSeparator = bl4;
        this.showTitleAndIcon = bl5;
        this.init();
    }

    private void init() {
        this.refreshIcon();
        if (this.keyboardHook == null) {
            this.keyboardHook = new KeyDescription();
        }
    }

    public void refreshIcon() {
        this.imageIcon = this.icon.length() > 0 ? ArachComp.loadIcon("/" + this.icon) : null;
    }

    public MacroTreeNodeData(String string, String string2, String string3) {
        this(string, string2, string3, "", "", "", false, false, false, false, false);
    }

    public MacroTreeNodeData(String string, String string2, String string3, String string4) {
        this(string, string2, string3, "", string4, "", false, false, false, false, false);
    }

    public Object clone() {
        return new MacroTreeNodeData(this.name, this.title, this.toolTip, this.keyboardHook, this.content, this.icon, this.isToolBar, this.isMenu, this.isHidden, this.isSeparator, this.showTitleAndIcon);
    }

    public String toString() {
        return this.title;
    }

    public String debugString() {
        return "{" + this.name + "," + this.title + "," + this.toolTip + "," + this.keyboardHook.getDescription() + "," + this.content + "," + this.icon + "}";
    }
}

