/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import Arachnophilia.ArachDocument;
import Arachnophilia.Arachnophilia;
import Arachnophilia.TextInterface;
import javax.swing.text.Caret;

public final class DocContentHandler {
    int selectionStart;
    int selectionEnd;
    int firstLine;
    int cp;
    int origLen;
    int finalLen;
    ArachDocument doc;
    TextInterface textComp;
    boolean selectionValid = false;
    boolean caretAtBeginning = false;
    Arachnophilia main;

    public DocContentHandler(Arachnophilia arachnophilia) {
        this.main = arachnophilia;
        this.doc = this.main.currentSelectedDocument;
    }

    public ArachDocument getDoc() {
        return this.doc;
    }

    public String getContent(ArachDocument arachDocument) {
        this.doc = arachDocument;
        return this.getContent2();
    }

    public boolean isHTML() {
        return this.doc.getFileType() == this.main.fileTypes.getFileTypeForName("HTML");
    }

    public String getContent() {
        this.doc = this.main.currentSelectedDocument;
        return this.getContent2();
    }

    private String getContent2() {
        String string = null;
        this.selectionValid = false;
        if (this.doc != null) {
            this.textComp = this.doc.textComp;
            if (this.textComp != null) {
                this.firstLine = this.textComp.getFirstLine();
                this.selectionStart = this.textComp.getSelectionStart();
                this.selectionEnd = this.textComp.getSelectionEnd();
                this.cp = this.textComp.getCaretPosition();
                boolean bl = this.caretAtBeginning = this.cp == this.selectionStart;
                if (this.selectionStart == this.selectionEnd) {
                    string = this.textComp.getText();
                    this.selectionValid = false;
                } else {
                    this.selectionValid = true;
                    string = this.textComp.getSelectedText();
                }
            }
            this.origLen = string.length();
        } else {
            this.textComp = null;
            this.doc = null;
        }
        return string;
    }

    public void setContent(String string) {
        this.setContent(string, false);
    }

    public void setContent(String string, boolean bl) {
        if (this.textComp != null) {
            this.finalLen = string.length();
            this.doc.undoPush();
            if (this.selectionValid || bl) {
                this.textComp.replaceSelection(string);
            } else {
                this.textComp.setText(string);
            }
            this.doc.docChanged = true;
            this.doc.updateTitle();
            this.cp = this.checkRange(this.cp, this.textComp);
            this.textComp.setCaretPosition(this.cp);
            if (this.selectionValid) {
                this.selectionStart = this.checkRange(this.selectionStart, this.textComp);
                this.selectionEnd = this.checkRange(this.selectionEnd + this.finalLen - this.origLen, this.textComp);
                if (this.caretAtBeginning) {
                    this.textComp.setCaretPosition(this.selectionEnd);
                    this.textComp.moveCaretPosition(this.selectionStart);
                } else {
                    this.textComp.setCaretPosition(this.selectionStart);
                    this.textComp.moveCaretPosition(this.selectionEnd);
                }
            }
            this.textComp.setFirstLine(this.firstLine);
            Caret caret = this.textComp.getCaret();
            if (caret != null) {
                caret.setSelectionVisible(true);
            }
        }
    }

    public boolean textSelected() {
        return this.selectionStart != this.selectionEnd;
    }

    public int checkRange(int n, TextInterface textInterface) {
        int n2 = textInterface.getLength();
        n = n < 0 ? 0 : n;
        n = n > n2 ? n2 : n;
        return n;
    }
}

