/*
 * Decompiled with CFR 0.152.
 */
package HTMLValidator;

import Arachnophilia.ArachComp;
import Arachnophilia.ArachDocument;
import Arachnophilia.Arachnophilia;
import HTMLValidator.HTMLValidatorDialog;
import HTMLValidator.TagData;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTMLValidator {
    Pattern[][] regex_suspend_resume = new Pattern[][]{{Pattern.compile("<script\\b"), Pattern.compile("</script>")}, {Pattern.compile("<\\?php"), Pattern.compile("\\?>")}, {Pattern.compile("<%"), Pattern.compile("%>")}, {Pattern.compile("<style\\b"), Pattern.compile("</style>")}};
    Pattern doctypePat = Pattern.compile("^(<!doctype|<\\?php\\b)");
    Pattern stripPat = Pattern.compile("^\\s*(.*?)\\s*$");
    Pattern tagPat = Pattern.compile("<.*?>");
    Pattern indentPat = Pattern.compile("(<[^/].*?[^/]>|<\\w+?>)");
    Pattern outdentPat = Pattern.compile("</.*?>");
    Pattern orphanPat = Pattern.compile("<.*?/>");
    Pattern delCommentPat = Pattern.compile("<!--.*?-->");
    Pattern delPhpXmlPat = Pattern.compile("<\\?(php|xml).*?\\?>");
    Pattern delAspPat = Pattern.compile("<%.*?%>");
    Pattern delScriptPat = Pattern.compile("<script.*?>.*?</script>");
    Pattern extractTagNamePat = Pattern.compile("</?(\\w+)\\b");
    HTMLValidatorDialog dialog = null;
    int docPosToggle = 0;
    Arachnophilia main;
    Pattern extractLineNumsPat = Pattern.compile(".*?line (\\d+)");

    public HTMLValidator(Arachnophilia arachnophilia) {
        this.main = arachnophilia;
    }

    public void validateHTML(String string) {
        String string2;
        String string3 = "----------------------------------------------------\n";
        String string4 = "Click error lines to navigate within document.\n";
        string4 = string4 + "Click again to jump to opposite tag.\n";
        string4 = string4 + string3;
        String[] stringArray = string.split("\n");
        Stack<TagData> stack = new Stack<TagData>();
        int n = stringArray.length;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n4;
            string2 = stringArray[i].toLowerCase();
            string2 = this.delPhpXmlPat.matcher(string2).replaceAll("");
            string2 = this.delAspPat.matcher(string2).replaceAll("");
            string2 = this.delScriptPat.matcher(string2).replaceAll("");
            Matcher matcher = this.stripPat.matcher(string2 = this.delCommentPat.matcher(string2).replaceAll(""));
            if (matcher.find()) {
                string2 = matcher.group(1);
            }
            if (string2.length() <= 0) continue;
            for (n4 = 0; n4 < this.regex_suspend_resume.length; ++n4) {
                if (!this.regex_suspend_resume[n4][1].matcher(string2).find() || this.regex_suspend_resume[n4][0].matcher(string2).find()) continue;
                --n2;
            }
            if (n2 <= 0) {
                for (String string5 : ArachComp.extractAllRegexMatches(string2, this.tagPat)) {
                    Object object;
                    String string6;
                    if (this.doctypePat.matcher(string5).find() || this.orphanPat.matcher(string5).find()) continue;
                    matcher = this.extractTagNamePat.matcher(string5);
                    if (!matcher.find()) {
                        string6 = "Malformed/unidentified tag: " + string5 + ", line " + (i + 1) + ".";
                        string4 = string4 + string6 + "\n";
                        bl = true;
                        continue;
                    }
                    string6 = matcher.group(1);
                    TagData tagData = new TagData(string6, i);
                    if (this.indentPat.matcher(string5).find()) {
                        stack.push(tagData);
                        ++n3;
                        continue;
                    }
                    if (this.outdentPat.matcher(string5).find()) {
                        --n3;
                        if (stack.size() <= 0) {
                            object = "  Orphan: " + tagData + " no corresponding tag.";
                            string4 = string4 + (String)object + "\n";
                            bl = true;
                            continue;
                        }
                        object = (TagData)stack.pop();
                        if (((TagData)object).name.equals(string6)) continue;
                        String string7 = "Mismatch: " + tagData + " doesn't match " + object + ".";
                        string4 = string4 + string7 + "\n";
                        bl = true;
                        continue;
                    }
                    object = "Unidentified tag type: " + string5 + ", line " + (i + 1) + ".";
                    string4 = string4 + (String)object + "\n";
                    bl = true;
                }
            }
            for (n4 = 0; n4 < this.regex_suspend_resume.length; ++n4) {
                if (!this.regex_suspend_resume[n4][0].matcher(string2).find() || this.regex_suspend_resume[n4][1].matcher(string2).find()) continue;
                ++n2;
            }
        }
        while (stack.size() > 0) {
            TagData tagData = (TagData)stack.pop();
            string2 = "  Orphan: " + tagData + " no corresponding tag.";
            string4 = string4 + string2 + "\n";
            bl = true;
        }
        string4 = string4 + string3;
        if (n3 != 0) {
            String string8 = "Error: start/end tag mismatch: n = " + n3 + "\n";
            string8 = string8 + "n > 0 means more <starting> tags than </ending> tags.\n";
            string8 = string8 + "n < 0 means more </ending> tags than <starting> tags.\n\n";
            string8 = string8 + "This error can be caused by validating a selection\nrather than the entire document.";
            string4 = string4 + string8 + "\n";
        } else if (!bl) {
            string4 = "No errors.";
        }
        if (this.dialog != null) {
            this.dialog.quit();
        }
        this.dialog = new HTMLValidatorDialog(this.main, this);
        this.dialog.setText(string4);
    }

    public boolean isValidLine(String string) {
        return this.extractLineNumsPat.matcher(string).find();
    }

    public void gotoLine(String string) {
        Matcher matcher = this.extractLineNumsPat.matcher(string);
        Vector<String> vector = new Vector<String>();
        while (matcher.find()) {
            vector.add(matcher.group(1));
        }
        int n = vector.size();
        if (n > 0) {
            int n2 = this.docPosToggle++ % n;
            String string2 = (String)vector.elementAt(n2);
            int n3 = Integer.parseInt(string2);
            ArachDocument arachDocument = this.main.currentSelectedDocument;
            arachDocument.changeDisplayModes(true);
            arachDocument.gotoLine(n3 - 1);
        }
    }
}

