/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import Arachnophilia.ArachDocument;
import Arachnophilia.Arachnophilia;
import Arachnophilia.DocContentHandler;
import Arachnophilia.TextInterface;
import java.awt.Toolkit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.text.Caret;

public final class RegExpWrapperClass {
    Arachnophilia main;
    ArachDocument doc;
    DocContentHandler docHandler;
    Pattern pattern;
    int pos = -1;
    int findPos = -1;
    int selStart;
    int selEnd;
    int findCount;
    int fileCount;
    boolean found = false;
    boolean lockAccess = false;
    public boolean cancelCurrentOperation = false;

    public RegExpWrapperClass(Arachnophilia arachnophilia) {
        this.main = arachnophilia;
        this.docHandler = new DocContentHandler(this.main);
    }

    private String smartModifier(int n) {
        return n == 1 ? "" : "s";
    }

    public void countOccurrences(ArachDocument arachDocument, String string, int n, JLabel jLabel) {
        Matcher matcher = null;
        Pattern pattern = null;
        String string2 = arachDocument.textComp.getText();
        if (string2 != null) {
            try {
                pattern = Pattern.compile(string, n);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                pattern = null;
                this.pos = 0;
            }
        }
        if (pattern != null) {
            int n2 = 0;
            matcher = pattern.matcher(string2);
            while (matcher.find()) {
                ++n2;
            }
            if (jLabel != null) {
                jLabel.setText("Found " + n2 + " case" + this.smartModifier(n2) + ".");
            }
        }
    }

    public void replaceAllThread(final ArachDocument arachDocument, final String string, final String string2, final int n, final JLabel jLabel) {
        if (!this.lockAccess) {
            this.lockAccess = true;
            Thread thread = new Thread(){

                public void run() {
                    RegExpWrapperClass.this.replaceAll(arachDocument, string, string2, n, jLabel);
                }
            };
            thread.start();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void replaceAll(ArachDocument arachDocument, String string, String string2, int n, JLabel jLabel) {
        this.replaceAll2(arachDocument, string, string2, n);
        this.lockAccess = false;
        if (jLabel != null) {
            jLabel.setText("Replaced all cases.");
        }
    }

    private void replaceAll2(ArachDocument arachDocument, String string, String string2, int n) {
        if (arachDocument != null) {
            String string3;
            int n2;
            boolean bl;
            Matcher matcher = null;
            Pattern pattern = null;
            int n3 = 0;
            int n4 = 0;
            int n5 = arachDocument.textComp.getCaretPosition();
            int n6 = arachDocument.textComp.getSelectionStart();
            boolean bl2 = bl = n6 != (n2 = arachDocument.textComp.getSelectionEnd());
            if (bl) {
                string3 = arachDocument.textComp.getSelectedText();
                n3 = string3.length();
            } else {
                string3 = arachDocument.textComp.getText();
            }
            if (string3 != null) {
                try {
                    pattern = Pattern.compile(string, n);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    this.pos = 0;
                    pattern = null;
                }
            }
            if (pattern != null) {
                arachDocument.undoPush();
                matcher = pattern.matcher(string3);
                string3 = matcher.replaceAll(string2);
                if (bl) {
                    arachDocument.textComp.replaceSelection(string3);
                    n4 = string3.length();
                    arachDocument.textComp.setSelectionStart(n6);
                    arachDocument.textComp.setSelectionEnd(n2 + n4 - n3);
                } else {
                    arachDocument.textComp.setText(string3);
                    if (n5 < arachDocument.textComp.getDocument().getLength()) {
                        arachDocument.textComp.setCaretPosition(n5);
                    }
                }
                Caret caret = arachDocument.textComp.getCaret();
                if (caret != null) {
                    caret.setSelectionVisible(true);
                }
            }
        }
    }

    public void replaceGlobalThread(String string, final String string2, String string3, final String string4, final int n, final JLabel jLabel) {
        if (!this.lockAccess) {
            int n2 = JOptionPane.showConfirmDialog(this.main, "This operation will replace ALL cases of \n\"" + string + "\" with\n" + "\"" + string3 + "\"\n" + "in ALL open documents.\n" + "Okay to proceed?", "Global RegExp Replace All", 0);
            if (n2 == 0) {
                this.lockAccess = true;
                Thread thread = new Thread(){

                    public void run() {
                        RegExpWrapperClass.this.replaceGlobal(string2, string4, n, jLabel);
                    }
                };
                thread.start();
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void replaceGlobal(String string, String string2, int n, JLabel jLabel) {
        this.cancelCurrentOperation = false;
        this.fileCount = 0;
        this.findCount = 0;
        ArachDocument[] arachDocumentArray = this.main.fileHandler.docArray();
        for (int i = 0; i < arachDocumentArray.length && !this.cancelCurrentOperation; ++i) {
            ArachDocument arachDocument = arachDocumentArray[i];
            arachDocument.textComp.setSelectionEnd(arachDocument.textComp.getSelectionStart());
            this.replaceAll2(arachDocument, string, string2, n);
            ++this.fileCount;
        }
        if (jLabel != null) {
            jLabel.setText("Replaced all cases in " + this.fileCount + " file" + this.smartModifier(this.fileCount) + ".");
        }
        this.cancelCurrentOperation = false;
        this.lockAccess = false;
    }

    public void findFirst(ArachDocument arachDocument, String string, int n, JLabel jLabel) {
        if (arachDocument != null) {
            arachDocument.textComp.setCaretPosition(0);
            this.findNext(arachDocument, string, n, jLabel);
        }
    }

    public void findNext(ArachDocument arachDocument, String string, int n, JLabel jLabel) {
        if (arachDocument != null) {
            if (string.length() > 0) {
                this.doc = arachDocument;
                this.pos = arachDocument.textComp.getCaretPosition();
                this.findText2(string, n, jLabel);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void findText2(String string, int n, JLabel jLabel) {
        this.found = false;
        if (this.main.currentSelectedDocument == this.doc && this.doc != null) {
            Matcher matcher = this.searchText(string, this.pos, n, this.doc.textComp);
            if (matcher != null) {
                this.found = true;
                this.selStart = this.findPos = matcher.start();
                this.selEnd = matcher.end();
                this.doc.centerCaret = true;
                this.doc.textComp.select(this.selStart, this.selEnd);
                Caret caret = this.doc.textComp.getCaret();
                if (caret != null) {
                    caret.setSelectionVisible(true);
                }
                this.pos = this.selEnd;
                if (jLabel != null) {
                    jLabel.setText("Found 1 case.");
                }
            } else {
                this.pos = 0;
                this.doc.textComp.setCaretPosition(0);
                Toolkit.getDefaultToolkit().beep();
                if (jLabel != null) {
                    jLabel.setText("Not found.");
                }
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private Matcher searchText(String string, int n, int n2, TextInterface textInterface) {
        Matcher matcher = null;
        this.pattern = null;
        String string2 = textInterface.getText();
        if (string2 != null) {
            try {
                this.pattern = Pattern.compile(string, n2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                n = 0;
                this.pattern = null;
            }
        }
        if (this.pattern != null) {
            matcher = this.pattern.matcher(string2);
            if (!matcher.find(n)) {
                matcher = null;
            }
            return matcher;
        }
        return null;
    }

    public void replaceText(String string, String string2, int n, JLabel jLabel) {
        if (!this.found || this.main.currentSelectedDocument != this.doc || this.doc == null) {
            if (jLabel != null) {
                jLabel.setText("Searching.");
            }
            this.findNext(this.main.currentSelectedDocument, string, n, jLabel);
        } else {
            String string3 = this.docHandler.getContent();
            int n2 = string3.length();
            try {
                this.pattern = Pattern.compile(string, n);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.pattern = null;
            }
            if (this.pattern != null) {
                Matcher matcher = this.pattern.matcher(string3);
                string3 = matcher.replaceFirst(string2);
            }
            int n3 = string3.length();
            this.docHandler.setContent(string3);
            int n4 = n3 - n2;
            this.pos += n4;
            this.doc.textComp.setCaretPosition(this.selStart);
            this.doc.textComp.moveCaretPosition(this.pos);
            this.found = false;
            if (jLabel != null) {
                jLabel.setText("Replaced 1 case.");
            }
        }
    }
}

