/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class FileChangedDialog
extends JDialog {
    public int state = -1;
    private JButton cancelButton;
    private JButton ignoreButton;
    private JPanel jPanel1;
    private JTextArea messageTextArea;
    private JButton overwriteButton;
    private JButton reloadButton;

    public FileChangedDialog(Frame frame, String string, boolean bl, boolean bl2) {
        super(frame, bl2);
        this.initComponents();
        this.setTitle("File Changed on disk");
        String string2 = "The file \"" + string + "\" has been changed by another program.\n";
        if (bl) {
            string2 = string2 + "Also, changes have been made to the document, and the \"Reload File\" choice will lose all changes.\n";
        }
        string2 = string2 + "What do you want to do?";
        this.messageTextArea.setText(string2);
        this.messageTextArea.setBackground(this.getContentPane().getBackground());
        this.pack();
        Rectangle rectangle = frame.getBounds();
        int n = rectangle.width / 4;
        int n2 = rectangle.height / 4;
        this.setLocation(rectangle.x + n, rectangle.y + n2);
        this.setVisible(true);
    }

    public void closeDialog(int n) {
        this.state = n;
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() {
        this.messageTextArea = new JTextArea();
        this.jPanel1 = new JPanel();
        this.overwriteButton = new JButton();
        this.reloadButton = new JButton();
        this.ignoreButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setFont(new Font("Monospaced", 0, 14));
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setWrapStyleWord(true);
        this.messageTextArea.setMargin(new Insets(8, 8, 8, 8));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.messageTextArea, gridBagConstraints);
        this.overwriteButton.setText("Overwrite");
        this.overwriteButton.setToolTipText("Replace disk file contents with memory contents");
        this.overwriteButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                FileChangedDialog.this.overwriteButtonClicked(mouseEvent);
            }
        });
        this.jPanel1.add(this.overwriteButton);
        this.reloadButton.setText("Reload File");
        this.reloadButton.setToolTipText("Reload disk file, erase memory contents");
        this.reloadButton.setSelected(true);
        this.reloadButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                FileChangedDialog.this.reloadButtonClicked(mouseEvent);
            }
        });
        this.jPanel1.add(this.reloadButton);
        this.ignoreButton.setText("Ignore");
        this.ignoreButton.setToolTipText("Take no action");
        this.ignoreButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                FileChangedDialog.this.ignoreButtonClicked(mouseEvent);
            }
        });
        this.jPanel1.add(this.ignoreButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Take no action");
        this.cancelButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                FileChangedDialog.this.cancelButtonClicked(mouseEvent);
            }
        });
        this.jPanel1.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void cancelButtonClicked(MouseEvent mouseEvent) {
        this.closeDialog(0);
    }

    private void ignoreButtonClicked(MouseEvent mouseEvent) {
        this.closeDialog(1);
    }

    private void reloadButtonClicked(MouseEvent mouseEvent) {
        this.closeDialog(2);
    }

    private void overwriteButtonClicked(MouseEvent mouseEvent) {
        this.closeDialog(3);
    }
}

