/*
 * Decompiled with CFR 0.152.
 */
package MacroManager;

import Arachnophilia.Arachnophilia;
import Arachnophilia.MyJButton;
import MacroManager.MacroTreeNodeData;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.tree.DefaultMutableTreeNode;

public final class ToolBarManager {
    Arachnophilia main;
    Vector comList;
    int comIndex;

    public ToolBarManager(Arachnophilia arachnophilia) {
        this.main = arachnophilia;
    }

    public void buildToolBars(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.main.getToolBarPanel().removeAll();
        this.main.getToolBar().removeAll();
        this.comList = new Vector();
        this.comIndex = 0;
        this.buildToolBarsRecursive(defaultMutableTreeNode, 0);
        this.main.getToolBar().updateUI();
        this.main.getToolBarPanel().updateUI();
    }

    public int buildToolBarsRecursive(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        int n2 = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n2; ++i) {
            boolean bl;
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            MacroTreeNodeData macroTreeNodeData = (MacroTreeNodeData)defaultMutableTreeNode2.getUserObject();
            if (macroTreeNodeData.isHidden) continue;
            boolean bl2 = bl = defaultMutableTreeNode2.getChildCount() > 0;
            if (macroTreeNodeData.isToolBar && bl) {
                JToolBar jToolBar = null;
                jToolBar = n == 0 ? this.addToolBar(this.main.getToolBar(), n) : this.addToolBar(new JToolBar(), n);
                this.buildToolBarFromNode(jToolBar, defaultMutableTreeNode2, macroTreeNodeData.toolTip, n++);
            }
            n = this.buildToolBarsRecursive(defaultMutableTreeNode2, n);
        }
        return n;
    }

    private void buildToolBarFromNode(JToolBar jToolBar, DefaultMutableTreeNode defaultMutableTreeNode, String string, int n) {
        if (defaultMutableTreeNode != null) {
            jToolBar.setToolTipText(string);
            int n2 = defaultMutableTreeNode.getChildCount();
            jToolBar.removeAll();
            for (int i = 0; i < n2; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                MacroTreeNodeData macroTreeNodeData = (MacroTreeNodeData)defaultMutableTreeNode2.getUserObject();
                if (macroTreeNodeData.isHidden) continue;
                this.comList.add(macroTreeNodeData.content);
                this.createToolBarButton(jToolBar, defaultMutableTreeNode2, this.comIndex);
                ++this.comIndex;
            }
            jToolBar.invalidate();
        }
    }

    private JToolBar addToolBar(JToolBar jToolBar, int n) {
        this.main.getToolBarPanel().setLayout(new GridLayout(n, 1));
        if (n > 0) {
            this.main.getToolBarPanel().add(jToolBar);
        }
        jToolBar.setVisible(true);
        return jToolBar;
    }

    private void createToolBarButton(JToolBar jToolBar, DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        MacroTreeNodeData macroTreeNodeData = (MacroTreeNodeData)defaultMutableTreeNode.getUserObject();
        if (macroTreeNodeData.isSeparator) {
            JSeparator jSeparator = new JSeparator(1);
            jToolBar.add(jSeparator);
        } else {
            MyJButton myJButton = new MyJButton(this.main, defaultMutableTreeNode);
            if (macroTreeNodeData.icon.length() > 0) {
                URL uRL = this.getClass().getResource("/" + macroTreeNodeData.icon);
                if (uRL != null) {
                    myJButton.setIcon(new ImageIcon(uRL));
                }
                if (macroTreeNodeData.showTitleAndIcon) {
                    myJButton.setText(macroTreeNodeData.title);
                }
            } else {
                myJButton.setText(macroTreeNodeData.title);
            }
            if (macroTreeNodeData.toolTip.length() > 0) {
                myJButton.setToolTipText(macroTreeNodeData.toolTip);
            }
            final int n2 = n;
            myJButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ToolBarManager.this.execCom(n2);
                }
            });
            jToolBar.add(myJButton);
        }
    }

    private void execCom(int n) {
        if (n >= 0 && n < this.comList.size()) {
            this.main.macroHandler.executeCommand((String)this.comList.get(n));
        }
    }
}

