/*
 * Decompiled with CFR 0.152.
 */
package MacroManager;

import Arachnophilia.ArachComp;
import Arachnophilia.Arachnophilia;
import FilePicker.PickerDialog;
import FileTypes.FileTypes;
import MacroManager.MacroFileReadWrite;
import MacroManager.MacroTreeNodeData;
import MacroManager.MenuManager;
import MacroManager.ToolBarManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class MyJTree
extends JTree
implements DropTargetListener {
    Arachnophilia main = null;
    Frame frame = null;
    MacroFileReadWrite macro_file_read_write;
    ToolBarManager toolBarManager;
    MenuManager menuManager;
    public TreeMap macroMap;
    MyRenderer renderer;
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel treeModel;
    TreePath copyCutSelection = null;
    TreePath currentSelection = null;
    boolean isCut = false;
    public boolean isChanged = false;
    public boolean editMode = false;
    int tabSize;

    public MyJTree(Arachnophilia arachnophilia, int n) {
        this.main = arachnophilia;
        this.init(arachnophilia, n);
    }

    private void init(Frame frame, int n) {
        this.frame = frame;
        this.tabSize = n;
        this.setBorder(null);
        this.getSelectionModel().setSelectionMode(1);
        this.setToolTipText("");
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                MyJTree.this.handleKeys(keyEvent);
            }

            public void keyPressed(KeyEvent keyEvent) {
                MyJTree.this.handleKeys(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                MyJTree.this.handleKeys(keyEvent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MyJTree.this.handleMouse(mouseEvent);
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                MyJTree.this.handleTreeValueChanged(treeSelectionEvent);
            }
        });
        new DropTarget(this, 3, this);
        this.macro_file_read_write = new MacroFileReadWrite(this.main);
        this.renderer = new MyRenderer();
        this.setupIcons(this.renderer);
        this.setCellRenderer(this.renderer);
        this.isChanged |= this.readRootMacroFile(this.main.macroPath);
        this.treeModel = (DefaultTreeModel)this.getModel();
        this.rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
        this.toolBarManager = new ToolBarManager(this.main);
        this.menuManager = new MenuManager(this.main);
        this.updateAfterChange(this.rootNode, false, false);
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.addRenderingHints(this.main.renderHints);
        super.paint(graphics2D);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            try {
                dropTargetDropEvent.acceptDrop(1);
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                Iterator iterator = list.iterator();
                Vector<File> vector = new Vector<File>();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    vector.add(file);
                }
                dropTargetDropEvent.dropComplete(true);
                this.openFileArray(vector.toArray(new File[0]));
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
        }
    }

    public Vector getMacroList() {
        return new Vector(this.macroMap.keySet());
    }

    private void openFileArray(File[] fileArray) {
        MacroTreeNodeData macroTreeNodeData = new MacroTreeNodeData("", "New Macro Folder", "Macro file(s) dropped onto Macro Window");
        macroTreeNodeData.isHidden = true;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(macroTreeNodeData);
        macroTreeNodeData.name = ArachComp.getStringForNode(defaultMutableTreeNode);
        this.rootNode.add(defaultMutableTreeNode);
        for (int i = 0; i < fileArray.length; ++i) {
            this.readMacroFile(fileArray[i].getPath(), defaultMutableTreeNode, false);
        }
        this.updateAfterChange(this.rootNode, true, true);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private void updateAfterChange(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl, boolean bl2) {
        this.updateAfterChange(defaultMutableTreeNode, defaultMutableTreeNode, bl, bl2);
    }

    private void updateAfterChange(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, boolean bl, boolean bl2) {
        this.main.macroKeyHandler.readKeymacrosFromTree(this.rootNode);
        this.toolBarManager.buildToolBars(this.rootNode);
        this.macroMap = this.menuManager.buildMenus(this.rootNode);
        this.treeModel.nodeStructureChanged(defaultMutableTreeNode);
        if (bl && defaultMutableTreeNode2 != null) {
            this.refocusNode(defaultMutableTreeNode2);
            if (bl2) {
                this.editNode(this.frame, this.tabSize);
            }
        }
    }

    private void testSaveChanges() {
        if (this.main.macroEditor != null) {
            this.main.macroEditor.testSaveChanges();
        }
    }

    public void setEditMode(boolean bl, boolean bl2) {
        this.editMode = bl;
        if (bl) {
            if (this.main.macroEditor != null) {
                this.main.macroEditor.changed = false;
            }
            this.editNode(this.frame, this.tabSize);
        } else {
            this.testSaveChanges();
        }
        this.main.showMacroEditPanel(bl, bl2);
    }

    private void handleTreeValueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.editMode) {
            this.editNode(this.frame, this.tabSize);
        }
    }

    public void saveOnExit() {
        if (this.isChanged) {
            this.writeMacroFile(this.main.macroPath);
        }
    }

    private void handleMouse(MouseEvent mouseEvent) {
        TreePath treePath;
        if ((!mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() == 2 || this.main != null && this.main.configValues.oneClickMacroMode) && (treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
            this.setSelectionPath(treePath);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (this.main != null && defaultMutableTreeNode.getChildCount() == 0) {
                String string = ((MacroTreeNodeData)defaultMutableTreeNode.getUserObject()).content;
                this.main.macroHandler.executeCommand(string);
            }
        }
    }

    private void handleKeys(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            int n = keyEvent.getKeyCode();
            char c = keyEvent.getKeyChar();
            if (c == '+' || c == '=') {
                this.moveDown();
                keyEvent.consume();
            } else if (c == '-' || c == '_') {
                this.moveUp();
                keyEvent.consume();
            } else if (c == 'x' || c == 'X') {
                this.showHide();
                keyEvent.consume();
            } else if (n == 88) {
                this.cutNode();
                keyEvent.consume();
            } else if (n == 67) {
                this.copyNode();
                keyEvent.consume();
            } else if (n == 86) {
                this.pasteNode();
                keyEvent.consume();
            } else if (n == 127) {
                this.deleteNode();
                keyEvent.consume();
            } else {
                this.main.macroKeyHandler.execute(keyEvent);
            }
        }
    }

    private void setupIcons(MyRenderer myRenderer) {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/Icons/Folder.gif"));
        myRenderer.setClosedIcon(imageIcon);
        ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("/Icons/Open.gif"));
        myRenderer.setOpenIcon(imageIcon2);
        ImageIcon imageIcon3 = new ImageIcon(this.getClass().getResource("/Icons/Document.gif"));
        myRenderer.setLeafIcon(imageIcon3);
        this.setRowHeight(imageIcon.getIconHeight());
    }

    public boolean readRootMacroFile(String string) {
        boolean bl = false;
        String string2 = "Located on this system at " + this.main.macroPath;
        MacroTreeNodeData macroTreeNodeData = new MacroTreeNodeData("", "Macros", string2);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(macroTreeNodeData);
        macroTreeNodeData.name = ArachComp.getStringForNode(defaultMutableTreeNode);
        bl = this.macro_file_read_write.readMacroFile(string, defaultMutableTreeNode);
        this.setModel(new DefaultTreeModel(defaultMutableTreeNode));
        return bl;
    }

    public void promptReadMacroFile(Arachnophilia arachnophilia, boolean bl) {
        if (this.getCurrentSelection()) {
            File[] fileArray;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.currentSelection.getLastPathComponent();
            FileTypes fileTypes = new FileTypes(arachnophilia.fileTypePath);
            fileTypes.setFileType(bl ? "Text" : "XML");
            int n = fileTypes.getFileType();
            String string = arachnophilia.configValues.fileTypePaths[n];
            PickerDialog pickerDialog = new PickerDialog(arachnophilia, new File(string), fileTypes, 0);
            pickerDialog.setDialogTitle("Read " + fileTypes.fileTypeNames[n] + " macro file");
            int n2 = pickerDialog.showOpenDialog();
            if (n2 == 1 && (fileArray = pickerDialog.getSelectedFiles()) != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (this.readMacroFile(fileArray[i].getPath(), defaultMutableTreeNode, bl)) {
                        this.isChanged = true;
                    }
                    arachnophilia.configValues.fileTypePaths[n] = ArachComp.pathFromFullPath(fileArray[i].getPath());
                }
            }
        }
    }

    public void promptWriteMacroFile(Arachnophilia arachnophilia) {
        if (this.getCurrentSelection()) {
            File[] fileArray;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.currentSelection.getLastPathComponent();
            boolean bl = this.canBeSource(defaultMutableTreeNode, false);
            FileTypes fileTypes = new FileTypes(arachnophilia.fileTypePath);
            fileTypes.setFileType("XML");
            int n = fileTypes.getFileType();
            String string = arachnophilia.configValues.fileTypePaths[n];
            PickerDialog pickerDialog = new PickerDialog(arachnophilia, new File(string), fileTypes, 0);
            pickerDialog.setDialogTitle("Write " + fileTypes.fileTypeNames[n] + " macro file");
            int n2 = pickerDialog.showSaveDialog();
            if (n2 == 1 && (fileArray = pickerDialog.getSelectedFiles()) != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    int n3 = 0;
                    if (fileArray[i].exists()) {
                        n3 = JOptionPane.showConfirmDialog(arachnophilia, "The file \n\"" + fileArray[i].getPath() + "\"\n exists.\nOkay to overwrite?", "File Exists", 0);
                    }
                    if (n3 != 0) continue;
                    if (bl) {
                        this.writeRootMacroFile(fileArray[i].getPath(), defaultMutableTreeNode);
                    } else {
                        this.writeMacroFile(fileArray[i].getPath(), defaultMutableTreeNode);
                    }
                    arachnophilia.configValues.fileTypePaths[n] = ArachComp.pathFromFullPath(fileArray[i].getPath());
                }
            }
        }
    }

    public boolean readMacroFile(String string, DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        boolean bl2 = false;
        bl2 = bl ? this.macro_file_read_write.readLegacyMacroFile(string, defaultMutableTreeNode) : this.macro_file_read_write.readMacroFile(string, defaultMutableTreeNode);
        this.treeModel.nodeStructureChanged(defaultMutableTreeNode);
        this.refocusNode(defaultMutableTreeNode);
        return bl2;
    }

    public void readRescueMacroString(String string, String string2) {
        MacroTreeNodeData macroTreeNodeData = new MacroTreeNodeData("Rescue Macros", "A set of recovery macros", "This set of macros can be used to repair a macro set that has been scrambled beyond repair.\n\nYou may replace your entire macro tree with this one, or you may choose to replace individual items or subtrees.");
        macroTreeNodeData.isHidden = true;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.rootNode.add(defaultMutableTreeNode);
        this.macro_file_read_write.readMacroString(string, string2, defaultMutableTreeNode);
        defaultMutableTreeNode.setUserObject(macroTreeNodeData);
        this.isChanged = true;
        this.updateAfterChange(this.rootNode, true, true);
    }

    public void writeMacroFile(String string) {
        this.writeMacroFile(string, (DefaultMutableTreeNode)this.treeModel.getRoot());
    }

    public void writeMacroFile(String string, DefaultMutableTreeNode defaultMutableTreeNode) {
        this.macro_file_read_write.writeMacroFile(string, defaultMutableTreeNode);
    }

    public void writeRootMacroFile(String string, DefaultMutableTreeNode defaultMutableTreeNode) {
        this.macro_file_read_write.writeRootMacroFile(string, defaultMutableTreeNode);
    }

    public void selectOnRightClick(MouseEvent mouseEvent) {
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            this.setSelectionPath(treePath);
        }
    }

    public void refocusNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode != null) {
            Object[] objectArray = defaultMutableTreeNode.getPath();
            TreePath treePath = new TreePath(objectArray);
            this.setSelectionPath(treePath);
        }
    }

    private boolean getCurrentSelection() {
        return this.getCurrentSelection(true);
    }

    private boolean canBeSource(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = defaultMutableTreeNode != null && defaultMutableTreeNode.getParent() != null;
        if (!bl2 && bl) {
            Toolkit.getDefaultToolkit().beep();
        }
        return bl2;
    }

    private boolean getCurrentSelection(boolean bl) {
        this.currentSelection = this.getSelectionPath();
        if (this.currentSelection == null && bl) {
            Toolkit.getDefaultToolkit().beep();
        }
        return this.currentSelection != null;
    }

    public void cutNode() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (this.getCurrentSelection() && this.canBeSource(defaultMutableTreeNode = (DefaultMutableTreeNode)this.currentSelection.getLastPathComponent(), true)) {
            this.copyCutSelection = this.currentSelection;
            this.isCut = true;
        }
    }

    public void copyNode() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (this.getCurrentSelection() && this.canBeSource(defaultMutableTreeNode = (DefaultMutableTreeNode)this.currentSelection.getLastPathComponent(), true)) {
            this.copyCutSelection = this.currentSelection;
            this.isCut = false;
        }
    }

    public void pasteNode() {
        if (this.getCurrentSelection()) {
            if (this.copyCutSelection != null) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.copyCutSelection.getLastPathComponent();
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)this.currentSelection.getLastPathComponent();
                if (defaultMutableTreeNode2 != null && defaultMutableTreeNode3 != null && (defaultMutableTreeNode = this.cloneNode(defaultMutableTreeNode2)) != null) {
                    defaultMutableTreeNode3.add(defaultMutableTreeNode);
                    if (this.isCut) {
                        this.removeFromParent(defaultMutableTreeNode2);
                    }
                    this.isChanged = true;
                    this.treeModel.nodeStructureChanged(defaultMutableTreeNode2);
                    this.updateAfterChange(defaultMutableTreeNode3, true, true);
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        this.copyCutSelection = null;
    }

    private DefaultMutableTreeNode cloneNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        MacroTreeNodeData macroTreeNodeData = (MacroTreeNodeData)defaultMutableTreeNode.getUserObject();
        if (macroTreeNodeData != null) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(macroTreeNodeData.clone());
            int n = defaultMutableTreeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                defaultMutableTreeNode2.add(this.cloneNode((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i)));
            }
        }
        return defaultMutableTreeNode2;
    }

    private DefaultMutableTreeNode removeFromParent(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        if (defaultMutableTreeNode3 != null) {
            defaultMutableTreeNode3.remove(defaultMutableTreeNode);
            defaultMutableTreeNode2 = defaultMutableTreeNode3.getChildCount() > 0 ? (DefaultMutableTreeNode)defaultMutableTreeNode3.getFirstChild() : defaultMutableTreeNode3;
            this.isChanged = true;
            this.treeModel.nodeChanged(defaultMutableTreeNode3);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        return defaultMutableTreeNode2;
    }

    public void deleteNode() {
        if (this.getCurrentSelection()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.currentSelection.getLastPathComponent();
            if (this.canBeSource(defaultMutableTreeNode, true)) {
                Toolkit.getDefaultToolkit().beep();
                Container container = ArachComp.getFrameParent(this);
                TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
                int n = JOptionPane.showConfirmDialog(container, "Warning: you are about to delete\n\"" + treePath + "\"\nand any children it may have.\nThis action cannot be undone.\nProceed?", "Macro Tree deletion", 0);
                if (n == 0) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = this.removeFromParent(defaultMutableTreeNode);
                    this.isChanged = true;
                    this.updateAfterChange(defaultMutableTreeNode, defaultMutableTreeNode2, true, true);
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public void moveUp() {
        this.swapNodes(-1);
    }

    public void moveDown() {
        this.swapNodes(1);
    }

    private void swapNodes(int n) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        if (this.getCurrentSelection() && (defaultMutableTreeNode2 = (DefaultMutableTreeNode)(defaultMutableTreeNode = (DefaultMutableTreeNode)this.currentSelection.getLastPathComponent()).getParent()) != null) {
            int n2 = defaultMutableTreeNode2.getChildCount();
            int n3 = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode);
            int n4 = (n3 + n + n2) % n2;
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n4);
            defaultMutableTreeNode2.insert(defaultMutableTreeNode3, n3);
            defaultMutableTreeNode2.insert(defaultMutableTreeNode, n4);
            this.isChanged = true;
            this.updateAfterChange(defaultMutableTreeNode2, false, false);
            this.refocusNode(defaultMutableTreeNode);
        }
    }

    public void editNode() {
        this.editNode(this.frame, this.tabSize);
    }

    public void editNode(Frame frame, int n) {
        if (this.getCurrentSelection(false)) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.currentSelection.getLastPathComponent();
            MacroTreeNodeData macroTreeNodeData = (MacroTreeNodeData)defaultMutableTreeNode.getUserObject();
            this.main.showMacroEditPanel(true, false);
            this.main.macroEditor.edit(this, defaultMutableTreeNode);
            this.isChanged = true;
        }
    }

    public void acceptEdit(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.treeModel.nodeChanged(defaultMutableTreeNode);
        this.isChanged = true;
        this.updateAfterChange(defaultMutableTreeNode, false, false);
    }

    public boolean itemVisible() {
        if (this.getCurrentSelection()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.currentSelection.getLastPathComponent();
            MacroTreeNodeData macroTreeNodeData = (MacroTreeNodeData)defaultMutableTreeNode.getUserObject();
            return !macroTreeNodeData.isHidden;
        }
        return false;
    }

    public void showHide() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (this.getCurrentSelection() && (defaultMutableTreeNode = (DefaultMutableTreeNode)this.currentSelection.getLastPathComponent()).getParent() != null) {
            MacroTreeNodeData macroTreeNodeData = (MacroTreeNodeData)defaultMutableTreeNode.getUserObject();
            macroTreeNodeData.isHidden = !macroTreeNodeData.isHidden;
            this.treeModel.nodeChanged(defaultMutableTreeNode);
            this.isChanged = true;
            this.updateAfterChange(defaultMutableTreeNode, true, false);
        }
    }

    public void newNode() {
        if (this.getCurrentSelection()) {
            MacroTreeNodeData macroTreeNodeData = new MacroTreeNodeData("", "New Item", "");
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(macroTreeNodeData);
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.currentSelection.getLastPathComponent();
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
            macroTreeNodeData.name = ArachComp.getStringForNode(defaultMutableTreeNode);
            this.isChanged = true;
            this.treeModel.nodeStructureChanged(defaultMutableTreeNode2);
            this.refocusNode(defaultMutableTreeNode);
            this.main.getMacroPanel().setEditMode(true, true);
        }
    }

    public void sortNormal() {
        this.sort(false);
    }

    public void sortReverse() {
        this.sort(true);
    }

    private void sort(boolean bl) {
        int n = JOptionPane.showConfirmDialog(this.main, "Sorting a long list of alphabetic commands may make\nsense, but you cannot undo a sort, and if you sort\na toolbar, you may soon wish you hadn't.\nOkay to continue?", "Sort Macro List", 0);
        if (n == 0 && this.getCurrentSelection()) {
            int n2;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.currentSelection.getLastPathComponent();
            int n3 = defaultMutableTreeNode.getChildCount();
            Vector<TreeNode> vector = new Vector<TreeNode>();
            for (n2 = 0; n2 < n3; ++n2) {
                vector.add(defaultMutableTreeNode.getChildAt(n2));
            }
            Collections.sort(vector, new MyComp(bl));
            defaultMutableTreeNode.removeAllChildren();
            for (n2 = 0; n2 < n3; ++n2) {
                defaultMutableTreeNode.add((DefaultMutableTreeNode)vector.get(n2));
            }
            this.treeModel.nodeStructureChanged(defaultMutableTreeNode);
            this.isChanged = true;
            this.updateAfterChange(defaultMutableTreeNode, true, true);
        }
    }

    class MyComp
    implements Comparator {
        boolean sortReverse;

        public MyComp(boolean bl) {
            this.sortReverse = bl;
        }

        public int compare(Object object, Object object2) {
            MacroTreeNodeData macroTreeNodeData = (MacroTreeNodeData)((DefaultMutableTreeNode)object).getUserObject();
            MacroTreeNodeData macroTreeNodeData2 = (MacroTreeNodeData)((DefaultMutableTreeNode)object2).getUserObject();
            return this.sortReverse ? macroTreeNodeData2.title.compareTo(macroTreeNodeData.title) : macroTreeNodeData.title.compareTo(macroTreeNodeData2.title);
        }
    }

    class MyRenderer
    extends DefaultTreeCellRenderer {
        MyRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof MacroTreeNodeData) {
                MacroTreeNodeData macroTreeNodeData = (MacroTreeNodeData)object2;
                if (macroTreeNodeData.isHidden) {
                    this.setText("(" + macroTreeNodeData.title + ")");
                } else {
                    this.setText(macroTreeNodeData.title);
                }
                if (macroTreeNodeData.toolTip.length() > 0) {
                    this.setToolTipText(macroTreeNodeData.toolTip);
                } else if (macroTreeNodeData.keyboardHook != null) {
                    this.setToolTipText(macroTreeNodeData.keyboardHook.getDescription());
                }
                if (bl3) {
                    if (macroTreeNodeData.imageIcon != null) {
                        this.setIcon(macroTreeNodeData.imageIcon);
                    } else {
                        this.setIcon(this.getLeafIcon());
                    }
                }
            }
            return this;
        }
    }
}

