/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import Arachnophilia.AboutBox;
import Arachnophilia.ArachComp;
import Arachnophilia.ArachConstants;
import Arachnophilia.Arachnophilia;
import Arachnophilia.DocumentProcessingFunctions;
import Arachnophilia.EscapeUnescapeStringHandler;
import Arachnophilia.PageColorSetupDialog;
import Arachnophilia.SearchReplace;
import Arachnophilia.TextInputDialog;
import BaseCalc.BaseFrame;
import BrowserStuff.BrowserDialog;
import CompilerReplyPanel.ReplyPanel;
import ConsoleWindow.ConsoleWindow;
import FTPService.FTPFrame;
import ListTableWizards.TableWizardFrame;
import LookAndFeel.LookAndFeelDialog;
import MacroManager.MacroTreePanel;
import RTFConverter.RTFConverter;
import SpellCheck.SpellCheckFrame;
import StyleColorHandler.StyleColorDialog;
import TipOfTheDay.TipJFrame;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public final class ComSwitchboard {
    HashMap array;
    public String[] sortedList;
    public String[] sortedTips;
    Arachnophilia main;
    JComponent menuItem = null;

    public ComSwitchboard(Arachnophilia arachnophilia) {
        this.main = arachnophilia;
        this.init();
    }

    public ComSwitchboard() {
        this.init();
    }

    private void init() {
        Object object;
        int n;
        this.array = new HashMap();
        String string = "class Arachnophilia.ComSwitchboard$";
        Class<?>[] classArray = this.getClass().getDeclaredClasses();
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < classArray.length; ++n) {
            String string2;
            object = classArray[n].getInterfaces();
            if (((Class<?>[])object).length <= 0 || !(string2 = classArray[n].toString()).substring(0, string.length()).equals(string)) continue;
            String string3 = string2.substring(string.length());
            vector.add(string3);
            this.array.put(string3, new SwitchData(classArray[n], string3));
        }
        this.sortedList = vector.toArray(new String[0]);
        Arrays.sort(this.sortedList);
        this.sortedTips = new String[this.sortedList.length];
        for (n = 0; n < this.sortedList.length; ++n) {
            int n2;
            object = "???";
            if (this.comExists(this.sortedList[n])) {
                object = this.createInstance(this.sortedList[n]).getDescription();
            }
            if ((n2 = ((String)object).indexOf(10)) != -1) {
                object = "<html>" + new SearchReplace().srchRplc((String)object, "\n", "<br/>") + "</html>";
            }
            this.sortedTips[n] = object;
        }
    }

    public String formatCommandList() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = "NOTE: Any of these system commands may be included in your own macros.\nIn fact, that is how the system menus and toolbars are created.\n\n";
        stringBuffer.append(string);
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        int n3 = 0;
        for (n2 = 0; n2 < this.sortedList.length; ++n2) {
            String string2;
            ComInterface comInterface = this.createInstance(this.sortedList[n2]);
            String string3 = comInterface.getDescription();
            Vector vector3 = ArachComp.parseDelimLine(string3, "\n");
            String[] stringArray = vector3.toArray(new String[0]);
            n = stringArray.length;
            if (n > 0 && stringArray[0].length() > 0) {
                string2 = "[" + this.sortedList[n2] + "]";
                n3 = ArachComp.getMax(string2, n3);
                vector.add(string2);
                vector2.add(stringArray[0]);
            }
            if (n <= 1 || stringArray[1].length() <= 0) continue;
            string2 = "[" + this.sortedList[n2] + ":arg]";
            n3 = ArachComp.getMax(string2, n3);
            vector.add(string2);
            vector2.add(stringArray[1]);
        }
        stringBuffer.append(ArachComp.doPostTab("Macro Tag", n3) + "Comment\n");
        stringBuffer.append(ArachComp.dashedLine(70) + "\n");
        n = vector.size();
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(ArachComp.doPostTab((String)vector.get(n2), n3) + (String)vector2.get(n2) + "\n");
        }
        return stringBuffer.toString();
    }

    public Vector getVectorList() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.sortedList.length; ++i) {
            vector.add("[" + this.sortedList[i] + "]");
        }
        return vector;
    }

    private void test() {
        try {
            for (int i = 0; i < this.sortedList.length; ++i) {
                ComInterface comInterface = this.createInstance(this.sortedList[i]);
                if (comInterface == null) continue;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ComInterface createInstance(String string) {
        ComInterface comInterface = null;
        try {
            Class clazz = ((SwitchData)this.array.get((Object)string)).cls;
            Constructor<?>[] constructorArray = clazz.getConstructors();
            if (constructorArray.length != 0) {
                comInterface = (ComInterface)constructorArray[0].newInstance(this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return comInterface;
    }

    private boolean comExists(String string) {
        return this.array.containsKey(string);
    }

    private boolean macroExists(String string) {
        MacroTreePanel macroTreePanel = this.main.getMacroPanel();
        if (macroTreePanel != null) {
            return macroTreePanel.macroExists(string);
        }
        return false;
    }

    private String getMacroContent(String string) {
        return this.main.getMacroPanel().getMacroContent(string);
    }

    private int scanThroughBrackets(String string, int n, int n2) {
        int n3 = n2;
        int n4 = 0;
        int n5 = string.length();
        while (n < n5) {
            char c = string.charAt(n);
            if (c == '[') {
                ++n4;
            } else if (c == ']' && --n4 == -1) {
                n3 = n;
                break;
            }
            ++n;
        }
        return n3;
    }

    public String exec(String string, int n, JComponent jComponent) {
        this.menuItem = jComponent;
        String string2 = this.exec(string, n);
        this.menuItem = null;
        return string2;
    }

    public String exec(String string, int n) {
        int n2;
        if (n > 16) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.main, "There has been a stack overflow\nin the macro processor. This is\nbasically caused by a macro\nreferring to itself in one way or another.The most recent macro content is:\n\n\"" + string + "\"", "Macro Stack Overflow", 0);
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = string.length();
        int n4 = 0;
        int n5 = -1;
        do {
            if ((n2 = string.indexOf("[", n4)) == -1 || n2 >= n3 - 1) continue;
            if (n2 > 0 && string.charAt(n2 - 1) == '\\') {
                stringBuffer.append(string.substring(n4, n2 - 1) + '[');
                n4 = n2 + 1;
                n5 = string.indexOf("]", n4);
                if (n5 == -1) continue;
                stringBuffer.append(string.substring(n4, n5));
                stringBuffer.append(']');
                n4 = n5 + 1;
                continue;
            }
            stringBuffer.append(string.substring(n4, n2));
            n4 = n2 + 1;
            n5 = string.indexOf("]", n2);
            if (n5 != -1) {
                Object object;
                String string2 = "";
                String string3 = "";
                int n6 = string.indexOf(":", n2);
                if (n6 != -1 && n6 < n5) {
                    if ((n5 = this.scanThroughBrackets(string, n6, n5)) != -1 && (string2 = string.substring(n6 + 1, n5)).length() > 0) {
                        string2 = this.exec(string2, n + 1);
                    }
                    string3 = string.substring(n2 + 1, n6);
                } else {
                    string3 = string.substring(n2 + 1, n5);
                }
                String string4 = "[" + string3 + "]";
                if (this.macroExists(string4)) {
                    object = this.exec(this.getMacroContent(string4), n + 1);
                    stringBuffer.append((String)object);
                    n4 = n5 + 1;
                    continue;
                }
                if (this.comExists(string3)) {
                    object = this.createInstance(string3);
                    if (object != null) {
                        String string5 = object.exec(string2);
                        stringBuffer.append(string5);
                    }
                    n4 = n5 + 1;
                    continue;
                }
                stringBuffer.append(string.substring(n2, n5));
                stringBuffer.append(']');
                n4 = n5 + 1;
                continue;
            }
            stringBuffer.append(string.substring(n4, n3));
            n4 = n3;
        } while (n2 != -1 && n2 < n3 - 1 && n5 != -1 && n4 < n3);
        if (n4 < n3) {
            stringBuffer.append(string.substring(n4));
        }
        return stringBuffer.toString();
    }

    private void sysErrorMessage(String string, String string2) {
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(null, "Sorry!\n\nThe command string \"" + string + "\"\ncaused your system to become petulant.\n" + "Here is the error message:\n\"" + string2 + "\"", "System Exec Error", 1);
    }

    public static interface ComInterface {
        public String exec(String var1);

        public String getDescription();
    }

    class DateTime
    implements ComInterface {
        String desc = "Insert the current date and time using the default locale";

        public String exec(String string) {
            return DateFormat.getDateTimeInstance().format(new java.util.Date());
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class Time
    implements ComInterface {
        String desc = "Insert the current time using the default locale";

        public String exec(String string) {
            return DateFormat.getTimeInstance().format(new java.util.Date());
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class Date
    implements ComInterface {
        String desc = "Insert the current date using the default locale";

        public String exec(String string) {
            return DateFormat.getDateInstance().format(new java.util.Date());
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class Filename
    implements ComInterface {
        String desc = "Insert the filename of the current document";

        public String exec(String string) {
            String string2 = "";
            if (ComSwitchboard.this.main.currentSelectedDocument != null) {
                string2 = ComSwitchboard.this.main.currentSelectedDocument.name;
            }
            return string2;
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class Classname
    implements ComInterface {
        String desc = "Insert the Java \"classname\" (the filename stripped of its suffix) into the current document";

        public String exec(String string) {
            int n;
            String string2 = "";
            if (ComSwitchboard.this.main.currentSelectedDocument != null && (n = (string2 = ComSwitchboard.this.main.currentSelectedDocument.name).lastIndexOf(46)) != -1) {
                string2 = string2.substring(0, n);
            }
            return string2;
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class Pathname
    implements ComInterface {
        String desc = "Insert the directory path of the current document";

        public String exec(String string) {
            String string2 = "";
            if (ComSwitchboard.this.main.currentSelectedDocument != null) {
                string2 = ComSwitchboard.this.main.currentSelectedDocument.path;
            }
            return string2;
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class FullPath
    implements ComInterface {
        String desc = "Insert the full path and name of the current document";

        public String exec(String string) {
            String string2 = "";
            if (ComSwitchboard.this.main.currentSelectedDocument != null) {
                string2 = ComSwitchboard.this.main.currentSelectedDocument.fullPath;
            }
            return string2;
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class UnescapeText
    implements ComInterface {
        String desc = "Unescape document/selection text \\\" -> \" etc.";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).unescapeText();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class EscapeText
    implements ComInterface {
        String desc = "Escape document/selection text \" -> \\\" etc.";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).escapeText();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class CvtHTMLChars
    implements ComInterface {
        String desc = "Convert document/selection HTML entities to extended characters";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).entityToChar();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class CvtExtChars
    implements ComInterface {
        String desc = "Convert document/selection extended characters to HTML entities";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).entityToString();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class TagsLowercase
    implements ComInterface {
        String desc = "Convert document/selection HTML tags to lowercase";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).changeTagCase(false);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class TagsUppercase
    implements ComInterface {
        String desc = "Convert document/selection HTML tags to uppercase";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).changeTagCase(true);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class CompressText
    implements ComInterface {
        String desc = "Convert document/selection individual lines into a paragraph";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).compressText();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class LeftFlushLines
    implements ComInterface {
        String desc = "Remove document/selection leading tabs and spaces";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).leftFlushLines();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class TagDelimsUnescape
    implements ComInterface {
        String desc = "Convert document/selection HTML tag symbols \"<,>\" to \"&lt;,&gt;\"";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).tagDelimsUnescape();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class TagDelimsEscape
    implements ComInterface {
        String desc = "Convert document/selection HTML tag symbols \"&lt;,&gt;\" to \"<,>\"";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).tagDelimsEscape();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class HTMLToText
    implements ComInterface {
        String desc = "Convert document/selection HTML to plain text (strips all tags, adds linefeeds as required)";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).convertHTMLToText();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class TextToHTML
    implements ComInterface {
        String desc = "Convert document/selection plain text to HTML (adds minimal appropriate tags)";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).convertTextToHTML();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class EditSelectAll
    implements ComInterface {
        String desc = "Select all text in current document";

        public String exec(String string) {
            ComSwitchboard.this.main.editSelectAll();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class EditCut
    implements ComInterface {
        String desc = "Cut selection in current document, put on clipboard";

        public String exec(String string) {
            ComSwitchboard.this.main.editCut();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class EditCopy
    implements ComInterface {
        String desc = "Copy selection in current document to clipboard";

        public String exec(String string) {
            ComSwitchboard.this.main.editCopy();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class EditPaste
    implements ComInterface {
        String desc = "Paste clipboard into current document";

        public String exec(String string) {
            ComSwitchboard.this.main.editPaste();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class EditRedo
    implements ComInterface {
        String desc = "Redo recent undone editing action";

        public String exec(String string) {
            ComSwitchboard.this.main.redo();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class EditUndo
    implements ComInterface {
        String desc = "Undo recent editing action";

        public String exec(String string) {
            ComSwitchboard.this.main.undo();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class SetTabSize
    implements ComInterface {
        String desc = "Launch set tab size dialog\nSet tab size to argument";

        public String exec(String string) {
            if (string.length() > 0) {
                ComSwitchboard.this.main.setTabSize(Integer.parseInt(string));
            } else {
                ComSwitchboard.this.main.setTabSize(0);
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class Save
    implements ComInterface {
        String desc = "Save current document";

        public String exec(String string) {
            ComSwitchboard.this.main.saveActiveDoc(false, false);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class SaveAs
    implements ComInterface {
        String desc = "Save current document using dialog\nSave current document using provided path";

        public String exec(String string) {
            if (string.length() > 0 && ComSwitchboard.this.main.currentSelectedDocument != null) {
                ComSwitchboard.this.main.currentSelectedDocument.saveFile(string, true, false, false);
            } else {
                ComSwitchboard.this.main.saveActiveDoc(true, false);
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class SaveAllChangedDocs
    implements ComInterface {
        String desc = "Save all changed open documents";

        public String exec(String string) {
            ComSwitchboard.this.main.saveAllChangedDocs();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class Replace
    implements ComInterface {
        String desc = "Replace (no regular expressions) next case of existing search text using existing replace text\nReplace (no regular expressions) next case of existing search text with argument";

        public String exec(String string) {
            ComSwitchboard.this.main.findReplacePanel.setRegExp(false);
            if (string.length() > 0) {
                ComSwitchboard.this.main.replace(string);
            } else {
                ComSwitchboard.this.main.replace(null);
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class RegExpReplace
    implements ComInterface {
        String desc = "Replace (using regular expressions) next case of existing search text using existing replace text\nReplace (using regular expressions) next case of existing search text with argument";

        public String exec(String string) {
            ComSwitchboard.this.main.findReplacePanel.setRegExp(true);
            if (string.length() > 0) {
                ComSwitchboard.this.main.replace(string);
            } else {
                ComSwitchboard.this.main.replace(null);
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class ReplaceAuto
    implements ComInterface {
        String desc = "Replace (using regular expressions if selected) next case of existing search text using existing replace text\nReplace (using regular expressions if selected) next case of existing search text with argument";

        public String exec(String string) {
            if (string.length() > 0) {
                ComSwitchboard.this.main.replace(string);
            } else {
                ComSwitchboard.this.main.replace(null);
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class FindFirst
    implements ComInterface {
        String desc = "Find (no regular expressions) first case of existing search text\nFind (no regular expressions) first case of argument text";

        public String exec(String string) {
            ComSwitchboard.this.main.findReplacePanel.setRegExp(false);
            if (string.length() > 0) {
                ComSwitchboard.this.main.findFirst(string);
            } else {
                ComSwitchboard.this.main.findFirst(null);
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class RegExpFindFirst
    implements ComInterface {
        String desc = "Find (using regular expressions) first case of existing search text\nFind (using regular expressions) first case of argument text";

        public String exec(String string) {
            ComSwitchboard.this.main.findReplacePanel.setRegExp(true);
            if (string.length() > 0) {
                ComSwitchboard.this.main.findFirst(string);
            } else {
                ComSwitchboard.this.main.findFirst(null);
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class FindFirstAuto
    implements ComInterface {
        String desc = "Find (using regular expressions if selected) first case of existing search text\nFind (using regular expressions if selected) first case of argument text";

        public String exec(String string) {
            if (string.length() > 0) {
                ComSwitchboard.this.main.findFirst(string);
            } else {
                ComSwitchboard.this.main.findFirst(null);
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class FindNext
    implements ComInterface {
        String desc = "Find (no regular expressions) next case of existing search text\nFind (no regular expressions) next case of argument text";

        public String exec(String string) {
            ComSwitchboard.this.main.findReplacePanel.setRegExp(false);
            if (string.length() > 0) {
                ComSwitchboard.this.main.findNext(string);
            } else {
                ComSwitchboard.this.main.findNext(null);
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class RegExpFindNext
    implements ComInterface {
        String desc = "Find (using regular expressions) next case of existing search text\nFind (using regular expressions) next case of argument text";

        public String exec(String string) {
            ComSwitchboard.this.main.findReplacePanel.setRegExp(true);
            if (string.length() > 0) {
                ComSwitchboard.this.main.findNext(string);
            } else {
                ComSwitchboard.this.main.findNext(null);
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class FindNextAuto
    implements ComInterface {
        String desc = "Find (using regular expressions if selected) next case of existing search text\nFind (using regular expressions if selected) next case of argument text";

        public String exec(String string) {
            if (string.length() > 0) {
                ComSwitchboard.this.main.findNext(string);
            } else {
                ComSwitchboard.this.main.findNext(null);
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class FindReplaceAll
    implements ComInterface {
        String desc = "Find (no regular expressions) and replace all cases using existing arguments\nFind (no regular expressions) and replace all cases using arguments provided as /find/replace/ (any delimiter)";

        public String exec(String string) {
            ComSwitchboard.this.main.findReplacePanel.setRegExp(false);
            if (string.length() > 0) {
                char c = string.charAt(0);
                Vector vector = ArachComp.parseDelimLine(string, "" + c);
                if (vector.size() > 2) {
                    ComSwitchboard.this.main.findReplacePanel.getFindList().getEditor().setItem((String)vector.get(1));
                    ComSwitchboard.this.main.findReplacePanel.getReplaceList().getEditor().setItem((String)vector.get(2));
                    ComSwitchboard.this.main.findReplacePanel.doAllReplace();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else {
                ComSwitchboard.this.main.findReplacePanel.doAllReplace();
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class RegExpFindReplaceAll
    implements ComInterface {
        String desc = "Find (using regular expressions) and replace all cases using existing arguments\nFind (using regular expressions) and replace all cases using arguments provided as /find/replace/ (any delimiter)";

        public String exec(String string) {
            ComSwitchboard.this.main.findReplacePanel.setRegExp(true);
            if (string.length() > 0) {
                char c = string.charAt(0);
                Vector vector = ArachComp.parseDelimLine(string, "" + c);
                if (vector.size() > 2) {
                    ComSwitchboard.this.main.findReplacePanel.getFindList().getEditor().setItem((String)vector.get(1));
                    ComSwitchboard.this.main.findReplacePanel.getReplaceList().getEditor().setItem((String)vector.get(2));
                    ComSwitchboard.this.main.findReplacePanel.doAllReplace();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else {
                ComSwitchboard.this.main.findReplacePanel.doAllReplace();
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class FindReplaceAllAuto
    implements ComInterface {
        String desc = "Find (using regular expressions if selected) and replace all cases using existing arguments\nFind (using regular expressions if selected) and replace all cases using arguments provided as /find/replace/ (any delimiter)";

        public String exec(String string) {
            if (string.length() > 0) {
                char c = string.charAt(0);
                Vector vector = ArachComp.parseDelimLine(string, "" + c);
                if (vector.size() > 2) {
                    ComSwitchboard.this.main.findReplacePanel.getFindList().getEditor().setItem((String)vector.get(1));
                    ComSwitchboard.this.main.findReplacePanel.getReplaceList().getEditor().setItem((String)vector.get(2));
                    ComSwitchboard.this.main.findReplacePanel.doAllReplace();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else {
                ComSwitchboard.this.main.findReplacePanel.doAllReplace();
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class FindSetFocus
    implements ComInterface {
        String desc = "Set system focus to find entry dialog";

        public String exec(String string) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ComSwitchboard.this.main.findReplacePanel.setFindFocus();
                }
            });
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class ToLowerCase
    implements ComInterface {
        String desc = "Convert document/selection text to lower case";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).toLowerCase();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class ToUpperCase
    implements ComInterface {
        String desc = "Convert document/selection text to upper case";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).toUpperCase();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class WordCount
    implements ComInterface {
        String desc = "Count words, lines, and characters in document/selection";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).wordCount();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class ListSystemCommands
    implements ComInterface {
        String desc = "Create a list of all system commands";

        public String exec(String string) {
            ComSwitchboard.this.main.listSystemCommands();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class ListKeyMappings
    implements ComInterface {
        String desc = "Create a list of current keyboard mappings";

        public String exec(String string) {
            ComSwitchboard.this.main.listKeyMappings();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class SystemExec
    implements ComInterface {
        String desc = "\nExecute (arg) on local system. Mostly used for compilers. (arg) may include Arachnophilia system commands";

        public String exec(String string) {
            File file = null;
            if (string.length() > 0) {
                if (ComSwitchboard.this.main.currentSelectedDocument != null) {
                    file = new File(ComSwitchboard.this.main.currentSelectedDocument.path);
                }
                try {
                    ComSwitchboard.this.main.clearCompilerPanel();
                    Process process = Runtime.getRuntime().exec(string, null, file);
                    ReplyPanel replyPanel = new ReplyPanel(ComSwitchboard.this.main);
                    replyPanel.processData(process);
                }
                catch (IOException iOException) {
                    ComSwitchboard.this.sysErrorMessage(string, iOException.toString());
                }
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class SystemConsole
    implements ComInterface {
        String desc = "\nExecute (arg) on local system with a console window. (arg) may include Arachnophilia system commands";

        public String exec(String string) {
            File file = null;
            if (string.length() > 0) {
                if (ComSwitchboard.this.main.currentSelectedDocument != null) {
                    file = new File(ComSwitchboard.this.main.currentSelectedDocument.path);
                }
                try {
                    Process process = Runtime.getRuntime().exec(string, null, file);
                    new ConsoleWindow(ComSwitchboard.this.main, process);
                }
                catch (Exception exception) {
                    ComSwitchboard.this.sysErrorMessage(string, exception.getMessage());
                }
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class NewDoc
    implements ComInterface {
        String desc = "Create new document of the most recently created type\nCreate new document of \"Type\" type";

        public String exec(String string) {
            if (string.length() > 0) {
                int n = ComSwitchboard.this.main.fileTypes.getFileTypeForName(string);
                if (n != -1) {
                    ComSwitchboard.this.main.newDoc(n, true);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(ComSwitchboard.this.main, "The file type \"" + string + "\" was not found.\n" + "Please be sure the submitted file type matches one\n" + "in the list of file types located at\n" + "\"" + ComSwitchboard.this.main.basePath + "/ArachConf/FileData.txt.\"\n" + "These file types are case sensitive.", "New file by type", 0);
                }
            } else {
                ComSwitchboard.this.main.newDoc();
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class OpenDoc
    implements ComInterface {
        String desc = "Prompt to open document of the most recently opened type\nOpen document using (arg) path";

        public String exec(String string) {
            if (string.length() > 0) {
                ComSwitchboard.this.main.openDoc(new File(string), true, true);
            } else {
                ComSwitchboard.this.main.openDoc();
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class LaunchBrowser
    implements ComInterface {
        String desc = "Launch currently selected Web browser with temporary copy of current HTML document\nLaunch registered browser named (arg)/launch default browser with URL in (arg)";

        public String exec(String string) {
            ComSwitchboard.this.main.launchBrowser(string);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class ConfigureBrowsers
    implements ComInterface {
        String desc = "Locate and select Web browsers on your system";

        public String exec(String string) {
            new BrowserDialog(ComSwitchboard.this.main);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class UndoRedoStackSize
    implements ComInterface {
        String desc = "Insert Undo/Redo stack size\nSpecify Undo/Redo stack size in (arg)";

        public String exec(String string) {
            if (string.length() > 0) {
                ComSwitchboard.this.main.configValues.undoRedoStackSize = Integer.parseInt(string);
                return "";
            }
            return "" + ComSwitchboard.this.main.configValues.undoRedoStackSize;
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class UserInput
    implements ComInterface {
        String desc = "\nLaunch a dialog to accept user input with (arg) = prompt, insert the result";

        public String exec(String string) {
            return JOptionPane.showInputDialog(ComSwitchboard.this.main, string, "Arachnophilia 5.4 User Input", 3);
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class BrowserTempFileName
    implements ComInterface {
        String desc = "Insert the current browser temporary file name for the current document";

        public String exec(String string) {
            String string2 = "";
            if (ComSwitchboard.this.main.currentSelectedDocument != null) {
                return ComSwitchboard.this.main.currentSelectedDocument.getBrowserTempFileName();
            }
            return string2;
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class ShowToolBarPanel
    implements ComInterface {
        String desc = "Toggle extended toolbar panel display\nShow/hide extended toolbar panel based on (arg)=\"y\" or \"n\"";

        public String exec(String string) {
            if (string.length() > 0) {
                ComSwitchboard.this.main.showToolBarPanel(string.toLowerCase().indexOf("y") != -1);
            } else {
                ComSwitchboard.this.main.showToolBarPanel(!ComSwitchboard.this.main.configValues.showToolBarPanel);
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class ProcessMacros
    implements ComInterface {
        String desc = "Process document/selection as though it were a macro -- find and execute embedded system commands";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).processMacrosInDocument();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class ArachVersion
    implements ComInterface {
        String desc = "Insert the name and version of Arachnophilia";

        public String exec(String string) {
            return "Arachnophilia 5.4";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class PageBackgroundColor
    implements ComInterface {
        String desc = "Insert current HTML page background color\nAccept hexadecimal code for background color as arg";

        public String exec(String string) {
            if (string.length() == 0) {
                return ArachComp.colorIntToString(ComSwitchboard.this.main.configValues.pageBackgroundColor);
            }
            ComSwitchboard.this.main.configValues.pageBackgroundColor = ArachComp.colorStringToInt(string);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class PageTextColor
    implements ComInterface {
        String desc = "Insert current HTML page text color\nAccept hexadecimal code for text color as arg";

        public String exec(String string) {
            if (string.length() == 0) {
                return ArachComp.colorIntToString(ComSwitchboard.this.main.configValues.pageTextColor);
            }
            ComSwitchboard.this.main.configValues.pageTextColor = ArachComp.colorStringToInt(string);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class PageLinkColor
    implements ComInterface {
        String desc = "Insert current HTML page link color\nAccept hexadecimal code for link color as arg";

        public String exec(String string) {
            if (string.length() == 0) {
                return ArachComp.colorIntToString(ComSwitchboard.this.main.configValues.pageLinkColor);
            }
            ComSwitchboard.this.main.configValues.pageLinkColor = ArachComp.colorStringToInt(string);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class PageVisitedLinkColor
    implements ComInterface {
        String desc = "Insert current HTML page visited link color\nAccept hexadecimal code for visited link color as arg";

        public String exec(String string) {
            if (string.length() == 0) {
                return ArachComp.colorIntToString(ComSwitchboard.this.main.configValues.pageVisitedLinkColor);
            }
            ComSwitchboard.this.main.configValues.pageVisitedLinkColor = ArachComp.colorStringToInt(string);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class PageActiveLinkColor
    implements ComInterface {
        String desc = "Insert current HTML page active link color\nAccept hexadecimal code for active link color as arg";

        public String exec(String string) {
            if (string.length() == 0) {
                return ArachComp.colorIntToString(ComSwitchboard.this.main.configValues.pageActiveLinkColor);
            }
            ComSwitchboard.this.main.configValues.pageActiveLinkColor = ArachComp.colorStringToInt(string);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class InsertValueColor
    implements ComInterface {
        String desc = "Launch color selector dialog, insert result\nLaunch color selector dialog using (arg) as user prompt (or default color hex code), insert result";

        public String exec(String string) {
            String string2 = new DocumentProcessingFunctions(ComSwitchboard.this.main).launchColorSelectorDialog(string);
            if (string2 == null) {
                string2 = "ff0000";
            }
            return string2;
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class GetSelection
    implements ComInterface {
        String desc = "Get current document selection, insert it into running macro";

        public String exec(String string) {
            return new DocumentProcessingFunctions(ComSwitchboard.this.main).getSelection();
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class BeautifyCode
    implements ComInterface {
        String desc = "\"Beautify\" document/selection program source code using rules based on file type";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).beautifyCode();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class ConvertDocToHTML
    implements ComInterface {
        String desc = "Convert current syntax-highlighted document into HTML equivalent, put result in a new HTML document";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).convertDocToHTML();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class TabsToSpaces
    implements ComInterface {
        String desc = "Convert document/selection tabs to spaces using current tab size as a guide";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).tabsToSpaces();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class SpacesToTabs
    implements ComInterface {
        String desc = "Convert document/selection spaces to tabs using current tab size as a guide";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).spacesToTabs();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class UseSpacesForTabs
    implements ComInterface {
        String desc = "\nUse spaces for tabs in program functions if (arg) = \"y\", otherwise use tabs";

        public String exec(String string) {
            if (string.length() > 0) {
                char c = Character.toLowerCase(string.charAt(0));
                ComSwitchboard.this.main.configValues.useSpacesForTabs = c == 'y';
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class BuildNewOpenMenus
    implements ComInterface {
        String desc = "Build New/Open menu trees. This command is used only during menu construction";

        public String exec(String string) {
            if (ComSwitchboard.this.menuItem != null) {
                ArachComp.buildNewOpenMenus(ComSwitchboard.this.menuItem);
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class LocateFileList
    implements ComInterface {
        String desc = "Identify the menu and position for the recent file list. This must be the last item on the menu";

        public String exec(String string) {
            if (ComSwitchboard.this.menuItem != null) {
                ComSwitchboard.this.main.recentFileList.setTarget(ComSwitchboard.this.menuItem);
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class CloseDoc
    implements ComInterface {
        String desc = "Close current document";

        public String exec(String string) {
            ComSwitchboard.this.main.closeCurrentDoc();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class CloseAllDocs
    implements ComInterface {
        String desc = "Close all documents";

        public String exec(String string) {
            ComSwitchboard.this.main.closeAllDocs();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class ClearFileList
    implements ComInterface {
        String desc = "Clear the recent file list";

        public String exec(String string) {
            ComSwitchboard.this.main.recentFileList.clearList();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class SetProgramFont
    implements ComInterface {
        String desc = "Set font tyle, style and size for entire program except programming editor display";

        public String exec(String string) {
            ComSwitchboard.this.main.setProgramFont();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class SetEditFont
    implements ComInterface {
        String desc = "Set the program editor font type, style and size";

        public String exec(String string) {
            ComSwitchboard.this.main.setEditFont();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class DisplaySyntaxColors
    implements ComInterface {
        String desc = "Choose the syntax colored display";

        public String exec(String string) {
            ComSwitchboard.this.main.changeDisplayModes(true);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class DisplayPlainText
    implements ComInterface {
        String desc = "Choose the plain text display";

        public String exec(String string) {
            ComSwitchboard.this.main.changeDisplayModes(false);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class DisplayLineNumberColumn
    implements ComInterface {
        String desc = "Toggle the line number column in the syntax-colored display";

        public String exec(String string) {
            ComSwitchboard.this.main.toggleLineNumbers();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class DisplayLineWrap
    implements ComInterface {
        String desc = "Toggle line wrapping in the plain-text display";

        public String exec(String string) {
            ComSwitchboard.this.main.toggleLineWrap();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class DisplayEOLMarks
    implements ComInterface {
        String desc = "Toggle EOL marks in the syntax-colored display";

        public String exec(String string) {
            ComSwitchboard.this.main.toggleEOLMarks();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class GetRescueMacroSet
    implements ComInterface {
        String desc = "Read the default command set from the Arachnophilia JAR file";

        public String exec(String string) {
            ComSwitchboard.this.main.getRescueMacroSet();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class SizeGraphics
    implements ComInterface {
        String desc = "compute sizes for all graphic file tags in document/selection";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).sizeGraphics();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class InsertGraphicLink
    implements ComInterface {
        String desc = "Insert a link to a graphic file in the present document position, prompts for the desired file";

        public String exec(String string) {
            return new DocumentProcessingFunctions(ComSwitchboard.this.main).insertGraphicLink();
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class InsertFullGraphicTag
    implements ComInterface {
        String desc = "Insert a full graphic \"img\" tag in the present document position, prompts for the desired file";

        public String exec(String string) {
            return new DocumentProcessingFunctions(ComSwitchboard.this.main).insertFullGraphicTag();
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class LaunchFTPService
    implements ComInterface {
        String desc = "Launch the Arachnophilia FTP service";

        public String exec(String string) {
            new FTPFrame(ComSwitchboard.this.main);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class RunGarbageCollector
    implements ComInterface {
        String desc = "Run the Java garbage collector to free memory";

        public String exec(String string) {
            System.gc();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class JumpToOppositeTag
    implements ComInterface {
        String desc = "Jump to partner HTML/XHTML tag from present position.";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).jumpToOppositeTag();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class ReplaceLiTags
    implements ComInterface {
        String desc = "Replace all closing </li> tags consistent with XHTML syntax rules";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).replaceLiTags();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class ValidateHTML
    implements ComInterface {
        String desc = "Validate an HTML document's structure -- find tag errors";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).validateHTML();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class BeautifyHTML
    implements ComInterface {
        String desc = "\"Beautify\" an HTML document -- indent it like program code";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).beautifyHTML();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class TableWizard
    implements ComInterface {
        String desc = "Launch the table wizard";

        public String exec(String string) {
            if (ComSwitchboard.this.main.tableWizard == null) {
                ComSwitchboard.this.main.tableWizard = new TableWizardFrame(ComSwitchboard.this.main);
            }
            ComSwitchboard.this.main.tableWizard.launch();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class ChoosePageColors
    implements ComInterface {
        String desc = "Choose the default HTML page colors";

        public String exec(String string) {
            new PageColorSetupDialog(ComSwitchboard.this.main);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class CreateFileLink
    implements ComInterface {
        String desc = "\nCreate an HTML-style link using an arbitrary file type specified in (arg)";

        public String exec(String string) {
            if (string.length() == 0) {
                Toolkit.getDefaultToolkit().beep();
                return "";
            }
            return new DocumentProcessingFunctions(ComSwitchboard.this.main).createFileLink(string);
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class BlockIndent
    implements ComInterface {
        String desc = "Indent document/selection one tab (or equivalent spaces)";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).blockInOutDent(1);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class BlockOutdent
    implements ComInterface {
        String desc = "Outdent document/selection one tab (or equivalent spaces)";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).blockInOutDent(-1);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class GotoLine
    implements ComInterface {
        String desc = "Launch \"Go to line\" dialog\nGoes to line (arg)";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).gotoLine(string);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class JumpDocBegin
    implements ComInterface {
        String desc = "Jump to the beginning of the document";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).jumpTo(-1, 2);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class JumpLineBegin
    implements ComInterface {
        String desc = "Jump to the beginning of the current line";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).jumpTo(-1, 1);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class JumpWordBegin
    implements ComInterface {
        String desc = "Jump to the beginning of the current word";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).jumpTo(-1, 0);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class JumpDocEnd
    implements ComInterface {
        String desc = "Jump to the end of the document";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).jumpTo(1, 2);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class JumpLineEnd
    implements ComInterface {
        String desc = "Jump to the end of the current line";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).jumpTo(1, 1);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class JumpWordEnd
    implements ComInterface {
        String desc = "Jump to the end of the current word";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).jumpTo(1, 0);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class SpellCheck
    implements ComInterface {
        public String desc = "Spell check document/selection";

        public String exec(String string) {
            if (ComSwitchboard.this.main.spellCheckFrame == null) {
                ComSwitchboard.this.main.spellCheckFrame = new SpellCheckFrame(ComSwitchboard.this.main);
            } else {
                ComSwitchboard.this.main.spellCheckFrame.spellCheck();
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class ApplicationDirectory
    implements ComInterface {
        public String desc = "Returns the application directory, the location of the running application";

        public String exec(String string) {
            return ComSwitchboard.this.main.appDir;
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class UserHomeDirectory
    implements ComInterface {
        public String desc = "Returns the user home directory, the location where Arachnophilia puts its configuration directory";

        public String exec(String string) {
            return ComSwitchboard.this.main.userHome;
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class LaunchHelp
    implements ComInterface {
        public String desc = "Launches the help system";

        public String exec(String string) {
            String string2 = "";
            if (ComSwitchboard.this.main.basePath.length() > 0 && ComSwitchboard.this.main.basePath.charAt(0) != '/') {
                string2 = string2 + '/';
            }
            Arachnophilia cfr_ignored_0 = ComSwitchboard.this.main;
            string2 = "file:" + string2 + ComSwitchboard.this.main.basePath + "/" + "Documentation" + "/index.html";
            ComSwitchboard.this.main.launchBrowser(string2);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class AboutDialog
    implements ComInterface {
        public String desc = "Launches the \"about\" dialog";

        public String exec(String string) {
            new AboutBox(ComSwitchboard.this.main, true);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class SetSyntaxColors
    implements ComInterface {
        public String desc = "Launches a dialog used to change the syntax-coloring display's colors";

        public String exec(String string) {
            new StyleColorDialog(ComSwitchboard.this.main);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class RunCustomClassArg
    implements ComInterface {
        public String desc = "\n(arg) = (className,argument). Processes argument through user class (className)";

        public String exec(String string) {
            return new DocumentProcessingFunctions(ComSwitchboard.this.main).RunCustomClassArg(string);
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class RunCustomClassDoc
    implements ComInterface {
        public String desc = "\n(arg) = className. Processes current document through a user class named in (arg)";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).RunCustomClassDoc(string);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class CloseCompilerWindow
    implements ComInterface {
        public String desc = "Close the window below the editing window that provides compiler error feedback";

        public String exec(String string) {
            ComSwitchboard.this.main.showCompilerPanel(false, null);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class ShowMacroEditorInFrame
    implements ComInterface {
        public String desc = "\nSelect macro editor as (arg=\"n\") part of main application or (arg =\"y\") in separate frame";

        public String exec(String string) {
            if (string.length() > 0) {
                char c = Character.toLowerCase(string.charAt(0));
                ComSwitchboard.this.main.configValues.showMacroEditorInFrame = c == 'y';
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class LaunchBaseCalculator
    implements ComInterface {
        public String desc = "Launch a simple number base calculator";

        public String exec(String string) {
            new BaseFrame(ComSwitchboard.this.main);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class MakeOrderedList
    implements ComInterface {
        public String desc = "Turns selected lines into ordered list\nTurns selected lines into ordered list with options specified by (arg)";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).makeOrderedList(string);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class MakeUnorderedList
    implements ComInterface {
        public String desc = "Turns selected lines into unordered list\nTurns selected lines into unordered list with options specified by (arg)";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).makeUnorderedList(string);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class SetFileType
    implements ComInterface {
        public String desc = "Launches selection dialog to choose file type for current document\nSets current document to file type name in (arg)";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).setFileType(string);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class SetLookAndFeel
    implements ComInterface {
        public String desc = "Launches Look & Feel selection dialog\n sets application look & feel based on (arg)";

        public String exec(String string) {
            new LookAndFeelDialog(ComSwitchboard.this.main, string);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class ExitApp
    implements ComInterface {
        public String desc = "Tries to save changed documents, quits Arachnophilia";

        public String exec(String string) {
            ComSwitchboard.this.main.quit();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class ShowTips
    implements ComInterface {
        public String desc = "Show the Tip of the Day dialog";

        public String exec(String string) {
            new TipJFrame(ComSwitchboard.this.main);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class AutoSave
    implements ComInterface {
        public String desc = "Launches autosave configuration dialog\nAutomatlcally saves all changed files every (arg) seconds, 0 = no autosave";

        public String exec(String string) {
            if (string.length() == 0) {
                TextInputDialog textInputDialog = new TextInputDialog(ComSwitchboard.this.main);
                string = textInputDialog.showDialog("Configure Autosave", "Choose a time interval for automatically saving changed documents, in seconds, currently " + ComSwitchboard.this.main.configValues.autoSaveIntervalSeconds + " seconds, minimum valid autosave interval 15 seconds, 0 = disable autosave.", "" + ComSwitchboard.this.main.configValues.autoSaveIntervalSeconds);
            }
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n == 0 || n >= 15) {
                ComSwitchboard.this.main.configValues.autoSaveIntervalSeconds = n;
                ComSwitchboard.this.main.configureAutoSave();
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class FileEncoding
    implements ComInterface {
        String desc = "With no argument, causes document read/write encoding to revert to the default (" + EscapeUnescapeStringHandler.escapeString("UTF8") + ")\n" + "Causes document read/write encoding to be set to (arg), example entry: UTF8";

        public String exec(String string) {
            ComSwitchboard.this.main.configValues.fileEncoding = string.length() > 0 ? string : EscapeUnescapeStringHandler.escapeString("UTF8");
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class FileSaveEOL
    implements ComInterface {
        String desc = "With no argument, causes the file saving EOL character sequence to revert to this platform's default, which is " + EscapeUnescapeStringHandler.escapeString(ArachConstants.SYSTEM_EOL) + "\n" + "Causes the file saving EOL character sequence to be set to (arg), example entry: \\r\\n";

        public String exec(String string) {
            ComSwitchboard.this.main.configValues.fileSaveEOL = string.length() > 0 ? string : EscapeUnescapeStringHandler.escapeString(ArachConstants.SYSTEM_EOL);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class ConvertRTFToHTML
    implements ComInterface {
        String desc = "Converts current RTF document to HTML";

        public String exec(String string) {
            RTFConverter rTFConverter = new RTFConverter();
            rTFConverter.convertRTFToHTML(ComSwitchboard.this.main);
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class MoveToNextDocument
    implements ComInterface {
        String desc = "Changes focus to next document in tab sequence";

        public String exec(String string) {
            ComSwitchboard.this.main.fileHandler.moveToNextDocument();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class MoveToPriorDocument
    implements ComInterface {
        String desc = "Changes focus to prior document in tab sequence";

        public String exec(String string) {
            ComSwitchboard.this.main.fileHandler.moveToPriorDocument();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class ClearSearchReplaceLists
    implements ComInterface {
        String desc = "Clears contents of search and replace dropdown lists";

        public String exec(String string) {
            ComSwitchboard.this.main.findReplacePanel.clearSearchReplaceLists();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class BlockReverseTab
    implements ComInterface {
        String desc = "Reverse-tabs text block if a block is selected, otherwise does nothing.";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).blockReverseTab();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class BlockTab
    implements ComInterface {
        String desc = "Tabs text block if a block is selected, otherwise acts as normal tab";

        public String exec(String string) {
            new DocumentProcessingFunctions(ComSwitchboard.this.main).blockTab();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class AutoIndent
    implements ComInterface {
        String desc = "Toggle auto-indent feature (new lines indented to prior lines).\nEnable/disable auto-indent (new lines indented to prior lines) for (arg) =\"y\"/\"n\").";

        public String exec(String string) {
            if (string.length() > 0) {
                char c = Character.toLowerCase(string.charAt(0));
                ComSwitchboard.this.main.configValues.autoIndent = c == 'y';
            } else {
                ComSwitchboard.this.main.configValues.autoIndent = !ComSwitchboard.this.main.configValues.autoIndent;
            }
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class AntiAliasing
    implements ComInterface {
        String desc = "Toggle anti-aliasing feature (smooth font rendering).\nEnable/disable anti-aliasing feature (smooth font rendering) (arg) =\"y\"/\"n\").";

        public String exec(String string) {
            if (string.length() > 0) {
                char c = Character.toLowerCase(string.charAt(0));
                ComSwitchboard.this.main.configValues.useAntiAliasing = c == 'y';
            } else {
                ComSwitchboard.this.main.configValues.useAntiAliasing = !ComSwitchboard.this.main.configValues.useAntiAliasing;
            }
            ComSwitchboard.this.main.setAntiAliasing();
            return "";
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class SwitchData {
        Class cls;
        String name;

        SwitchData(Class clazz, String string) {
            this.cls = clazz;
            this.name = string;
        }
    }
}

