/*
 * Decompiled with CFR 0.152.
 */
package SpellCheck;

import Arachnophilia.ArachComp;
import Arachnophilia.ArachConstants;
import Arachnophilia.ArachDocument;
import Arachnophilia.Arachnophilia;
import Arachnophilia.DocContentHandler;
import Arachnophilia.MyJButton;
import Arachnophilia.SearchReplace;
import SpellCheck.SpellCheckFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;

public final class SpellCheckPanel
extends JPanel {
    Arachnophilia main;
    SpellCheckFrame parent;
    TreeSet mainDict;
    TreeSet customDict;
    TreeSet ignoreWordList;
    String[] mainDictArray = null;
    String dictPath;
    String skipDataPath;
    Hashtable skipTagList;
    String currentWord = "";
    boolean panelLocked = false;
    boolean selectionValid = false;
    boolean validWordDisplay = false;
    ArachDocument currentDocument = null;
    String skipTagFileName = "SpellSkipTags.txt";
    DocContentHandler docHandler;
    SearchReplace srch;
    boolean stopSearch = false;
    int defaultDocPosition = 0;
    int docPosition = 0;
    int endPosition = 0;
    private JLabel jLabel4;
    private JScrollPane listScrollPane;
    private JLabel jLabel1;
    private JCheckBox isHTMLCheckBox;
    private JLabel jLabel2;
    private JList dictList;
    private JCheckBox ignoreUCCheckBox;
    private JButton startStopButton;
    private JButton hideButton;
    private JButton ignoreAllButton;
    private JButton ignoreButton;
    private JTextField wordField;
    private JButton changeButton;
    private JProgressBar progressBar;
    private JPanel centerPane;
    private JButton addButton;
    private JPanel bottomPanel;
    private JTextField replaceField;
    private JPanel rightPane;

    public SpellCheckPanel(Arachnophilia arachnophilia, SpellCheckFrame spellCheckFrame) {
        this.main = arachnophilia;
        this.parent = spellCheckFrame;
        this.initComponents();
        this.docHandler = new DocContentHandler(this.main);
        this.srch = new SearchReplace();
        this.isHTMLCheckBox.setSelected(this.main.configValues.spellIsHTML);
        this.ignoreUCCheckBox.setSelected(this.main.configValues.spellIgnoreUCWords);
        this.customDict = new TreeSet(new CaseInsensitiveComparator());
        this.mainDict = new TreeSet(new CaseInsensitiveComparator());
        this.ignoreWordList = new TreeSet();
        this.dictPath = this.main.basePath + "/" + "SpellCheckData";
        this.skipDataPath = this.dictPath + "/" + this.skipTagFileName;
        this.skipTagList = ArachComp.loadParserData(this.skipDataPath);
        this.loadDictionariesThread(this.dictPath, this.mainDict, this.customDict);
    }

    private void combineDictionaries(TreeSet treeSet, TreeSet treeSet2) {
        int n = treeSet2.size();
        this.addDictionary(treeSet, treeSet2, n);
    }

    private void addDictionary(TreeSet treeSet, TreeSet treeSet2, int n) {
        int n2 = 0;
        if (treeSet2 != null) {
            Iterator iterator = treeSet2.iterator();
            while (iterator.hasNext()) {
                treeSet.add(iterator.next());
                if (++n2 % 20 != 0) continue;
                this.setProgressBar("Adding to dictionary", 0, n2, n);
            }
        }
    }

    private void loadDictionariesThread(final String string, final TreeSet treeSet, final TreeSet treeSet2) {
        if (!this.panelLocked) {
            this.panelLocked = true;
            Thread thread = new Thread(){

                public void run() {
                    SpellCheckPanel.this.loadDictionaries(string, treeSet, treeSet2);
                    SpellCheckPanel.this.combineDictionaries(treeSet, treeSet2);
                    SpellCheckPanel.this.mainDictArray = SpellCheckPanel.this.mainDict.toArray(new String[0]);
                    SpellCheckPanel.this.setProgressBar("Ready to start.", 0, 0, 0);
                }
            };
            thread.start();
        }
    }

    private void loadDictionaries(String string, TreeSet treeSet, TreeSet treeSet2) {
        File[] fileArray = new File(string).listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                String string2 = file.getName();
                if (string2.endsWith(".zip")) {
                    this.readZipFile(file, treeSet, treeSet2);
                    continue;
                }
                if (!string2.endsWith(".txt") || string2.equals(this.skipTagFileName)) continue;
                if (string2.toLowerCase().startsWith("custom")) {
                    this.readTextFile(file, treeSet2);
                    continue;
                }
                this.readTextFile(file, treeSet);
            }
        }
        this.panelLocked = false;
    }

    private void readZipFile(File file, TreeSet treeSet, TreeSet treeSet2) {
        try {
            ZipFile zipFile = new ZipFile(file.getPath());
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                InputStreamReader inputStreamReader = new InputStreamReader(zipFile.getInputStream(zipEntry));
                String string = zipEntry.toString();
                if (string.endsWith(".txt")) {
                    if (string.toLowerCase().startsWith("custom")) {
                        this.readStream(inputStreamReader, treeSet2, inputStream.available(), string);
                    } else {
                        this.readStream(inputStreamReader, treeSet, inputStream.available(), string);
                    }
                }
                inputStreamReader.close();
            }
            zipFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void readStream(InputStreamReader inputStreamReader, TreeSet treeSet, int n, String string) {
        if (n > 0) {
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                int n2 = 0;
                int n3 = 0;
                while ((string2 = bufferedReader.readLine()) != null) {
                    treeSet.add(string2);
                    n2 += string2.length();
                    if (n3++ % 20 != 0) continue;
                    this.setProgressBar("Reading " + string, 0, n2, n);
                }
                this.setProgressBar("Done.", 0, 0, 0);
                bufferedReader.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void writeStream(OutputStreamWriter outputStreamWriter, TreeSet treeSet) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            for (String string : treeSet) {
                bufferedWriter.write(string + ArachConstants.SYSTEM_EOL);
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void readTextFile(File file, TreeSet treeSet) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = ((InputStream)fileInputStream).available();
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            this.readStream(inputStreamReader, treeSet, n, file.getName());
            inputStreamReader.close();
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void saveTextFile(File file, TreeSet treeSet) {
        if (treeSet != null && treeSet.size() > 0) {
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file));
                this.writeStream(outputStreamWriter, treeSet);
                outputStreamWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void saveCustomDict() {
        if (this.customDict != null && this.customDict.size() > 0) {
            String string = this.dictPath + "/" + "CustomDictionary.txt";
            this.saveTextFile(new File(string), this.customDict);
        }
    }

    public void spellCheckEntry() {
        ArachDocument arachDocument = this.main.currentSelectedDocument;
        if (arachDocument != null) {
            int n = this.main.fileTypes.getFileTypeForName("HTML");
            if (n == arachDocument.getFileType()) {
                this.isHTMLCheckBox.setSelected(true);
                this.resetIsHTMLFlag(this.isHTMLCheckBox);
            }
            this.ignoreWordList = new TreeSet();
            this.dictList.setListData(new String[0]);
            this.setProgressBar("Ready to start.", 0, 0, 0);
        }
    }

    private void spellCheck() {
        ArachDocument arachDocument = this.main.currentSelectedDocument;
        if (arachDocument == null || this.panelLocked) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            if (this.currentDocument != arachDocument) {
                this.ignoreWordList = new TreeSet();
                this.currentDocument = arachDocument;
            }
            this.dictList.setListData(new String[0]);
            this.wordField.setText("");
            int n = arachDocument.textComp.getSelectionStart();
            int n2 = arachDocument.textComp.getSelectionEnd();
            if (n2 > n + 32) {
                this.defaultDocPosition = n;
                this.endPosition = n2;
                this.selectionValid = true;
            } else {
                this.defaultDocPosition = 0;
                this.endPosition = arachDocument.textComp.getLength() - 1;
                this.selectionValid = false;
            }
        }
        this.docPosition = this.defaultDocPosition;
        this.scanForNextWordThread();
    }

    private void addToCustomDict() {
        if (this.validWordDisplay && !this.panelLocked) {
            if (this.currentDocument != null && this.currentDocument == this.main.currentSelectedDocument) {
                this.customDict.add(this.currentWord);
                this.combineDictionaries(this.mainDict, this.customDict);
                this.mainDictArray = this.mainDict.toArray(new String[0]);
                this.scanForNextWordThread();
            } else {
                this.spellCheck();
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private boolean nonDictWordWarning(String string) {
        int n = 0;
        if (!this.wordOK(string, this.mainDict)) {
            n = JOptionPane.showConfirmDialog(this, "The replacement word you have chosen --\n\"" + string + "\" -- is not in\n" + "the dictionary. OK to proceed?", "Word not in dictionary", 0);
        }
        return n == 0;
    }

    private void replaceWord() {
        if (this.validWordDisplay && !this.panelLocked) {
            if (this.currentDocument != null && this.currentDocument == this.main.currentSelectedDocument) {
                String string = this.replaceField.getText();
                boolean bl = this.nonDictWordWarning(string);
                if (bl) {
                    this.currentDocument.undoPush();
                    int n = this.currentDocument.textComp.getSelectionStart();
                    int n2 = this.currentDocument.textComp.getSelectionEnd();
                    this.currentDocument.textComp.replaceSelection(string);
                    this.docPosition += string.length() - (n2 - n);
                    this.scanForNextWordThread();
                }
            } else {
                this.spellCheck();
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void ignoreAll() {
        if (this.validWordDisplay && !this.panelLocked) {
            if (this.currentDocument != null && this.currentDocument == this.main.currentSelectedDocument) {
                this.ignoreWordList.add(this.currentWord);
                this.scanForNextWordThread();
            } else {
                this.spellCheck();
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void scanForNextWordThread() {
        if (!this.panelLocked) {
            this.panelLocked = true;
            Thread thread = new Thread(){

                public void run() {
                    SpellCheckPanel.this.stopSearch = false;
                    SpellCheckPanel.this.scanForNextWord();
                    SpellCheckPanel.this.panelLocked = false;
                }
            };
            thread.start();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void scanForNextWord() {
        boolean bl = true;
        if (this.currentDocument != null && this.currentDocument == this.main.currentSelectedDocument) {
            String string = this.currentDocument.textComp.getText();
            int n = string.length();
            boolean bl2 = false;
            this.validWordDisplay = false;
            while (bl && !this.stopSearch) {
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                int n3 = 0;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                int n4 = 0;
                while (!this.stopSearch && !bl4 && this.docPosition <= this.endPosition + 1 && this.docPosition <= n) {
                    String string2;
                    int n5 = 32;
                    if (this.docPosition < n && this.docPosition <= this.endPosition) {
                        n5 = string.charAt(this.docPosition);
                    }
                    if (n5 == 60 && this.main.configValues.spellIsHTML) {
                        String string3;
                        int n6;
                        bl5 = true;
                        string2 = this.isolateTag(string, this.docPosition, n);
                        if (this.skipTagList.containsKey(string2) && (n6 = this.srch.findText(string, string3 = (String)this.skipTagList.get(string2), this.docPosition, false)) != -1) {
                            this.docPosition = n6 + string3.length() - 1;
                        }
                    } else if (n5 == 38 && this.main.configValues.spellIsHTML && (string2 = this.isolateEntity(string, this.docPosition, n)).length() > 0) {
                        n5 = string2.equals("nbsp") ? 32 : (int)((char)this.main.entityProcessor.entityCharToNumber(string2, true));
                        this.docPosition += string2.length() + 1;
                    }
                    if (!bl5 && !bl6) {
                        if (bl3) {
                            if (!this.wordCharacter((char)n5)) {
                                bl4 = true;
                            } else {
                                stringBuffer.append((char)n5);
                                n3 = this.docPosition;
                            }
                        } else if (this.wordCharacter((char)n5)) {
                            n2 = this.docPosition;
                            stringBuffer.append((char)n5);
                            n3 = this.docPosition;
                            bl3 = true;
                        }
                    } else if (n5 == 62) {
                        bl5 = false;
                    }
                    ++this.docPosition;
                }
                if (this.docPosition >= n || this.docPosition >= this.endPosition + 1 || this.stopSearch) {
                    this.setProgressBar("Done.", 0, 0, 100);
                    bl = false;
                    bl2 = true;
                    Toolkit.getDefaultToolkit().beep();
                } else if (n4++ % 20 == 0) {
                    this.setProgressBar("Scanning", this.defaultDocPosition, this.docPosition - 1, n);
                }
                if (!bl4) continue;
                int n7 = n3;
                String string4 = stringBuffer.toString();
                if (this.wordOK(string4, this.mainDict) || this.wordOK(string4, this.ignoreWordList)) continue;
                this.processFind(string4, n2, n7, n);
                bl = false;
            }
        } else {
            bl = false;
            Toolkit.getDefaultToolkit().beep();
        }
        if (this.stopSearch) {
            this.setProgressBar("Stopped.", 0, 0, 0);
        }
    }

    private void processFind(final String string, final int n, final int n2, final int n3) {
        Runnable runnable = new Runnable(){

            public void run() {
                SpellCheckPanel.this.processFindDispatch(string, n, n2, n3);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void processFindDispatch(String string, int n, int n2, int n3) {
        this.setProgressBar("Scanning", this.defaultDocPosition, this.docPosition - 1, n3);
        this.setList(string, this.mainDict);
        this.showFind(this.currentDocument, n, n2 + 1);
        this.wordField.setText(string);
        this.currentWord = string;
        this.validWordDisplay = true;
    }

    private void setList(String string, TreeSet treeSet) {
        SortedSet<String> sortedSet = treeSet.headSet(string);
        int n = sortedSet.size();
        String string2 = "";
        int n2 = 32;
        int n3 = this.mainDictArray.length;
        int n4 = -1;
        int n5 = 0;
        Vector<String> vector = new Vector<String>();
        for (int i = -n2; i < n2; ++i) {
            int n6 = n + i;
            if (n6 < 0 || n6 >= n3) continue;
            if (i == 0) {
                n4 = n5;
                string2 = this.mainDictArray[n6];
            }
            vector.add(this.mainDictArray[n6]);
            ++n5;
        }
        this.replaceField.setText(string2);
        this.dictList.setListData(vector.toArray(new String[0]));
        if (n4 >= 0 && n4 < n5) {
            this.dictList.setSelectedIndex(n4);
            Point point = this.dictList.indexToLocation(n4);
            Dimension dimension = this.listScrollPane.getSize();
            int n7 = point.y - dimension.height / 2;
            this.listScrollPane.getVerticalScrollBar().setValue(n7);
        }
    }

    private void setProgressBar(final String string, final int n, final int n2, final int n3) {
        Runnable runnable = new Runnable(){

            public void run() {
                SpellCheckPanel.this.setProgressBarDispatch(string, n, n2, n3);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void setProgressBarDispatch(String string, int n, int n2, int n3) {
        if (string.endsWith(".")) {
            this.progressBar.setValue(0);
            this.progressBar.setString(string);
        } else if (n3 > 0) {
            this.progressBar.setMinimum(n);
            this.progressBar.setMaximum(n3);
            this.progressBar.setValue(n2);
            this.progressBar.setString(string + " " + 100 * n2 / n3 + "%");
        }
    }

    private void showFind(ArachDocument arachDocument, int n, int n2) {
        arachDocument.centerCaret = true;
        arachDocument.textComp.select(n, n2);
        Caret caret = arachDocument.textComp.getCaret();
        if (caret != null) {
            caret.setSelectionVisible(true);
        }
    }

    private boolean wordOK(String string, TreeSet treeSet) {
        if (treeSet.contains(string)) {
            return true;
        }
        if (this.main.configValues.spellIgnoreUCWords && string.toUpperCase().equals(string)) {
            return true;
        }
        if (treeSet.contains(string.toLowerCase())) {
            return true;
        }
        if (string.length() < 2) {
            return true;
        }
        if (string.length() > 2 && string.toLowerCase().endsWith("'s")) {
            return this.wordOK(string.substring(0, string.length() - 2), treeSet);
        }
        if (string.length() > 1 && string.toLowerCase().endsWith("s")) {
            return this.wordOK(string.substring(0, string.length() - 1), treeSet);
        }
        if (string.length() > 1 && string.toLowerCase().endsWith("'")) {
            return this.wordOK(string.substring(0, string.length() - 1), treeSet);
        }
        if (string.length() > 1 && string.toLowerCase().startsWith("'")) {
            return this.wordOK(string.substring(string.length() - 1), treeSet);
        }
        return false;
    }

    private boolean testUpperCase(char c, boolean bl) {
        if (!Character.isUpperCase(c)) {
            bl = false;
        }
        return bl;
    }

    private boolean wordCharacter(char c) {
        return Character.isLetter(c) || c == '\'';
    }

    private String isolateTag(String string, int n, int n2) {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        while (n < n2 && (c = string.charAt(n)) == '<') {
            ++n;
        }
        while (n < n2 && !Character.isWhitespace(c = string.charAt(n)) && c != '>') {
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString().toLowerCase();
    }

    private String isolateEntity(String string, int n, int n2) {
        char c;
        int n3;
        int n4 = 6;
        StringBuffer stringBuffer = new StringBuffer();
        for (n3 = 0; n < n2 && n3 < n4 && (c = string.charAt(n)) == '&'; ++n, ++n3) {
        }
        while (n < n2 && n3 < n4 && (c = string.charAt(n)) != ';') {
            stringBuffer.append(c);
            ++n;
            ++n3;
        }
        if (n3 >= n4) {
            return "";
        }
        return stringBuffer.toString();
    }

    private void selectDictionaryWord() {
        String string = (String)this.dictList.getSelectedValue();
        if (string != null) {
            this.replaceField.setText(string);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void startOrStop() {
        if (!this.panelLocked) {
            this.spellCheck();
        } else {
            this.stopSearch = true;
        }
    }

    private void resetIsHTMLFlag(Object object) {
        this.main.configValues.spellIsHTML = ((JCheckBox)object).getSelectedObjects() != null;
    }

    private void resetIgnoreUCFlag(Object object) {
        this.main.configValues.spellIgnoreUCWords = ((JCheckBox)object).getSelectedObjects() != null;
    }

    private void initComponents() {
        this.rightPane = new JPanel();
        this.startStopButton = new MyJButton();
        this.ignoreButton = new MyJButton();
        this.ignoreAllButton = new MyJButton();
        this.addButton = new MyJButton();
        this.changeButton = new MyJButton();
        this.hideButton = new MyJButton();
        this.centerPane = new JPanel();
        this.jLabel1 = new JLabel();
        this.wordField = new JTextField();
        this.jLabel2 = new JLabel();
        this.listScrollPane = new JScrollPane();
        this.dictList = new JList();
        this.jLabel4 = new JLabel();
        this.replaceField = new JTextField();
        this.bottomPanel = new JPanel();
        this.progressBar = new JProgressBar();
        this.isHTMLCheckBox = new JCheckBox();
        this.ignoreUCCheckBox = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.rightPane.setLayout(new GridBagLayout());
        this.startStopButton.setText("Start/Stop");
        this.startStopButton.setToolTipText("Start from beginning/Stop scan");
        this.startStopButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SpellCheckPanel.this.startStopButtonMouseClicked(mouseEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.rightPane.add((Component)this.startStopButton, gridBagConstraints);
        this.ignoreButton.setText("Ignore once");
        this.ignoreButton.setToolTipText("Skip this word, move on");
        this.ignoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpellCheckPanel.this.ignoreButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.rightPane.add((Component)this.ignoreButton, gridBagConstraints);
        this.ignoreAllButton.setText("Ignore all");
        this.ignoreAllButton.setToolTipText("Ignore all cases of this word in this document");
        this.ignoreAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpellCheckPanel.this.ignoreAllButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.rightPane.add((Component)this.ignoreAllButton, gridBagConstraints);
        this.addButton.setText("Add");
        this.addButton.setToolTipText("Add this word to your custom dictionary");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpellCheckPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.rightPane.add((Component)this.addButton, gridBagConstraints);
        this.changeButton.setText("Replace");
        this.changeButton.setToolTipText("Replace word in document");
        this.changeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpellCheckPanel.this.changeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.rightPane.add((Component)this.changeButton, gridBagConstraints);
        this.hideButton.setText("Hide");
        this.hideButton.setToolTipText("Hide this dialog");
        this.hideButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpellCheckPanel.this.hideButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.rightPane.add((Component)this.hideButton, gridBagConstraints);
        this.add((Component)this.rightPane, "East");
        this.centerPane.setLayout(new GridBagLayout());
        this.jLabel1.setText("Not found:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 8, 4, 4);
        this.centerPane.add((Component)this.jLabel1, gridBagConstraints);
        this.wordField.setToolTipText("This word was not found in the dctionary");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.centerPane.add((Component)this.wordField, gridBagConstraints);
        this.jLabel2.setText("Nearest match in dictionary:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 8, 4, 4);
        this.centerPane.add((Component)this.jLabel2, gridBagConstraints);
        this.dictList.setToolTipText("Nearest match list");
        this.dictList.setMinimumSize(new Dimension(10, 1000));
        this.dictList.setPreferredSize(new Dimension(10, 1000));
        this.dictList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SpellCheckPanel.this.dictListMouseClicked(mouseEvent);
            }
        });
        this.listScrollPane.setViewportView(this.dictList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 8, 4, 4);
        this.centerPane.add((Component)this.listScrollPane, gridBagConstraints);
        this.jLabel4.setText("Replace with:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 8, 4, 4);
        this.centerPane.add((Component)this.jLabel4, gridBagConstraints);
        this.replaceField.setToolTipText("<html>Select a dictionary word<br>or type in a replacement word</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.centerPane.add((Component)this.replaceField, gridBagConstraints);
        this.add((Component)this.centerPane, "Center");
        this.bottomPanel.setLayout(new GridBagLayout());
        this.progressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottomPanel.add((Component)this.progressBar, gridBagConstraints);
        this.isHTMLCheckBox.setText("Is HTML");
        this.isHTMLCheckBox.setToolTipText("Use special HTML document processing");
        this.isHTMLCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpellCheckPanel.this.isHTMLCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottomPanel.add((Component)this.isHTMLCheckBox, gridBagConstraints);
        this.ignoreUCCheckBox.setText("Skip Uppercase");
        this.ignoreUCCheckBox.setToolTipText("Disregard ALL-UPPERCASE words");
        this.ignoreUCCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpellCheckPanel.this.ignoreUCCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottomPanel.add((Component)this.ignoreUCCheckBox, gridBagConstraints);
        this.add((Component)this.bottomPanel, "South");
    }

    private void hideButtonActionPerformed(ActionEvent actionEvent) {
        this.parent.saveAndHide();
    }

    private void changeButtonActionPerformed(ActionEvent actionEvent) {
        this.replaceWord();
    }

    private void startStopButtonMouseClicked(MouseEvent mouseEvent) {
        this.startOrStop();
    }

    private void dictListMouseClicked(MouseEvent mouseEvent) {
        this.selectDictionaryWord();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        this.addToCustomDict();
    }

    private void ignoreAllButtonActionPerformed(ActionEvent actionEvent) {
        this.ignoreAll();
    }

    private void ignoreUCCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.resetIgnoreUCFlag(actionEvent.getSource());
    }

    private void ignoreButtonActionPerformed(ActionEvent actionEvent) {
        this.scanForNextWord();
    }

    private void isHTMLCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.resetIsHTMLFlag(actionEvent.getSource());
    }

    class CaseInsensitiveComparator
    implements Comparator {
        CaseInsensitiveComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = ((String)object).compareToIgnoreCase((String)object2);
            if (n == 0) {
                return ((String)object).compareTo((String)object2);
            }
            return n;
        }

        public boolean equals(Object object, Object object2) {
            return ((String)object).equals((String)object2);
        }
    }
}

