/*
 * Decompiled with CFR 0.152.
 */
package MacroManager;

import Arachnophilia.ArachComp;
import Arachnophilia.Arachnophilia;
import Arachnophilia.IconSelector;
import Arachnophilia.MyJButton;
import Arachnophilia.MyJPopupMenu;
import Arachnophilia.MyJTextArea;
import MacroManager.KeyDescription;
import MacroManager.MacroTreeNodeData;
import MacroManager.MacroTreePanel;
import MacroManager.MyJTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public final class MacroEditor
extends JPanel {
    public boolean validData = false;
    public boolean changed = false;
    public boolean oldChanged = false;
    private DefaultMutableTreeNode node = null;
    public MacroTreeNodeData data = null;
    private boolean keyTrap = false;
    private KeyDescription keyboardHook = null;
    private boolean keyAccepted = false;
    private boolean suppressChanges = false;
    int tabSize = 8;
    Arachnophilia main;
    MyJTree parent = null;
    Vector comList;
    String icon;
    private JPanel bottomPanel;
    private JButton cancelButton;
    private JButton chooseIconButton;
    private JButton clearKeyDef;
    private JButton closeButton;
    private JPanel controlPanel;
    private JMenuItem dockUndockMenuItem;
    private JCheckBox isHiddenCheckBox;
    private JCheckBox isMenuCheckBox;
    private JCheckBox isToolBarCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JTextField keyHookField;
    private JToggleButton keyTestButton;
    private JMenuItem lineWrapMenuItem;
    private JComboBox macroComboBox;
    private JTextArea macroTextArea;
    private JPanel middlePanel;
    private JTextField nameField;
    private JButton okButton;
    private JPopupMenu popupMenu;
    private JCheckBox separatorCheckBox;
    private JCheckBox showTitleCheckBox;
    private JComboBox systemComBox;
    private JTextField titleField;
    private JTextField toolTipField;
    private JPanel topControlPanel;
    private JPanel topPanel;

    public MacroEditor(Arachnophilia arachnophilia) {
        this.main = arachnophilia;
        this.init();
    }

    private void init() {
        this.comList = this.main.comSwitchboard.getVectorList();
        this.setLayout(new BorderLayout());
        this.initComponents();
        this.keyHookField.setFocusTraversalKeysEnabled(false);
        MacroTreePanel macroTreePanel = this.main.getMacroPanel();
        if (macroTreePanel != null) {
            Vector vector = macroTreePanel.mjt.getMacroList();
            this.updateMacroList(vector);
        }
        this.macroTextArea.setLineWrap(true);
        this.macroTextArea.setWrapStyleWord(true);
        this.macroTextArea.setTabSize(this.tabSize);
        this.macroTextArea.setUI(this.macroTextArea.getUI());
    }

    private void updateMacroList(Vector vector) {
        this.suppressChanges = true;
        int n = this.macroComboBox.getSelectedIndex();
        this.macroComboBox.setModel(new DefaultComboBoxModel(vector));
        if (n > -1 && n < this.macroComboBox.getItemCount()) {
            this.macroComboBox.setSelectedIndex(n);
        }
        this.suppressChanges = false;
    }

    public void saveOnExit() {
        this.testSaveChanges();
    }

    public void testSaveChanges() {
        if (this.node != null && this.changed) {
            TreePath treePath = new TreePath(this.node.getPath());
            int n = JOptionPane.showConfirmDialog(this, "You have made changes to\n" + treePath.toString() + "\nDo you want to save these changes?", "Macro edit not saved", 0);
            if (n == 0) {
                this.acceptData();
            }
        }
        this.setChanged(false);
    }

    private void doCancel() {
        this.setChanged(false);
        this.edit(this.parent, this.node);
    }

    public void edit(MyJTree myJTree, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode != null) {
            this.testSaveChanges();
            this.parent = myJTree;
            this.node = defaultMutableTreeNode;
            this.data = (MacroTreeNodeData)this.node.getUserObject();
            this.macroTextArea.setText(this.data.content);
            this.nameField.setText(this.data.name);
            this.titleField.setText(this.data.title.trim());
            this.toolTipField.setText(this.data.toolTip);
            if (this.data.keyboardHook != null) {
                this.keyHookField.setText(this.data.keyboardHook.getDescription());
                this.keyboardHook = (KeyDescription)this.data.keyboardHook.clone();
            } else {
                this.keyHookField.setText("");
                this.keyboardHook = null;
            }
            this.isToolBarCheckBox.setSelected(this.data.isToolBar);
            this.isMenuCheckBox.setSelected(this.data.isMenu);
            this.isHiddenCheckBox.setSelected(this.data.isHidden);
            this.separatorCheckBox.setSelected(this.data.isSeparator);
            this.showTitleCheckBox.setSelected(this.data.showTitleAndIcon);
            this.updateMacroList(myJTree.getMacroList());
            this.icon = this.data.icon;
            this.setupIcon(this.icon);
            this.setChanged(true);
            this.setChanged(false);
        }
    }

    private Container getContentPane() {
        return this;
    }

    private void pack() {
    }

    private void dispose() {
    }

    private void dockUndock() {
        this.main.configValues.showMacroEditorInFrame = !this.main.configValues.showMacroEditorInFrame;
        this.main.showMacroEditPanel(true, true);
    }

    private void initComponents() {
        this.popupMenu = new MyJPopupMenu();
        this.lineWrapMenuItem = new JMenuItem();
        this.dockUndockMenuItem = new JMenuItem();
        this.topPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.titleField = new JTextField();
        this.jLabel2 = new JLabel();
        this.toolTipField = new JTextField();
        this.jLabel5 = new JLabel();
        this.keyHookField = new JTextField();
        this.keyTestButton = new JToggleButton();
        this.clearKeyDef = new JButton();
        this.jLabel6 = new JLabel();
        this.nameField = new JTextField();
        this.jLabel3 = new JLabel();
        this.bottomPanel = new JPanel();
        this.controlPanel = new JPanel();
        this.isToolBarCheckBox = new JCheckBox();
        this.isHiddenCheckBox = new JCheckBox();
        this.showTitleCheckBox = new JCheckBox();
        this.okButton = new MyJButton();
        this.separatorCheckBox = new JCheckBox();
        this.cancelButton = new MyJButton();
        this.chooseIconButton = new MyJButton();
        this.isMenuCheckBox = new JCheckBox();
        this.closeButton = new MyJButton();
        this.topControlPanel = new JPanel();
        this.systemComBox = new JComboBox(this.comList);
        this.macroComboBox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.middlePanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.macroTextArea = new MyJTextArea(this.main);
        this.lineWrapMenuItem.setText("Toggle line wrap");
        this.lineWrapMenuItem.setToolTipText("Set/clear editor display line wrap");
        this.lineWrapMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroEditor.this.lineWrapMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.lineWrapMenuItem);
        this.dockUndockMenuItem.setText("Dock/Undock");
        this.dockUndockMenuItem.setToolTipText("Dock or undock the macro editor panel");
        this.dockUndockMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroEditor.this.dockUndockMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.dockUndockMenuItem);
        this.setLayout(new BorderLayout());
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent componentEvent) {
                MacroEditor.this.formComponentHidden(componentEvent);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                MacroEditor.this.formKeyTyped(keyEvent);
            }

            public void keyPressed(KeyEvent keyEvent) {
                MacroEditor.this.formKeyPressed(keyEvent);
            }
        });
        this.topPanel.setLayout(new GridBagLayout());
        this.jLabel1.setText("Title");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 4, 1, 1);
        this.topPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.titleField.setToolTipText("The title appears on the tree display");
        this.titleField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                MacroEditor.this.titleFieldKeyPressed(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.topPanel.add((Component)this.titleField, gridBagConstraints);
        this.jLabel2.setText("ToolTip");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 4, 1, 1);
        this.topPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.toolTipField.setToolTipText("The \"tool tip\" is one of these floating messages");
        this.toolTipField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                MacroEditor.this.toolTipFieldKeyPressed(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.topPanel.add((Component)this.toolTipField, gridBagConstraints);
        this.jLabel5.setText("Shortcut Key");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(1, 4, 1, 1);
        this.topPanel.add((Component)this.jLabel5, gridBagConstraints);
        this.keyHookField.setToolTipText("The key used  to get this macro (optional)");
        this.keyHookField.setRequestFocusEnabled(false);
        this.keyHookField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                MacroEditor.this.keyHookFieldKeyTyped(keyEvent);
            }

            public void keyPressed(KeyEvent keyEvent) {
                MacroEditor.this.keyHookFieldKeyPressed(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                MacroEditor.this.keyHookFieldKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.topPanel.add((Component)this.keyHookField, gridBagConstraints);
        this.keyTestButton.setText("Define");
        this.keyTestButton.setToolTipText("Press this button, then press the desired key or combination");
        this.keyTestButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroEditor.this.keyTestButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.topPanel.add((Component)this.keyTestButton, gridBagConstraints);
        this.clearKeyDef.setText("Clear");
        this.clearKeyDef.setToolTipText("Erase the current key definition");
        this.clearKeyDef.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroEditor.this.clearKeyDefActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.topPanel.add((Component)this.clearKeyDef, gridBagConstraints);
        this.jLabel6.setText("Macro Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 4, 1, 1);
        this.topPanel.add((Component)this.jLabel6, gridBagConstraints);
        this.nameField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.topPanel.add((Component)this.nameField, gridBagConstraints);
        this.jLabel3.setText("Macro Editing Area:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 1);
        this.topPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.add((Component)this.topPanel, "North");
        this.bottomPanel.setLayout(new BorderLayout());
        this.controlPanel.setLayout(new GridBagLayout());
        this.isToolBarCheckBox.setText("ToolBar");
        this.isToolBarCheckBox.setToolTipText("Select if you want this item's children to appear as a toolbar");
        this.isToolBarCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroEditor.this.isToolBarCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.controlPanel.add((Component)this.isToolBarCheckBox, gridBagConstraints);
        this.isHiddenCheckBox.setText("Hidden");
        this.isHiddenCheckBox.setToolTipText("Select to hide this item (used for toolbars, buttons and menus)");
        this.isHiddenCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroEditor.this.isHiddenCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 4, 1, 1);
        this.controlPanel.add((Component)this.isHiddenCheckBox, gridBagConstraints);
        this.showTitleCheckBox.setText("Title and Icon");
        this.showTitleCheckBox.setToolTipText("Display both a title and icon");
        this.showTitleCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroEditor.this.showTitleCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.controlPanel.add((Component)this.showTitleCheckBox, gridBagConstraints);
        this.okButton.setText("Accept");
        this.okButton.setToolTipText("Accept editing changes");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroEditor.this.okButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.controlPanel.add((Component)this.okButton, gridBagConstraints);
        this.separatorCheckBox.setText("Separator");
        this.separatorCheckBox.setToolTipText("Used for toolbars and menus");
        this.separatorCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroEditor.this.separatorCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.controlPanel.add((Component)this.separatorCheckBox, gridBagConstraints);
        this.cancelButton.setText("Discard");
        this.cancelButton.setToolTipText("Discard your changes");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroEditor.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.controlPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.chooseIconButton.setText("Choose Icon");
        this.chooseIconButton.setToolTipText("Choose an icon");
        this.chooseIconButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroEditor.this.chooseIconButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.controlPanel.add((Component)this.chooseIconButton, gridBagConstraints);
        this.isMenuCheckBox.setText("Menu");
        this.isMenuCheckBox.setToolTipText("Make this item a menu");
        this.isMenuCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroEditor.this.isMenuCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 4, 1, 1);
        this.controlPanel.add((Component)this.isMenuCheckBox, gridBagConstraints);
        this.closeButton.setText("Close");
        this.closeButton.setToolTipText("Close this window");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroEditor.this.closeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.controlPanel.add((Component)this.closeButton, gridBagConstraints);
        this.bottomPanel.add((Component)this.controlPanel, "Center");
        this.topControlPanel.setLayout(new GridBagLayout());
        this.systemComBox.setToolTipText("System commands");
        this.systemComBox.setAutoscrolls(true);
        this.systemComBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroEditor.this.systemComBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.topControlPanel.add((Component)this.systemComBox, gridBagConstraints);
        this.macroComboBox.setToolTipText("Menu, toolbar, user macros");
        this.macroComboBox.setAutoscrolls(true);
        this.macroComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroEditor.this.macroComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.topControlPanel.add((Component)this.macroComboBox, gridBagConstraints);
        this.jLabel4.setText("Insert system command or user macro:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 1);
        this.topControlPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.bottomPanel.add((Component)this.topControlPanel, "North");
        this.add((Component)this.bottomPanel, "South");
        this.middlePanel.setLayout(new BorderLayout());
        this.macroTextArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                MacroEditor.this.macroTextAreaKeyPressed(keyEvent);
            }
        });
        this.macroTextArea.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                MacroEditor.this.macroTextAreaMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                MacroEditor.this.macroTextAreaMouseReleased(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.macroTextArea);
        this.middlePanel.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.middlePanel, "Center");
    }

    private void dockUndockMenuItemActionPerformed(ActionEvent actionEvent) {
        this.dockUndock();
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.main.getMacroPanel().setEditMode(false, true);
    }

    private void macroComboBoxActionPerformed(ActionEvent actionEvent) {
        if (!this.suppressChanges) {
            this.insertMacro(actionEvent.getSource());
        }
    }

    private void formComponentHidden(ComponentEvent componentEvent) {
        this.testSaveChanges();
    }

    private void isMenuCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.setChanged();
    }

    private void clearKeyDefActionPerformed(ActionEvent actionEvent) {
        this.clearKeyDef();
        this.setChanged();
    }

    private void keyHookFieldKeyReleased(KeyEvent keyEvent) {
        this.handleKey(keyEvent);
    }

    private void keyHookFieldKeyTyped(KeyEvent keyEvent) {
        this.handleKey(keyEvent);
    }

    private void formKeyTyped(KeyEvent keyEvent) {
        this.handleKey(keyEvent);
    }

    private void formKeyPressed(KeyEvent keyEvent) {
        this.handleKey(keyEvent);
    }

    private void macroTextAreaMouseReleased(MouseEvent mouseEvent) {
        this.handleMouse(mouseEvent);
    }

    private void macroTextAreaMousePressed(MouseEvent mouseEvent) {
        this.handleMouse(mouseEvent);
    }

    private void lineWrapMenuItemActionPerformed(ActionEvent actionEvent) {
        this.toggleLineWrap();
    }

    private void titleFieldKeyPressed(KeyEvent keyEvent) {
        this.setChanged();
    }

    private void toolTipFieldKeyPressed(KeyEvent keyEvent) {
        this.setChanged();
    }

    private void keyHookFieldKeyPressed(KeyEvent keyEvent) {
        this.handleKey(keyEvent);
        this.setChanged();
    }

    private void macroTextAreaKeyPressed(KeyEvent keyEvent) {
        this.setChanged();
    }

    private void isHiddenCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.setChanged();
    }

    private void showTitleCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.setChanged();
    }

    private void separatorCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.execSeparator(actionEvent);
    }

    private void isToolBarCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.setChanged();
    }

    private void chooseIconButtonActionPerformed(ActionEvent actionEvent) {
        this.setChanged();
        this.chooseIcon();
    }

    private void keyTestButtonActionPerformed(ActionEvent actionEvent) {
        this.setChanged();
        this.keyTrap = true;
        this.keyHookField.grabFocus();
    }

    private void systemComBoxActionPerformed(ActionEvent actionEvent) {
        this.insertMacro(actionEvent.getSource());
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.doCancel();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.acceptClose();
    }

    private void execSeparator(ActionEvent actionEvent) {
        if (this.separatorCheckBox.getSelectedObjects() != null) {
            this.titleField.setText("* Separator *");
        }
        this.setChanged();
    }

    private void clearKeyDef() {
        this.keyHookField.setText("");
    }

    private void handleKey(KeyEvent keyEvent) {
        if (this.keyTrap) {
            if (keyEvent.getID() == 401) {
                String string = this.main.macroKeyHandler.createCode(keyEvent);
                if (string != null && string.length() > 0) {
                    this.keyAccepted = true;
                    this.keyTestButton.setSelected(false);
                    this.processDefineKey(keyEvent);
                    String string2 = "" + KeyEvent.getKeyModifiersText(keyEvent.getModifiers()) + " " + KeyEvent.getKeyText(keyEvent.getKeyCode());
                }
            } else if (keyEvent.getID() == 402 && this.keyAccepted) {
                this.keyTrap = false;
                this.macroTextArea.requestFocus();
            }
            keyEvent.consume();
        } else if (this.main.macroKeyHandler.execute(keyEvent)) {
            return;
        }
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean bl) {
        if (bl != this.oldChanged) {
            this.okButton.setEnabled(bl);
            this.cancelButton.setEnabled(bl);
        }
        this.changed = bl;
        this.oldChanged = bl;
    }

    private void handleMouse(MouseEvent mouseEvent) {
        if (this.popupMenu.isPopupTrigger(mouseEvent)) {
            ((MyJPopupMenu)this.popupMenu).show(this.macroTextArea, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void toggleLineWrap() {
        this.macroTextArea.setLineWrap(!this.macroTextArea.getLineWrap());
        this.macroTextArea.setWrapStyleWord(true);
    }

    private void chooseIcon() {
        IconSelector iconSelector = new IconSelector(this.icon, this.main, true);
        this.setupIcon(iconSelector.choice);
    }

    private void setupIcon(String string) {
        if (string != null) {
            this.icon = string;
            if (this.icon.length() == 0) {
                this.chooseIconButton.setIcon(null);
            } else {
                this.chooseIconButton.setIcon(ArachComp.loadIcon("/" + this.icon));
            }
            this.repaint();
        }
    }

    private void processDefineKey(KeyEvent keyEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        this.keyboardHook = new KeyDescription(keyEvent);
        String string = this.keyboardHook.getDescription();
        String string2 = this.keyboardHook.toString();
        this.keyHookField.setText(string);
        String string3 = this.main.macroKeyHandler.checkDefinition(string2);
        if (string3 != null && (defaultMutableTreeNode = this.main.macroKeyHandler.getNodeForString(string2)) != this.node) {
            int n = JOptionPane.showConfirmDialog(this, "The key code you have chosen is already mapped\nby \"" + string3 + "\".\nOkay to overwrite that mapping?", "Key code already in use", 0);
            if (n == 0) {
                this.main.macroKeyHandler.removeKeyMacro(string2);
            } else {
                this.keyHookField.setText("");
            }
        }
    }

    private void insertMacro(Object object) {
        this.setChanged();
        String string = (String)((JComboBox)object).getSelectedItem();
        this.macroTextArea.replaceSelection(string);
    }

    private void acceptClose() {
        this.acceptData();
        this.closeIt();
    }

    private void acceptData() {
        if (this.node != null) {
            this.data.title = this.titleField.getText().trim();
            this.data.toolTip = this.toolTipField.getText();
            if (this.keyboardHook != null) {
                this.data.keyboardHook = this.keyboardHook;
            }
            this.data.icon = this.icon;
            this.data.refreshIcon();
            this.data.content = this.macroTextArea.getText();
            this.data.isToolBar = this.isToolBarCheckBox.getSelectedObjects() != null;
            this.data.isMenu = this.isMenuCheckBox.getSelectedObjects() != null;
            this.data.isHidden = this.isHiddenCheckBox.getSelectedObjects() != null;
            this.data.isSeparator = this.separatorCheckBox.getSelectedObjects() != null;
            this.data.showTitleAndIcon = this.showTitleCheckBox.getSelectedObjects() != null;
            this.node.setUserObject(this.data);
            this.data.name = ArachComp.getStringForNode(this.node);
            this.nameField.setText(this.data.name);
            if (this.parent instanceof MyJTree) {
                this.parent.isChanged = true;
            }
            this.setChanged(false);
            this.parent.acceptEdit(this.node);
            this.updateMacroList(this.parent.getMacroList());
        }
    }

    private void closeIt() {
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(object.toString());
            this.setToolTipText("????");
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }
}

