/*
 * Decompiled with CFR 0.152.
 */
package HTMLValidator;

import Arachnophilia.Arachnophilia;
import Arachnophilia.MyJTextArea;
import HTMLValidator.HTMLValidator;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class HTMLValidatorDialog
extends JFrame {
    Arachnophilia main;
    HTMLValidator htmlv;
    private JButton closeButton;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea textResults;

    public HTMLValidatorDialog(Arachnophilia arachnophilia, HTMLValidator hTMLValidator) {
        this.main = arachnophilia;
        this.htmlv = hTMLValidator;
        this.initComponents();
        this.setIconImage(this.main.getIconImage());
        this.setTitle("Arachnophilia 5.4 HTML Validator Interactive Dialog");
        Rectangle rectangle = this.main.getBounds();
        int n = rectangle.width / 2;
        int n2 = rectangle.height / 2;
        this.setBounds(rectangle.x + rectangle.width - n, rectangle.y, n, n2);
        this.setVisible(true);
        this.textResults.requestFocus();
    }

    public void setText(String string) {
        this.textResults.setText(string);
        this.textResults.setSelectionStart(0);
        this.textResults.setSelectionEnd(0);
    }

    public void processMouseClick(MouseEvent mouseEvent) {
        this.processMouseAction(mouseEvent, true);
    }

    public void processMouseMove(MouseEvent mouseEvent) {
        this.processMouseAction(mouseEvent, false);
    }

    public void processMouseAction(MouseEvent mouseEvent, boolean bl) {
        try {
            int n = this.textResults.viewToModel(mouseEvent.getPoint());
            int n2 = this.textResults.getLineOfOffset(n);
            int n3 = this.textResults.getLineStartOffset(n2);
            int n4 = this.textResults.getLineEndOffset(n2);
            String string = this.textResults.getText(n3, n4 - n3);
            if (string != null && this.htmlv.isValidLine(string)) {
                this.textResults.setSelectionStart(n3);
                this.textResults.setSelectionEnd(n4);
                if (bl) {
                    this.htmlv.gotoLine(string);
                }
            } else {
                this.textResults.setSelectionStart(n3);
                this.textResults.setSelectionEnd(n3);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public void quit() {
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.textResults = new MyJTextArea(this.main);
        this.jPanel1 = new JPanel();
        this.closeButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HTMLValidatorDialog.this.exitForm(windowEvent);
            }
        });
        this.textResults.setEditable(false);
        this.textResults.setFont(new Font("Monospaced", 0, 12));
        this.textResults.setMargin(new Insets(4, 4, 4, 4));
        this.textResults.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                HTMLValidatorDialog.this.textResultsMouseClicked(mouseEvent);
            }
        });
        this.textResults.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                HTMLValidatorDialog.this.textResultsMouseMoved(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.textResults);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLValidatorDialog.this.closeButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void textResultsMouseMoved(MouseEvent mouseEvent) {
        this.processMouseMove(mouseEvent);
    }

    private void textResultsMouseClicked(MouseEvent mouseEvent) {
        this.processMouseClick(mouseEvent);
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.quit();
    }

    private void exitForm(WindowEvent windowEvent) {
    }
}

