/*
 * Decompiled with CFR 0.152.
 */
package BaseCalc;

import BaseCalc.BaseCalcPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BasePanel
extends JPanel {
    int radix;
    BaseCalcPanel parent;
    String oldText = "";
    private JLabel label;
    private JTextField entry_display;

    public BasePanel(int n, String string, BaseCalcPanel baseCalcPanel) {
        this.radix = n;
        this.parent = baseCalcPanel;
        this.initComponents();
        Font font = new Font("Monospaced", 0, 12);
        this.entry_display.setFont(font);
        this.setFont(font);
        FontMetrics fontMetrics = this.entry_display.getFontMetrics(font);
        int n2 = fontMetrics.stringWidth("0") + 1;
        int n3 = fontMetrics.getHeight();
        Dimension dimension = new Dimension(n2 * 64, n3);
        this.entry_display.setSize(dimension);
        this.entry_display.setMinimumSize(dimension);
        this.entry_display.setPreferredSize(dimension);
        this.label.setText(string);
        this.entry_display.setText("");
    }

    private void handleKeyEvent(KeyEvent keyEvent) {
        String string = this.entry_display.getText();
        if (string.length() == 0) {
            this.oldText = "";
            this.parent.eraseAll();
        } else {
            try {
                long l = Long.valueOf(string, this.radix);
                this.parent.updateAll(l);
                this.oldText = this.entry_display.getText();
            }
            catch (NumberFormatException numberFormatException) {
                this.entry_display.setText(this.oldText);
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public void update(long l) {
        this.entry_display.setText(Long.toString(l, this.radix));
    }

    public void eraseDisp() {
        this.entry_display.setText("");
    }

    private void initComponents() {
        this.label = new JLabel();
        this.entry_display = new JTextField();
        this.setLayout(new GridBagLayout());
        this.label.setText("jLabel1");
        this.label.setPreferredSize(new Dimension(120, 17));
        this.label.setMinimumSize(new Dimension(120, 17));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.add((Component)this.label, gridBagConstraints);
        this.entry_display.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                BasePanel.this.entry_displayKeyTyped(keyEvent);
            }

            public void keyPressed(KeyEvent keyEvent) {
                BasePanel.this.entry_displayKeyPressed(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                BasePanel.this.entry_displayKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.entry_display, gridBagConstraints);
    }

    private void entry_displayKeyReleased(KeyEvent keyEvent) {
        this.handleKeyEvent(keyEvent);
    }

    private void entry_displayKeyTyped(KeyEvent keyEvent) {
    }

    private void entry_displayKeyPressed(KeyEvent keyEvent) {
    }
}

