/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import Arachnophilia.ArachComp;
import Arachnophilia.ArachDocument;
import Arachnophilia.Arachnophilia;
import java.awt.Component;
import java.io.File;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;

public final class FileListHandler {
    Hashtable fileList;
    JTabbedPane pane;
    Arachnophilia main;

    public FileListHandler(JTabbedPane jTabbedPane, Arachnophilia arachnophilia) {
        this.pane = jTabbedPane;
        this.main = arachnophilia;
        this.fileList = new Hashtable();
    }

    public ArachDocument[] docArray() {
        return this.fileList.values().toArray(new ArachDocument[0]);
    }

    public int openCount() {
        return this.fileList.size();
    }

    public void newDoc(String string, Arachnophilia arachnophilia, int n, boolean bl, boolean bl2) {
        ArachDocument arachDocument = new ArachDocument(string, arachnophilia, n, bl, false);
        if (this.pane.indexOfTab(arachDocument.name) != -1) {
            ArachDocument arachDocument2 = (ArachDocument)this.pane.getComponentAt(this.pane.indexOfTab(arachDocument.name));
            if (arachDocument2.file == null) {
                JOptionPane.showMessageDialog(this.main, "You may not have more than one unsaved document of a given type at a time.\nPlease save the unsaved document named \"" + arachDocument.name + "\" and try again.", "Unsaved document \"" + arachDocument.name + "\" already exists", 2);
                return;
            }
        }
        this.pane.addTab(arachDocument.name, null, arachDocument, arachDocument.fullPath);
        this.pane.setSelectedComponent(arachDocument);
        this.main.currentSelectedDocument = arachDocument;
        this.fileList.put(arachDocument.fullPath, arachDocument);
    }

    public ArachDocument findExisting(File file) {
        int n;
        ArachDocument arachDocument = null;
        if (this.fileList.containsKey(file.getPath()) && (arachDocument = (ArachDocument)this.fileList.get(file.getPath())) != null && (n = this.pane.indexOfComponent(arachDocument)) == -1) {
            arachDocument = null;
            this.fileList.remove(file.getPath());
        }
        return arachDocument;
    }

    public void removeDoc(ArachDocument arachDocument) {
        int n = this.pane.indexOfComponent(arachDocument);
        if (n != -1) {
            this.pane.remove(n);
        }
        this.fileList.remove(arachDocument.fullPath);
    }

    public void swapDocuments(File file, File file2, ArachDocument arachDocument) {
        if (file == null || file2 == null || file.equals(file2)) {
            return;
        }
        ArachDocument arachDocument2 = (ArachDocument)this.fileList.remove(file.getPath());
        this.fileList.put(file2.getPath(), arachDocument);
        this.removeDups(arachDocument);
    }

    public void updateDocTitle(ArachDocument arachDocument) {
        int n = this.pane.indexOfComponent(arachDocument);
        if (n != -1) {
            this.pane.setTitleAt(n, arachDocument.name + (arachDocument.docChanged ? " *" : ""));
            this.pane.setToolTipTextAt(n, arachDocument.fullPath);
        }
    }

    private void removeDups(ArachDocument arachDocument) {
        int n;
        for (int i = n = this.main.macroEditShowing ? 1 : 0; i < this.pane.getTabCount(); ++i) {
            ArachDocument arachDocument2 = (ArachDocument)this.pane.getComponentAt(i);
            if (arachDocument2 == arachDocument || !arachDocument2.equals(arachDocument)) continue;
            this.pane.remove(arachDocument2);
            break;
        }
    }

    public void changeFontSizes() {
        int n;
        for (int i = n = this.main.macroEditShowing ? 1 : 0; i < this.pane.getTabCount(); ++i) {
            ArachDocument arachDocument = (ArachDocument)this.pane.getComponentAt(i);
            arachDocument.setNewFont();
        }
    }

    public void setFocusToActive() {
        Component component = this.pane.getSelectedComponent();
        this.setFocusTo(component);
    }

    public void refreshCurrentDisplayedDocument() {
        Component component = this.pane.getSelectedComponent();
        component.repaint();
    }

    public void moveToNextDocument() {
        int n = this.pane.getSelectedIndex();
        if (n != -1) {
            n = (n + 1) % this.pane.getComponentCount();
            this.pane.setSelectedIndex(n);
        }
        this.setFocusToActive();
    }

    public void moveToPriorDocument() {
        int n = this.pane.getSelectedIndex();
        if (n != -1) {
            n += this.pane.getComponentCount();
            n = (n - 1) % this.pane.getComponentCount();
            this.pane.setSelectedIndex(n);
        }
        this.setFocusToActive();
    }

    public void setFocusTo(Component component) {
        if (component != null && this.pane.indexOfComponent(component) != -1) {
            this.pane.setSelectedComponent(component);
            component.requestFocus();
        }
    }

    public String genNewFileName(ArachDocument arachDocument) {
        String string = this.main.configValues.fileTypePaths[arachDocument.fileType];
        int n = 0;
        if (!arachDocument.isFile) {
            String string2;
            File file;
            while ((file = new File(string, string2 = "Untitled" + ++n + "." + this.main.fileTypes.fileTemplateSuffs[arachDocument.fileType])).exists()) {
            }
            return file.getName();
        }
        return arachDocument.name;
    }

    public void setFileNameStrings(String string, ArachDocument arachDocument, boolean bl) {
        arachDocument.isFile = bl;
        if (bl) {
            arachDocument.file = new File(string);
            arachDocument.fullPath = arachDocument.file.getPath();
            arachDocument.path = ArachComp.pathFromFullPath(arachDocument.fullPath);
            arachDocument.name = ArachComp.nameFromFullPath(arachDocument.fullPath);
        } else {
            arachDocument.fullPath = arachDocument.name = "New " + this.main.fileTypes.fileTypeNames[arachDocument.fileType] + " Document";
        }
        this.updateDocTitle(arachDocument);
    }
}

