/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import Arachnophilia.ArachComp;
import Arachnophilia.ArachDocument;
import Arachnophilia.Arachnophilia;
import Arachnophilia.SearchReplace;
import JArachTextArea.JArachTextArea;
import JArachTextArea.SyntaxDocument;
import JArachTextArea.SyntaxStyle;
import JArachTextArea.Token;
import JArachTextArea.TokenMarker;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.text.Segment;

public final class DocToHTMLConverter {
    Arachnophilia main;
    SearchReplace srch;
    boolean textBold;
    boolean textItalic;
    Color textColor;
    Font defaultFont;
    Color defaultColor;
    boolean boldTag = false;
    boolean italicTag = false;
    boolean colorTag = false;

    public DocToHTMLConverter(Arachnophilia arachnophilia) {
        this.main = arachnophilia;
        this.srch = new SearchReplace();
    }

    private String padNum(String string, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = ("" + n).length();
        for (int i = n2 = new StringBuilder().append("").append(string).toString().length(); i <= n3; ++i) {
            stringBuffer.append("&nbsp;");
        }
        stringBuffer.append("" + string);
        return stringBuffer.toString();
    }

    public String convertDoc(ArachDocument arachDocument) {
        StringBuffer stringBuffer = new StringBuffer();
        if (arachDocument != null && arachDocument.textComp instanceof JArachTextArea) {
            String string = "<style type=\"text/css\">\n.lc {font-weight:normal;font-style:normal;color:#" + ArachComp.colorIntToString(this.main.configValues.lineNumberColumnForeground) + ";background-color:#" + ArachComp.colorIntToString(this.main.configValues.lineNumberColumnBackground) + "}\n</style>\n";
            String string2 = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n";
            stringBuffer.append(string2);
            stringBuffer.append("<html>\n<head>\n<title>");
            stringBuffer.append("Listing: " + arachDocument.fullPath);
            stringBuffer.append("</title>\n");
            stringBuffer.append(string);
            stringBuffer.append("</head>\n<body bgcolor=\"#ffffff\">\n<pre>\n<code>\n");
            JArachTextArea jArachTextArea = (JArachTextArea)arachDocument.textComp;
            Graphics graphics = jArachTextArea.getGraphics();
            this.textBold = graphics.getFont().isBold();
            this.textItalic = graphics.getFont().isItalic();
            this.textColor = graphics.getColor();
            this.defaultFont = graphics.getFont();
            this.defaultColor = graphics.getColor();
            TokenMarker tokenMarker = ((SyntaxDocument)jArachTextArea.getDocument()).getTokenMarker();
            SyntaxStyle[] syntaxStyleArray = jArachTextArea.painter.getStyles();
            Segment segment = new Segment();
            int n = arachDocument.textComp.getLineCount();
            for (int i = 0; i < n; ++i) {
                jArachTextArea.getLineText(i, segment);
                Token token = tokenMarker.markTokens(segment, i);
                if (this.main.configValues.lineNumberColumn) {
                    String string3 = "" + (i + 1);
                    string3 = this.padNum(string3, n);
                    String string4 = "<span class=\"lc\">" + string3 + "&nbsp;" + "</span>";
                    stringBuffer.append(string4);
                }
                stringBuffer.append(this.formatSyntaxLine(segment, token, syntaxStyleArray, graphics));
            }
            this.textBold = this.defaultFont.isBold();
            this.textItalic = this.defaultFont.isItalic();
            this.textColor = this.defaultColor;
            stringBuffer.append(this.readChange(graphics, this.textBold, this.textItalic, this.textColor));
            if (this.colorTag) {
                stringBuffer.append("</font>\n");
            }
            stringBuffer.append("</code>\n</pre>\n</body>\n</html>\n");
            graphics.dispose();
        }
        return stringBuffer.toString();
    }

    public String formatSyntaxLine(Segment segment, Token token, SyntaxStyle[] syntaxStyleArray, Graphics graphics) {
        byte by;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while ((by = token.id) != 127) {
            int n2 = token.length;
            if (by == 0) {
                if (!this.defaultColor.equals(graphics.getColor())) {
                    graphics.setColor(this.defaultColor);
                }
                if (!this.defaultFont.equals(graphics.getFont())) {
                    graphics.setFont(this.defaultFont);
                }
            } else {
                syntaxStyleArray[by].setGraphicsFlags(graphics, this.defaultFont);
            }
            segment.count = n2;
            stringBuffer.append(this.readChange(graphics, this.textBold, this.textItalic, this.textColor));
            String string = new String(segment.array, segment.offset, segment.count);
            string = this.srch.srchRplc(string, "&", "&amp;", true);
            string = this.srch.srchRplc(string, "<", "&lt;", true);
            string = this.srch.srchRplc(string, ">", "&gt;", true);
            stringBuffer.append(string);
            this.textBold = graphics.getFont().isBold();
            this.textItalic = graphics.getFont().isItalic();
            this.textColor = graphics.getColor();
            segment.offset += n2;
            n += n2;
            token = token.next;
        }
        return stringBuffer.toString() + "\n";
    }

    private String readChange(Graphics graphics, boolean bl, boolean bl2, Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        Font font = graphics.getFont();
        Color color2 = graphics.getColor();
        if (color2 != color) {
            if (color != this.defaultColor) {
                stringBuffer.append("</font>");
                this.colorTag = false;
            }
            if (color2 != this.defaultColor && this.colorTag) {
                stringBuffer.append("</font>");
            }
        }
        if (bl && !font.isBold() && this.boldTag) {
            stringBuffer.append("</b>");
            this.boldTag = false;
        }
        if (bl2 && !font.isItalic() && this.italicTag) {
            stringBuffer.append("</i>");
            this.italicTag = false;
        }
        if (font.isItalic() && !bl2) {
            stringBuffer.append("<i>");
            this.italicTag = true;
        }
        if (font.isBold() && !bl) {
            stringBuffer.append("<b>");
            this.boldTag = true;
        }
        if (color2 != color) {
            int n = color2.getRGB();
            String string = ArachComp.colorIntToString(n);
            stringBuffer.append("<font color=\"#" + string + "\">");
            this.colorTag = true;
        }
        return stringBuffer.toString();
    }
}

