/*
 *		Created on Mar 8, 2002 9:18:55 PM
 */

/* TestClass is meant to demonstrate the use
 * of Arachnophilia's custom class launcher feature.
 * Just compile this class in place, create
 * a macro that looks like this:
 * "[RunCustomClassDoc:CustomClasses/TestClass]",
 * load a suitable document, and activate the macro.
 */

import java.util.*;

public class TestClass {
   
   // this is a generic, minimal global search & replace method
   
   private String searchReplace(String data,String find,String replace)
   {
      StringBuffer sb = new StringBuffer();
      int a = 0,b;
      int findLength = find.length();
      while((b = data.indexOf(find,a)) != -1) {
         sb.append(data.substring(a,b));
         sb.append(replace);
         a = b + findLength;
      }
      if(a < data.length()) {
         sb.append(data.substring(a));
      }
      return sb.toString();
   }
   
   // this is the default method that custom classes
   // must have to work with Arachnophilia's class
   // launcher feature unless a specific method name
   // is provided
   
   public String processString(String s)
   {
      String result = "Hello! This is an example of Java Custom Class Interfacing!\n\n"
      + "You sent over this:\n"
      + "\"" + s + "\"\n"
      + "Here it is all uppercase:\n"
      + "\"" + s.toUpperCase() + "\"\n"
      + "Here it is all lowercase:\n"
      + "\"" + s.toLowerCase() + "\"\n"
      + "Here it is with a global change:\n"
      + "\"" + searchReplace(s,"a","(A)") + "\"\n";
      return result;
   }
   
   // this is another method to show the ability to choose
   // any method by name
   
   public String reallyBoringMethod(String s)
   {
      return "On " + new Date() + ", you invoked this really boring Java method.";
   }
}
