// navigator.mozApps trivial implementation (avoids bug 1094714)
// Use a different CID so we can mask it.

Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");

function TrivialMozAppsRegistry() {
}
TrivialMozAppsRegistry.prototype = {
  classID : Components.ID("{fff440b3-fae2-45c1-bf03-3b5a2e432271}"),
  QueryInterface : XPCOMUtils.generateQI(
    [Components.interfaces.nsISupportsWeakReference,
     Components.interfaces.nsISupports,
     Components.interfaces.nsIObserver,
     Components.interfaces.nsIDOMGlobalPropertyInitializer]),
  classInfo : XPCOMUtils.generateCI({
    classID : Components.ID("{fff440b3-fae2-45c1-bf03-3b5a2e432271}"),
    contractID : "@mozilla.org/webapps;1",
    classDescription : "Phony mozApps",
    interfaces : [Components.interfaces.nsISupportsWeakReference,
                  Components.interfaces.nsISupports,
                  Components.interfaces.nsIObserver,
                  Components.interfaces.nsIDOMGlobalPropertyInitializer],
    flags : Components.interfaces.nsIClassInfo.SINGLETON
  }),
  
  // mozIDOMApplicationRegistry
  install : function(aURL, aParams) { },
  installPackage : function(aURL, aParams) { },
  getSelf : function() { },
  getInstalled: function() { },
  checkInstalled : function(aManifestURL) { },
  get mgmt() { return null },
  
  // Language pack API (not currently supported)
  getAdditionalLanguages : function() { },
  getLocalizationResource : function(aLanguage, aVersion, aPath, aType) { },
  
  // nsIDOMGlobalPropertyInitializer
  init : function(aWindow) { }
};

// XPCOM HO!
var components = [ TrivialMozAppsRegistry ];
this.NSGetFactory = XPCOMUtils.generateNSGetFactory(components);