/*
 * Decompiled with CFR 0.152.
 */
package com.sun.t2k;

import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.PrismFontLoader;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.t2k.CharToGlyphMapper;
import com.sun.t2k.CompositeFontResource;
import com.sun.t2k.T2KFontStrikeDesc;
import com.sun.t2k.T2KMetrics;
import com.sun.t2k.T2KStrikeDisposer;

public class CompositeStrike
implements FontStrike {
    private CompositeFontResource fontResource;
    private float size;
    private int aaMode;
    BaseTransform transform;
    private FontStrike slot0Strike;
    private FontStrike[] strikeSlots;
    private T2KFontStrikeDesc desc;
    T2KStrikeDisposer disposer;
    private T2KMetrics metrics;

    @Override
    public void clearDesc() {
        this.fontResource.getStrikeMap().remove(this.desc);
        if (this.slot0Strike != null) {
            this.slot0Strike.clearDesc();
        }
        if (this.strikeSlots != null) {
            for (int i = 1; i < this.strikeSlots.length; ++i) {
                if (this.strikeSlots[i] == null) continue;
                this.strikeSlots[i].clearDesc();
            }
        }
    }

    CompositeStrike(CompositeFontResource compositeFontResource, float f, BaseTransform baseTransform, T2KFontStrikeDesc t2KFontStrikeDesc) {
        this.fontResource = compositeFontResource;
        this.size = f;
        this.transform = baseTransform.isTranslateOrIdentity() ? BaseTransform.IDENTITY_TRANSFORM : baseTransform.copy();
        this.desc = t2KFontStrikeDesc;
        this.aaMode = t2KFontStrikeDesc.aaMode;
        this.disposer = new T2KStrikeDisposer(compositeFontResource, t2KFontStrikeDesc, 0L);
    }

    @Override
    public int getAAMode() {
        if (PrismFontLoader.isLCDTextSupported()) {
            return this.aaMode;
        }
        return 0;
    }

    @Override
    public BaseTransform getTransform() {
        return this.transform;
    }

    public FontStrike getStrikeSlot(int n) {
        if (n == 0) {
            if (this.slot0Strike == null) {
                FontResource fontResource = this.fontResource.getSlotResource(0);
                this.slot0Strike = fontResource.getStrike(this.size, this.transform, this.getAAMode());
            }
            return this.slot0Strike;
        }
        if (this.strikeSlots == null) {
            this.strikeSlots = new FontStrike[this.fontResource.getNumSlots()];
        }
        if (this.strikeSlots[n] == null) {
            FontResource fontResource = this.fontResource.getSlotResource(n);
            this.strikeSlots[n] = fontResource.getStrike(this.size, this.transform, this.getAAMode());
        }
        return this.strikeSlots[n];
    }

    @Override
    public FontResource getFontResource() {
        return this.fontResource;
    }

    public int getStrikeSlotForGlyph(int n) {
        return n >>> 24;
    }

    @Override
    public float getSize() {
        return this.size;
    }

    @Override
    public boolean drawAsShapes() {
        return this.getStrikeSlot(0).drawAsShapes();
    }

    @Override
    public int getNumGlyphs() {
        return this.getStrikeSlot(0).getNumGlyphs();
    }

    @Override
    public boolean supportsGlyphImages() {
        return this.getStrikeSlot(0).supportsGlyphImages();
    }

    @Override
    public FontStrike.Metrics getMetrics() {
        if (this.metrics == null) {
            T2KMetrics t2KMetrics = (T2KMetrics)this.getStrikeSlot(0).getMetrics();
            if (t2KMetrics.getXHeight() == 0.0f) {
                T2KMetrics t2KMetrics2;
                float f = 0.0f;
                for (int i = 1; i < this.fontResource.getNumSlots() && (f = (t2KMetrics2 = (T2KMetrics)this.getStrikeSlot(i).getMetrics()).getXHeight()) == 0.0f; ++i) {
                }
                this.metrics = new T2KMetrics(t2KMetrics.getAscent(), t2KMetrics.getDescent(), t2KMetrics.getLineGap(), f);
            } else {
                this.metrics = t2KMetrics;
            }
        }
        return this.metrics;
    }

    @Override
    public FontStrike.Glyph getGlyph(char c) {
        CharToGlyphMapper charToGlyphMapper = this.fontResource.getGlyphMapper();
        int n = charToGlyphMapper.charToGlyph(c);
        int n2 = n >>> 24;
        int n3 = n & 0xFFFFFF;
        return this.getStrikeSlot(n2).getGlyph(n3);
    }

    @Override
    public FontStrike.Glyph getGlyph(int n) {
        int n2 = n >>> 24;
        int n3 = n & 0xFFFFFF;
        return this.getStrikeSlot(n2).getGlyph(n3);
    }

    @Override
    public float getCharAdvance(char c) {
        int n = this.fontResource.getGlyphMapper().charToGlyph((int)c);
        return this.fontResource.getAdvance(n, this.size);
    }

    @Override
    public RectBounds getStringVisualBounds(String string) {
        if (string == null || string.length() == 0) {
            return new RectBounds();
        }
        float[] fArray = new float[4];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        CharToGlyphMapper charToGlyphMapper = this.fontResource.getGlyphMapper();
        int n = charToGlyphMapper.charToGlyph((int)string.charAt(0));
        this.fontResource.getGlyphBoundingBox(n, this.size, fArray);
        f = fArray[0];
        f2 = fArray[1];
        f3 = fArray[2];
        f4 = fArray[3];
        int n2 = string.length();
        if (n2 == 1) {
            return new RectBounds(f, f2, f3, f4);
        }
        float f5 = this.fontResource.getAdvance(n, this.size);
        for (int i = 1; i < n2; ++i) {
            n = charToGlyphMapper.charToGlyph((int)string.charAt(i));
            this.fontResource.getGlyphBoundingBox(n, this.size, fArray);
            if (fArray[0] + f5 < f) {
                f = fArray[0] + f5;
            }
            if (fArray[1] < f2) {
                f2 = fArray[1];
            }
            if (fArray[2] + f5 > f3) {
                f3 = fArray[2] + f5;
            }
            if (fArray[3] > f4) {
                f4 = fArray[3];
            }
            if (i >= n2 - 1) continue;
            f5 += this.fontResource.getAdvance(n, this.size);
        }
        return new RectBounds(f, f2, f3, f4);
    }

    @Override
    public float getStringWidth(String string) {
        float f = 0.0f;
        for (int i = 0; i < string.length(); ++i) {
            f += this.getCharAdvance(string.charAt(i));
        }
        return f;
    }

    @Override
    public float getStringHeight(String string) {
        return this.getStrikeSlot(0).getStringHeight(string);
    }

    @Override
    public RectBounds getStringBounds(String string) {
        if (string == null) {
            return new RectBounds();
        }
        FontStrike.Metrics metrics = this.getMetrics();
        float f = 0.0f;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            f += this.getCharAdvance(c);
        }
        RectBounds rectBounds = new RectBounds(0.0f, metrics.getAscent(), f, metrics.getDescent() + metrics.getLineGap());
        return rectBounds;
    }

    @Override
    public Shape getOutline(String string, BaseTransform baseTransform) {
        Path2D path2D = new Path2D();
        this.getOutline(string, baseTransform, path2D);
        return path2D;
    }

    @Override
    public void getOutline(String string, BaseTransform baseTransform, Path2D path2D) {
        path2D.reset();
        if (string == null) {
            return;
        }
        float f = 0.0f;
        float f2 = this.getMetrics().getLineHeight();
        if (baseTransform == null) {
            baseTransform = BaseTransform.IDENTITY_TRANSFORM;
        }
        Affine2D affine2D = new Affine2D();
        float f3 = 0.0f;
        for (int i = 0; i < string.length(); ++i) {
            affine2D.setTransform(baseTransform);
            char c = string.charAt(i);
            if (c == '\n') {
                f3 -= f2;
                f = 0.0f;
                continue;
            }
            FontStrike.Glyph glyph = this.getGlyph(c);
            Shape shape = glyph.getShape();
            affine2D.translate(f, f3);
            path2D.append(shape.getPathIterator(affine2D), false);
            f += glyph.getAdvance();
        }
    }

    @Override
    public float getStrikeThroughOffset() {
        return this.getStrikeSlot(0).getStrikeThroughOffset();
    }

    @Override
    public float getStrikeThroughThickness() {
        return this.getStrikeSlot(0).getStrikeThroughThickness();
    }

    @Override
    public float getUnderLineOffset() {
        return this.getStrikeSlot(0).getUnderLineOffset();
    }

    @Override
    public float getUnderLineThickness() {
        return this.getStrikeSlot(0).getUnderLineThickness();
    }
}

