/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaIcon;
import com.apple.laf.AquaTextFieldBorder;
import com.apple.laf.AquaTextFieldUI;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.JTextComponent;

public class AquaTextFieldSearch {
    private static final String VARIANT_KEY = "JTextField.variant";
    private static final String SEARCH_VARIANT_VALUE = "search";
    private static final String FIND_POPUP_KEY = "JTextField.Search.FindPopup";
    private static final String FIND_ACTION_KEY = "JTextField.Search.FindAction";
    private static final String CANCEL_ACTION_KEY = "JTextField.Search.CancelAction";
    private static final String PROMPT_KEY = "JTextField.Search.Prompt";
    private static final SearchFieldPropertyListener SEARCH_FIELD_PROPERTY_LISTENER = new SearchFieldPropertyListener();
    protected static final AquaUtils.RecyclableSingleton<SearchFieldBorder> instance = new AquaUtils.RecyclableSingletonFromDefaultConstructor<SearchFieldBorder>(SearchFieldBorder.class);

    protected static void installSearchFieldListener(JTextComponent jTextComponent) {
        jTextComponent.addPropertyChangeListener(SEARCH_FIELD_PROPERTY_LISTENER);
    }

    protected static void uninstallSearchFieldListener(JTextComponent jTextComponent) {
        jTextComponent.removePropertyChangeListener(SEARCH_FIELD_PROPERTY_LISTENER);
    }

    protected static boolean wantsToBeASearchField(JTextComponent jTextComponent) {
        return SEARCH_VARIANT_VALUE.equals(jTextComponent.getClientProperty(VARIANT_KEY));
    }

    protected static boolean hasPopupMenu(JTextComponent jTextComponent) {
        return jTextComponent.getClientProperty(FIND_POPUP_KEY) instanceof JPopupMenu;
    }

    public static SearchFieldBorder getSearchTextFieldBorder() {
        return instance.get();
    }

    protected static void installSearchField(JTextComponent jTextComponent) {
        SearchFieldBorder searchFieldBorder = AquaTextFieldSearch.getSearchTextFieldBorder();
        jTextComponent.setBorder(searchFieldBorder);
        jTextComponent.setLayout(searchFieldBorder.getCustomLayout());
        jTextComponent.add((Component)AquaTextFieldSearch.getFindButton(jTextComponent), "West");
        jTextComponent.add((Component)AquaTextFieldSearch.getCancelButton(jTextComponent), "East");
        jTextComponent.add(AquaTextFieldSearch.getPromptLabel(jTextComponent), "Center");
        TextUI textUI = jTextComponent.getUI();
        if (textUI instanceof AquaTextFieldUI) {
            ((AquaTextFieldUI)textUI).setPaintingDelegate(searchFieldBorder);
        }
    }

    protected static void uninstallSearchField(JTextComponent jTextComponent) {
        jTextComponent.setBorder(UIManager.getBorder("TextField.border"));
        jTextComponent.removeAll();
        TextUI textUI = jTextComponent.getUI();
        if (textUI instanceof AquaTextFieldUI) {
            ((AquaTextFieldUI)textUI).setPaintingDelegate(null);
        }
    }

    protected static AquaIcon.DynamicallySizingJRSUIIcon getFindIcon(JTextComponent jTextComponent) {
        return jTextComponent.getClientProperty(FIND_POPUP_KEY) == null ? new AquaIcon.DynamicallySizingJRSUIIcon(new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant(25, 22).alterMargins(0, 4, 0, -5))){

            @Override
            public void initJRSUIState() {
                ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.BUTTON_SEARCH_FIELD_FIND);
            }
        } : new AquaIcon.DynamicallySizingJRSUIIcon(new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant(25, 22).alterMargins(0, 4, 0, 2))){

            @Override
            public void initJRSUIState() {
                ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.BUTTON_SEARCH_FIELD_FIND);
            }
        };
    }

    protected static AquaIcon.DynamicallySizingJRSUIIcon getCancelIcon() {
        return new AquaIcon.DynamicallySizingJRSUIIcon(new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant(22, 22).alterMargins(0, 0, 0, 4))){

            @Override
            public void initJRSUIState() {
                ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.BUTTON_SEARCH_FIELD_CANCEL);
            }
        };
    }

    protected static JRSUIConstants.State getState(JButton jButton) {
        if (!AquaFocusHandler.isActive(jButton)) {
            return JRSUIConstants.State.INACTIVE;
        }
        if (jButton.getModel().isPressed()) {
            return JRSUIConstants.State.PRESSED;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    protected static JButton createButton(final JTextComponent jTextComponent, final AquaIcon.DynamicallySizingJRSUIIcon dynamicallySizingJRSUIIcon) {
        final JButton jButton = new JButton();
        Insets insets = dynamicallySizingJRSUIIcon.sizeVariant.margins;
        jButton.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        jButton.setIcon(dynamicallySizingJRSUIIcon);
        jButton.setBorderPainted(false);
        jButton.setFocusable(false);
        jButton.setCursor(new Cursor(0));
        jButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ((JRSUIState)dynamicallySizingJRSUIIcon.painter.state).set(AquaTextFieldSearch.getState(jButton));
            }
        });
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                jTextComponent.requestFocusInWindow();
            }
        });
        return jButton;
    }

    protected static JButton getFindButton(final JTextComponent jTextComponent) {
        Object object;
        AquaIcon.DynamicallySizingJRSUIIcon dynamicallySizingJRSUIIcon = AquaTextFieldSearch.getFindIcon(jTextComponent);
        final JButton jButton = AquaTextFieldSearch.createButton(jTextComponent, dynamicallySizingJRSUIIcon);
        jButton.setName("find");
        final Object object2 = jTextComponent.getClientProperty(FIND_POPUP_KEY);
        if (object2 instanceof JPopupMenu) {
            ((JRSUIState)dynamicallySizingJRSUIIcon.painter.state).set(JRSUIConstants.Variant.MENU_GLYPH);
            jButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    ((JPopupMenu)object2).show(jButton, 8, jButton.getHeight() - 2);
                    jTextComponent.requestFocusInWindow();
                    jTextComponent.repaint();
                }
            });
        }
        if ((object = jTextComponent.getClientProperty(FIND_ACTION_KEY)) instanceof ActionListener) {
            jButton.addActionListener((ActionListener)object);
        }
        return jButton;
    }

    private static Component getPromptLabel(final JTextComponent jTextComponent) {
        final JLabel jLabel = new JLabel();
        jLabel.setForeground(UIManager.getColor("TextField.inactiveForeground"));
        jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                AquaTextFieldSearch.updatePromptLabel(jLabel, jTextComponent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                AquaTextFieldSearch.updatePromptLabel(jLabel, jTextComponent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                AquaTextFieldSearch.updatePromptLabel(jLabel, jTextComponent);
            }
        });
        jTextComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AquaTextFieldSearch.updatePromptLabel(jLabel, jTextComponent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                AquaTextFieldSearch.updatePromptLabel(jLabel, jTextComponent);
            }
        });
        AquaTextFieldSearch.updatePromptLabel(jLabel, jTextComponent);
        return jLabel;
    }

    static void updatePromptLabel(final JLabel jLabel, final JTextComponent jTextComponent) {
        if (SwingUtilities.isEventDispatchThread()) {
            AquaTextFieldSearch.updatePromptLabelOnEDT(jLabel, jTextComponent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AquaTextFieldSearch.updatePromptLabelOnEDT(jLabel, jTextComponent);
                }
            });
        }
    }

    static void updatePromptLabelOnEDT(JLabel jLabel, JTextComponent jTextComponent) {
        Object object;
        String string = " ";
        if (!jTextComponent.hasFocus() && "".equals(jTextComponent.getText()) && (object = jTextComponent.getClientProperty(PROMPT_KEY)) != null) {
            string = object.toString();
        }
        jLabel.setText(string);
    }

    protected static JButton getCancelButton(final JTextComponent jTextComponent) {
        final JButton jButton = AquaTextFieldSearch.createButton(jTextComponent, AquaTextFieldSearch.getCancelIcon());
        jButton.setName("cancel");
        Object object = jTextComponent.getClientProperty(CANCEL_ACTION_KEY);
        if (object instanceof ActionListener) {
            jButton.addActionListener((ActionListener)object);
        }
        jButton.addActionListener(new AbstractAction("cancel"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextComponent.setText("");
            }
        });
        jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                AquaTextFieldSearch.updateCancelIcon(jButton, jTextComponent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                AquaTextFieldSearch.updateCancelIcon(jButton, jTextComponent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                AquaTextFieldSearch.updateCancelIcon(jButton, jTextComponent);
            }
        });
        AquaTextFieldSearch.updateCancelIcon(jButton, jTextComponent);
        return jButton;
    }

    static void updateCancelIcon(final JButton jButton, final JTextComponent jTextComponent) {
        if (SwingUtilities.isEventDispatchThread()) {
            AquaTextFieldSearch.updateCancelIconOnEDT(jButton, jTextComponent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AquaTextFieldSearch.updateCancelIconOnEDT(jButton, jTextComponent);
                }
            });
        }
    }

    static void updateCancelIconOnEDT(JButton jButton, JTextComponent jTextComponent) {
        jButton.setVisible(!"".equals(jTextComponent.getText()));
    }

    static class SearchFieldBorder
    extends AquaTextFieldBorder
    implements AquaUtils.JComponentPainter {
        protected boolean reallyPaintBorder;
        protected boolean doingLayout;

        public SearchFieldBorder() {
            super(new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant().alterMargins(6, 31, 6, 24).alterInsets(3, 3, 3, 3)));
            ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.FRAME_TEXT_FIELD_ROUND);
        }

        public SearchFieldBorder(SearchFieldBorder searchFieldBorder) {
            super(searchFieldBorder);
        }

        @Override
        public void paint(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4) {
            this.reallyPaintBorder = true;
            this.paintBorder(jComponent, graphics, n, n2, n3, n4);
            this.reallyPaintBorder = false;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!this.reallyPaintBorder) {
                return;
            }
            super.paintBorder(component, graphics, n, n2 - n4 % 2, n3, n4);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            if (this.doingLayout) {
                return new Insets(0, 0, 0, 0);
            }
            if (!AquaTextFieldSearch.hasPopupMenu((JTextComponent)component)) {
                return new Insets(this.sizeVariant.margins.top, this.sizeVariant.margins.left - 7, this.sizeVariant.margins.bottom, this.sizeVariant.margins.right);
            }
            return this.sizeVariant.margins;
        }

        protected LayoutManager getCustomLayout() {
            return new BorderLayout(0, 0){

                @Override
                public void layoutContainer(Container container) {
                    SearchFieldBorder.this.doingLayout = true;
                    super.layoutContainer(container);
                    SearchFieldBorder.this.doingLayout = false;
                }
            };
        }
    }

    static class SearchFieldPropertyListener
    implements PropertyChangeListener {
        SearchFieldPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (!(object instanceof JTextComponent)) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            if (!(AquaTextFieldSearch.VARIANT_KEY.equals(string) || AquaTextFieldSearch.FIND_POPUP_KEY.equals(string) || AquaTextFieldSearch.FIND_ACTION_KEY.equals(string) || AquaTextFieldSearch.CANCEL_ACTION_KEY.equals(string) || AquaTextFieldSearch.PROMPT_KEY.equals(string))) {
                return;
            }
            JTextComponent jTextComponent = (JTextComponent)object;
            if (AquaTextFieldSearch.wantsToBeASearchField(jTextComponent)) {
                AquaTextFieldSearch.uninstallSearchField(jTextComponent);
                AquaTextFieldSearch.installSearchField(jTextComponent);
            } else {
                AquaTextFieldSearch.uninstallSearchField(jTextComponent);
            }
        }
    }
}

