/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.fx.ui;

import com.sun.deploy.uitoolkit.impl.fx.ui.FXDialog;
import com.sun.deploy.uitoolkit.impl.fx.ui.resources.ResourceManager;
import com.sun.deploy.uitoolkit.ui.ConsoleController;
import com.sun.deploy.uitoolkit.ui.ConsoleHelper;
import com.sun.deploy.uitoolkit.ui.ConsoleWindow;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import java.text.MessageFormat;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.stage.StageStyle;

public final class FXConsole
implements ConsoleWindow {
    private final boolean USE_TEXT_AREA = true;
    private final ConsoleController controller;
    private FXDialog dialog;
    private ScrollPane sp;
    private TextArea textArea;
    private Label textAreaLabel;

    public static FXConsole create(final ConsoleController controller) throws Exception {
        return (FXConsole)DeploySysRun.execute((DeploySysAction)new DeploySysAction(){

            public Object execute() {
                return new FXConsole(controller);
            }
        });
    }

    public FXConsole(ConsoleController controller) {
        this.controller = controller;
        FXConsole.invokeLater(new Runnable(){

            public void run() {
                FXConsole.this.dialog = new FXDialog(ResourceManager.getMessage("console.caption"), null, false, StageStyle.DECORATED);
                FXConsole.this.dialog.setResizable(true);
                FXConsole.this.dialog.impl_setImportant(false);
                BorderPane contentPane = new BorderPane();
                FXConsole.this.dialog.setContentPane(contentPane);
                FXConsole.this.dialog.setWidth(470.0);
                FXConsole.this.dialog.setHeight(430.0);
                FXConsole.this.textArea = new TextArea();
                FXConsole.this.textArea.setEditable(false);
                FXConsole.this.textArea.setWrapText(true);
                FXConsole.this.textArea.getStyleClass().add("multiline-text");
                contentPane.setCenter(FXConsole.this.textArea);
                EventHandler<KeyEvent> keyHandler = new EventHandler<KeyEvent>(){

                    @Override
                    public void handle(KeyEvent ev) {
                        String character = ev.getCharacter();
                        if (character != null && character.length() == 1) {
                            switch (character.charAt(0)) {
                                case 'j': {
                                    FXConsole.this.dumpJCovData();
                                    break;
                                }
                                case 'v': {
                                    FXConsole.this.dumpThreadStack();
                                    break;
                                }
                                case 'p': {
                                    FXConsole.this.reloadProxyConfig();
                                    break;
                                }
                                case 'r': {
                                    FXConsole.this.reloadPolicyConfig();
                                    break;
                                }
                                case 'x': {
                                    FXConsole.this.clearClassLoaderCache();
                                    break;
                                }
                                case 'l': {
                                    FXConsole.this.showClassLoaderCache();
                                    break;
                                }
                                case 'o': {
                                    FXConsole.this.logging();
                                    break;
                                }
                                case 't': {
                                    FXConsole.this.showThreads();
                                    break;
                                }
                                case 's': {
                                    FXConsole.this.showSystemProperties();
                                    break;
                                }
                                case 'h': {
                                    FXConsole.this.showHelp();
                                    break;
                                }
                                case 'm': {
                                    FXConsole.this.showMemory();
                                    break;
                                }
                                case 'c': {
                                    FXConsole.this.clearConsole();
                                    break;
                                }
                                case 'g': {
                                    FXConsole.this.runGC();
                                    break;
                                }
                                case 'f': {
                                    FXConsole.this.runFinalize();
                                    break;
                                }
                                case 'q': {
                                    FXConsole.this.closeConsole();
                                    break;
                                }
                                case '0': {
                                    FXConsole.this.traceLevel0();
                                    break;
                                }
                                case '1': {
                                    FXConsole.this.traceLevel1();
                                    break;
                                }
                                case '2': {
                                    FXConsole.this.traceLevel2();
                                    break;
                                }
                                case '3': {
                                    FXConsole.this.traceLevel3();
                                    break;
                                }
                                case '4': {
                                    FXConsole.this.traceLevel4();
                                    break;
                                }
                                case '5': {
                                    FXConsole.this.traceLevel5();
                                }
                            }
                        }
                    }
                };
                FXConsole.this.dialog.getScene().setOnKeyTyped((EventHandler<? super KeyEvent>)keyHandler);
                FXConsole.this.textArea.setOnKeyTyped((EventHandler<? super KeyEvent>)keyHandler);
                Button clear = new Button(ResourceManager.getMessage("console.clear"));
                Button copy = new Button(ResourceManager.getMessage("console.copy"));
                Button close = new Button(ResourceManager.getMessage("console.close"));
                FlowPane panel = new FlowPane();
                panel.getStyleClass().add("button-bar");
                panel.setId("console-dialog-button-bar");
                panel.getChildren().add(clear);
                panel.getChildren().add(new Label("    "));
                panel.getChildren().add(copy);
                panel.getChildren().add(new Label("    "));
                panel.getChildren().add(close);
                contentPane.setBottom(panel);
                clear.setOnAction(new EventHandler<ActionEvent>(){

                    @Override
                    public void handle(ActionEvent e) {
                        FXConsole.this.clearConsole();
                    }
                });
                copy.setOnAction(new EventHandler<ActionEvent>(){

                    @Override
                    public void handle(ActionEvent e) {
                        FXConsole.this.copyConsole();
                    }
                });
                close.setOnAction(new EventHandler<ActionEvent>(){

                    @Override
                    public void handle(ActionEvent e) {
                        FXConsole.this.closeConsole();
                    }
                });
            }
        });
    }

    private void dumpJCovData() {
        if (this.controller.isJCovSupported()) {
            if (this.controller.dumpJCovData()) {
                System.out.println(ResourceManager.getMessage("console.jcov.info"));
            } else {
                System.out.println(ResourceManager.getMessage("console.jcov.error"));
            }
        }
    }

    private void dumpThreadStack() {
        if (this.controller.isDumpStackSupported()) {
            System.out.print(ResourceManager.getMessage("console.dump.stack"));
            System.out.print(ResourceManager.getMessage("console.menu.text.top"));
            ConsoleHelper.dumpAllStacks((ConsoleController)this.controller);
            System.out.print(ResourceManager.getMessage("console.menu.text.tail"));
            System.out.print(ResourceManager.getMessage("console.done"));
        }
    }

    private void showThreads() {
        System.out.print(ResourceManager.getMessage("console.dump.thread"));
        ThreadGroup tg = this.controller.getMainThreadGroup();
        ConsoleHelper.dumpThreadGroup((ThreadGroup)tg);
        System.out.println(ResourceManager.getMessage("console.done"));
    }

    private void reloadPolicyConfig() {
        if (this.controller.isSecurityPolicyReloadSupported()) {
            System.out.print(ResourceManager.getMessage("console.reload.policy"));
            this.controller.reloadSecurityPolicy();
            System.out.println(ResourceManager.getMessage("console.completed"));
        }
    }

    private void reloadProxyConfig() {
        if (this.controller.isProxyConfigReloadSupported()) {
            System.out.println(ResourceManager.getMessage("console.reload.proxy"));
            this.controller.reloadProxyConfig();
            System.out.println(ResourceManager.getMessage("console.done"));
        }
    }

    private void showSystemProperties() {
        ConsoleHelper.displaySystemProperties();
    }

    private void showHelp() {
        ConsoleHelper.displayHelp((ConsoleController)this.controller, (ConsoleWindow)this);
    }

    private void showClassLoaderCache() {
        if (this.controller.isDumpClassLoaderSupported()) {
            System.out.println(this.controller.dumpClassLoaders());
        }
    }

    private void clearClassLoaderCache() {
        if (this.controller.isClearClassLoaderSupported()) {
            this.controller.clearClassLoaders();
            System.out.println(ResourceManager.getMessage("console.clear.classloader"));
        }
    }

    private void clearConsole() {
        this.clear();
    }

    private void copyConsole() {
        int selectionStart = this.textArea.getSelection().getStart();
        int selectionEnd = this.textArea.getSelection().getEnd();
        if (selectionEnd - selectionStart <= 0) {
            ClipboardContent content = new ClipboardContent();
            content.putString(this.textArea.getText());
            Clipboard.getSystemClipboard().setContent(content);
        } else {
            this.textArea.copy();
        }
    }

    private void closeConsole() {
        if (this.controller.isIconifiedOnClose()) {
            this.dialog.setIconified(true);
        } else {
            this.dialog.hide();
        }
        this.controller.notifyConsoleClosed();
    }

    private void showMemory() {
        long freeMemory = Runtime.getRuntime().freeMemory() / 1024L;
        long totalMemory = Runtime.getRuntime().totalMemory() / 1024L;
        long percentFree = (long)(100.0 / ((double)totalMemory / (double)freeMemory));
        MessageFormat mf = new MessageFormat(ResourceManager.getMessage("console.memory"));
        Object[] args = new Object[]{new Long(totalMemory), new Long(freeMemory), new Long(percentFree)};
        System.out.print(mf.format(args));
        System.out.println(ResourceManager.getMessage("console.completed"));
    }

    private void runFinalize() {
        System.out.print(ResourceManager.getMessage("console.finalize"));
        System.runFinalization();
        System.out.println(ResourceManager.getMessage("console.completed"));
        this.showMemory();
    }

    private void runGC() {
        System.out.print(ResourceManager.getMessage("console.gc"));
        System.gc();
        System.out.println(ResourceManager.getMessage("console.completed"));
        this.showMemory();
    }

    private void traceLevel0() {
        ConsoleHelper.setTraceLevel((int)0);
    }

    private void traceLevel1() {
        ConsoleHelper.setTraceLevel((int)1);
    }

    private void traceLevel2() {
        ConsoleHelper.setTraceLevel((int)2);
    }

    private void traceLevel3() {
        ConsoleHelper.setTraceLevel((int)3);
    }

    private void traceLevel4() {
        ConsoleHelper.setTraceLevel((int)4);
    }

    private void traceLevel5() {
        ConsoleHelper.setTraceLevel((int)5);
    }

    private void logging() {
        if (this.controller.isLoggingSupported()) {
            System.out.println(ResourceManager.getMessage("console.log") + this.controller.toggleLogging() + ResourceManager.getMessage("console.completed"));
        }
    }

    public void clear() {
        FXConsole.invokeLater(new Runnable(){

            public void run() {
                FXConsole.this.textArea.setText("");
                ConsoleHelper.displayVersion((ConsoleController)FXConsole.this.controller, (ConsoleWindow)FXConsole.this);
                FXConsole.this.append("\n");
                ConsoleHelper.displayHelp((ConsoleController)FXConsole.this.controller, (ConsoleWindow)FXConsole.this);
            }
        });
    }

    private static void invokeLater(Runnable r) {
        Platform.runLater(r);
    }

    public void append(final String text) {
        FXConsole.invokeLater(new Runnable(){

            public void run() {
                ScrollBar vsb = FXConsole.this.getVerticalScrollBar();
                boolean scrollToEnd = vsb == null || !vsb.isVisible() || vsb.getValue() == vsb.getMax();
                int len = FXConsole.this.textArea.getText().length();
                if (len > 1) {
                    FXConsole.this.textArea.insertText(len, text);
                } else {
                    FXConsole.this.textArea.setText(text);
                }
                if (scrollToEnd) {
                    FXConsole.this.setScrollPosition();
                }
            }
        });
    }

    private void setScrollPosition() {
        ScrollBar vsb = this.getVerticalScrollBar();
        if (vsb != null) {
            double max = vsb.getMax();
            double value = vsb.getValue();
            if (value < max) {
                vsb.setValue(max);
            }
        }
    }

    private ScrollBar getVerticalScrollBar() {
        return this.findScrollBar(this.textArea, true);
    }

    private ScrollBar findScrollBar(Parent parent, boolean vertical) {
        if (parent instanceof ScrollBar) {
            ScrollBar sb = (ScrollBar)parent;
            if (sb.getOrientation() == Orientation.VERTICAL == vertical) {
                return (ScrollBar)parent;
            }
            return null;
        }
        for (Node child : parent.getChildrenUnmodifiable()) {
            ScrollBar sb;
            if (!(child instanceof Parent) || (sb = this.findScrollBar((Parent)child, vertical)) == null) continue;
            return sb;
        }
        return null;
    }

    public void setVisible(final boolean visible) {
        FXConsole.invokeLater(new Runnable(){

            public void run() {
                FXConsole.this.setVisibleImpl(visible);
            }
        });
    }

    private void setVisibleImpl(boolean visible) {
        if (this.controller.isIconifiedOnClose()) {
            this.dialog.setIconified(!visible);
            this.dialog.show();
        } else {
            if (this.isVisible() != visible) {
                if (visible) {
                    this.dialog.show();
                } else {
                    this.dialog.hide();
                }
            }
            if (visible) {
                this.dialog.toFront();
            }
        }
    }

    public void setTitle(final String string) {
        FXConsole.invokeLater(new Runnable(){

            public void run() {
                FXConsole.this.setTitleImpl(string);
            }
        });
    }

    private void setTitleImpl(String string) {
        this.dialog.setTitle(string);
    }

    public String getRecentLog() {
        return "Not supported yet.";
    }

    public boolean isVisible() {
        if (this.controller.isIconifiedOnClose()) {
            return !this.dialog.isIconified();
        }
        return this.dialog.isShowing();
    }

    public void dispose() {
    }
}

