/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.ComponentModel;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import jep.AppletHolder;
import jep.AppletHolderFactory;
import sun.java2d.SunGraphics2D;

public class GraphicsClipper {
    protected static boolean showDebugInfo = false;
    protected WeakReference graphics = null;
    protected AppletHolder ancestor = null;
    protected ComponentModel peer = null;
    protected Object devClipLock = new Object();

    public static GraphicsClipper createNew(SunGraphics2D sunGraphics2D, AppletHolder appletHolder, ComponentModel componentModel) {
        return new GraphicsClipper(sunGraphics2D, appletHolder, componentModel);
    }

    public GraphicsClipper(SunGraphics2D sunGraphics2D, AppletHolder appletHolder, ComponentModel componentModel) {
        this.graphics = new WeakReference<SunGraphics2D>(sunGraphics2D);
        this.ancestor = appletHolder;
        this.peer = componentModel;
        appletHolder.addClipper(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle clipToApplet(int n, int n2, int n3, int n4) {
        Object object = this.devClipLock;
        synchronized (object) {
            if (this.ancestor.destroying || this.peer.fTarget == null || this.graphics.get() == null) {
                return new Rectangle();
            }
            if (!AppletHolderFactory.isAppletViewDisplayable(this.ancestor.getCocoaParentViewLong())) {
                if (showDebugInfo) {
                    System.err.println("GraphicsClipper.clipToApplet(): Zero-clipping because applet invisible");
                }
                return new Rectangle();
            }
            if (this.ancestor.updatesOff || this.ancestor.asyncUpdatesOff) {
                if (showDebugInfo) {
                    System.err.println("GraphicsClipper.clipToApplet(): Zero-clipping because updates off");
                }
                return new Rectangle();
            }
            Rectangle rectangle = null;
            Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
            try {
                rectangle = this.ancestor.translateCurrentClip(this.peer.fTarget).intersection(rectangle2);
                if (rectangle.isEmpty()) {
                    rectangle.height = 0;
                    rectangle.width = 0;
                    rectangle.y = 0;
                    rectangle.x = 0;
                }
            }
            catch (Throwable throwable) {
                rectangle = new Rectangle();
            }
            if (showDebugInfo) {
                System.err.println("GraphicsClipper.clipToApplet(): Clipping from " + rectangle2.toString() + " to " + rectangle.toString());
            }
            return rectangle;
        }
    }

    public Rectangle clipToApplet(Rectangle rectangle) {
        return this.clipToApplet(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateDevClip() {
        Object object = this.devClipLock;
        synchronized (object) {
            if (this.ancestor.destroying || this.peer.fTarget == null) {
                this.zeroDevClip();
                return;
            }
            SunGraphics2D sunGraphics2D = (SunGraphics2D)this.graphics.get();
            if (sunGraphics2D == null) {
                return;
            }
            Rectangle rectangle = null;
            try {
                rectangle = sunGraphics2D.getSurfaceData().getBounds();
            }
            catch (NullPointerException nullPointerException) {
                this.zeroDevClip();
                return;
            }
            Rectangle rectangle2 = this.clipToApplet(rectangle);
            if (!AppletHolderFactory.isJava142()) {
                sunGraphics2D.setDevClip(rectangle2);
                return;
            }
            Rectangle rectangle3 = this.getDevClip();
            if (rectangle3.x != rectangle2.x || rectangle3.y != rectangle2.y || rectangle3.width != rectangle2.width || rectangle3.height != rectangle2.height) {
                sunGraphics2D.setDevClip(rectangle2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zeroDevClip() {
        Object object = this.devClipLock;
        synchronized (object) {
            SunGraphics2D sunGraphics2D = (SunGraphics2D)this.graphics.get();
            if (sunGraphics2D == null) {
                return;
            }
            sunGraphics2D.setDevClip(new Rectangle());
        }
    }

    public Rectangle getDevClip() {
        return null;
    }

    public SunGraphics2D getGraphics() {
        return (SunGraphics2D)this.graphics.get();
    }

    public String toString() {
        return this.getClass().getName() + " (jep)";
    }

    static {
        if ("true".equalsIgnoreCase(System.getProperty("jep.debuginfo", "false"))) {
            showDebugInfo = true;
        }
    }
}

