#! /usr/bin/env ruby
require File.dirname(__FILE__) + '/lib/base'
require File.dirname(__FILE__) + '/lib/csv'

class WebConfidentialImporter < Importer
  
  TYPES = { 
    "2" => ["FTP Servers", "Name", "URL", "User ID", "Password"],
    "3" => ["Newsgroups", "Name", "URL", "User ID", "Password"],
    "4" => ["Online Banking", "Bank", "Home Page", "User ID", "Password"],
    "5" => ["Login Accounts", "Name", "Host", "Login", "Password"],
    "6" => ["Email Accounts", "Name", "Server", "User ID", "Password"],
    "7" => ["Bank Accounts", "Bank", "Branch Number", "Account Holder", "Account Number"],
    "8" => ["Credit Cards", "Name/Type", "Exp. Date", "Number", "PIN Code"],
    "9" => ["ATM/PIN Cards", "Name", "Bank", "Telephone", "ATM/PIN Code"],
    "10" => ["Personal Data", "Person", "Type of Date", "Date/Place Issued", "Number"],
    "11" => ["Software Keys", "Product", "Home Page", "Licensed To", "Software Key"],
    "12" => ["Serial Numbers", "Name", "Home Page", "Other", "Number"],
    "13" => ["Membership #s", "Organization", "Home Page", "Name", "Number"],
    "14" => ["Miscellaneous", "Name", "URL", "User ID", "Password"],
  }
  
  
  def process_line(line)
    items = CSV::parse_line(line, "\t")
    if (items.size < 5)
      @errors << "Failed to parse line '#{line}'"
      return
    end
    
    for i in 0..4
      items[i] ||= ""
    end
    
    type = items[0]
    title = items[1]
    location = items[2]
    userid = items[3]
    password = items[4]
    
    if userid == "Passwords\302\240not\302\240saved"
      return
    end

    notes = ""
    if items.size > 5
      notes = items[5] || ""
    end
    
    item = nil
    
    if type == "2"
      item = AGFTPAccount.new
      item.title = title
      item.server = location
      item.add_login(userid, password)
      item.notes = notes
    elsif type == "7"
      item = AGBankAccountUS.new
      item.title = title
      item.bankName = title
      item.routingNo = items[2]
      item.owner = items[3]
      item.accountNo = items[4]
      item.notes = notes
    elsif type == "8"
      item = AGCreditCard.new
      item.title = title
      item.ccnum = items[3]
      item.pin = items[4]
      item.notes = "Exp. Date: #{items[2]}\n" + notes
    elsif type == "11" || type == "12"
      item = AGLicense.new
      item.title = title
      item.product_name = title
      item.publisher_website = items[2]
      item.reg_name = items[3]
      item.reg_code = items[4]
      item.notes = notes
    elsif (["0", "1", "4", "5", "6"].include?(type) )
      item = WebForm.new
      item.title = title
      item.location = location
      item.add_login(userid, password)
      item.notes = notes
    else
      fields = TYPES[type]

      item = SecureNote.new
      s = ""
      if fields
        item.folderPath = fields[0]
        item.title = "#{title}: #{location}"
        s = <<-NOTES
#{fields[0]}
#{fields[1]}: #{title}
#{fields[2]}: #{location}
#{fields[3]}: #{userid}
#{fields[4]}: #{password}
NOTES
      else
        s = <<-NOTES
Name: #{title}
URL: #{location}
User ID: #{userid}
Password: #{password}
NOTES
      end
      
      if notes != ""
        s += "-----------\n#{notes}"
      end
      
      item.notes = s
    end
    
    add_item item
  end
  
end

WebConfidentialImporter.new.run
