#! /usr/bin/env ruby
require File.dirname(__FILE__) + '/lib/base'
require File.dirname(__FILE__) + '/lib/csv'

class SplashIdImporter < Importer

  TYPES = {
    "Web Logins" => [], # Needed even though we hardcode it below. See simplified_csv for details
    "Bank Accts" => ["Account #: ", "PIN: ", "Name: ", "Branch: ", "Phone #: "],
    "Birthdays" => ["Date: ", "", "", "", ""],
    "Calling Cards" => ["Access #: ", "PIN: ", "", "", ""],
    "Clothes Size" => ["Shirt Size: ", "Pant Size: ", "Shoe Size: ", "Dress Size: ", ""],
    "Combinations" => ["Code: ", "", "", "", ""],
    "Credit Cards" => ["Card #: ", "Expir. Date: ", "Name: ", "PIN: ", "Bank: "],
    "Email Accts" => ["Username: ", "Password: ", "POP3 Host: ", "SMTP Host: ", ""],
    "Emergency Info" => ["Phone #: ", "", "", "", ""],
    "Frequent Flyer" => ["Number: ", "Name: ", "Date: ", "", ""],
    "Identification" => ["Number: ", "Name: ", "Date: ", "", ""],
    "Insurance" => ["Policy #: ", "Group #:", "Insured: ", "Date: ", "Phone #: "],
    "Memberships" => ["Acct #: ", "Name: ", "Date: ", "", ""],
    "Phone Numbers" => ["Phone #: ", "", "", "", ""],
    "Prescriptions" => ["Rx #: ", "Name: ", "Doctor: ", "Pharmacy: ", "Phone #: "],
    "Serial Numbers" => ["Serial #: ", "Date: ", "Reseller: ", "", ""],
    "Vehicle Info" => ["License #: ", "VIN #: ", "", "", ""],
    "Voice Mail" => ["Access #: ", "PIN: ", "", "", ""],
  }

  UNFILED = ["", "", "", "", ""]

  def process_contents(contents)
    contents.gsub!(/\r/, "\n")
    cursor_index = 0
    rows = []
    begin 
      items = []
      parsed_cells, cursor_index = CSV.parse_row(contents, cursor_index, items)
      if items.size < 9
    		add_error "Failed to parse line. Actual items: #{items.inspect}"
    		next
    	end
    	rows << items
    end while parsed_cells > 0
    
    types, entries = rows.partition { |row| row[0] == "T" }
    
    types_map = types.inject(Hash.new) do |map, type|
      _type, _array = type[1], type
      map.store(_type, _array)
      map
    end
    
    entries.each do |items|
      relevant_fields = items.slice(2..-1)
      relevant_field_types = types_map[items[1]].slice(3..-1)
      type = types_map[items[1]][2] || ""
      category = items[-2] || ""
      description = items[2] || ""
      notes = items[-1].to_s
      types_map[items[1]].slice(2..-1).each_index do |index|
        notes += "\n#{relevant_field_types[index]}: #{relevant_fields[index]}" if relevant_fields[index].to_s != ""
      end
      
      item = nil

      if type == "Web Logins"
        item = WebForm.new
        item.name = type + "\\" + category + "\\" + description
        item.add_login(items[3], items[4])
        item.url = items[5]
      elsif type == "Credit Cards"
        item = AGCreditCard.new
        item.ccnum = items[3]
        item.title = description
        item.pin = items[6]
        item.bank = items[7]
        item.expiration_date = items[4]
        item.cardholder = items[5]
      elsif type == "Bank Accts"
        item = AGBankAccountUS.new
        item.accountNo = items[3]
        item.title = description
        item.branchPhone = items[7]
      elsif type == "Serial Numbers"
        item = AGLicense.new
        item.title = description
        item.reg_code = items[3]
        item.order_date = items[4]
        item.publisher_name = items[5]
      else
        item = SecureNote.new
        best_title_for_note = description
        unless category.to_s == "" and type.to_s == ""
          best_title_for_note += " ("
          best_title_for_note += "#{category} - " unless category.to_s == ""
          best_title_for_note += type unless type.to_s == ""
          best_title_for_note += ")"
        end
        item.name=best_title_for_note
      end
      item.notes = notes
      add_item item
    end
  end
end

SplashIdImporter.new.run
