#! /usr/bin/env ruby
require File.dirname(__FILE__) + '/lib/base'
require File.dirname(__FILE__) + '/lib/csv'

class PasswordsPlusImporter < Importer
  
  def process_contents(contents)
    contents = contents.gsub("\r", "\n")
    reader = CSV::Reader.create(contents, nil, nil)
    while true
      row = []
      parsed_cells = reader.get_row(row) rescue nil
      break if parsed_cells == 0
      
      next unless row || row.size < 3
      next if row[0] != "0"
      
      row.shift
      
      title = row.shift
      folder = row.shift
      folder = "" if folder == "Unfiled"
      
      s = ""
      while row.size >= 3 
        s +="#{row[0]}: #{row[1]}\n" if row[0] && row[1] && row[1].strip != ""
        row.shift
        row.shift
        row.shift
      end
      
      if row.size == 1 && row[0] 
        s += "\n" + row[0]
      end

      item = SecureNote.new
      item.title = title
      item.folderPath = folder
      item.notes = s
      add_item(item)
    end
    
  end
  
end

PasswordsPlusImporter.new.run
