#! /usr/bin/env ruby
require File.dirname(__FILE__) + '/lib/base'

class LicenseKeeperImporter < Importer
  
  def process_contents(contents)
    CSV.parse(contents, nil, nil) { |row| process_row(row) }
  end

  def process_row(row)
    
    license = AGLicense.new
    license.title = row[0]
    license.product_name = row[0]
    license.product_version = row[1]
    license.reg_code = row[2]
    license.reg_name = row[3]
    license.reg_email = row[4]
    license.company = row[5]
    license.publisher_name = row[6]
    license.publisher_website = row[7]
    license.support_email = row[8]
    license.order_date = row[9]
    license.price = row[10] + row[11] unless (row[11] == nil || row[11].length == 0)
    license.order_number = row[12]
    license.notes = row[13]
    
    add_item(license)
  end
end

LicenseKeeperImporter.new.run