#
# Exports Safari passwords from default keychain. 
#
# Uses dump-keychain to probe for Safari entries so user will be prompted less.
#
$debug=false

def debug(msg)
  puts msg if $debug
end

default_keychain = `security default-keychain`

puts "default keychain = #{default_keychain.inspect}" if $debug
default_keychain = $1 if default_keychain =~ /\s*"(.*)"/

puts "Using default keychain <#{default_keychain}>"
print "Dumping (non-encrypted) data..."

cmd = "security dump-keychain #{default_keychain}"
debug("\nRunning command <#{cmd}>")
dump = `#{cmd}`

puts "dump was #{dump.length} bytes."

# Dump uses this format:
#   keychain: "/Users/dave/Library/Keychains/login.keychain"
#   class: "inet"
#   attributes:
#       0x00000007 <blob>="www.flickr.com"
#       ...

dump_entries = dump.split("keychain: \"#{default_keychain}\"\n")

puts "#{dump_entries.length} Login items found."

inet_entries = []
dump_entries.each do |dump_entry|
  
  title, acct, desc, srvr = $1, $2, $3, $4 if dump_entry =~ /class: "inet"\nattributes:\n\s+0x00000007 <blob>="(.*?)"\n.*"acct"<blob>="(.*?)"\n.*"desc"<blob>="(.*?)"\n.*"srvr"<blob>="(.*?)"/m
  
  if (title && desc == "Web form password")
    puts "Found Safari web form password: #{title.inspect}" if $debug
    inet_entries << {:title => title, :account => acct, :service => srvr}
  else
    debug("Skipping #{title} because type=#{desc.inspect}") if title
  end
end

puts "#{inet_entries.length} of the #{dump_entries.length} items were Safari web form passwords."

print "\n\nAbout to export #{inet_entries.length} Safari logins. You may be prompted by OS X to grant access for every item. It means you could be required to click the 'Allow' button #{inet_entries.length} times.\n\nAre you sure you want to proceed?\n\nPress 'y' followed by the Enter key to proceed."

input = gets

puts "#{input.inspect}"
unless (input =~ /y/i)
  puts "Skipping export. Press 'y' if you wanted proceed'"
  exit(-1)
end

puts "Starting export of #{inet_entries.length} items. Be sure to click 'Allow' for every item."

safari_logins = []
inet_entries.each do |entry|
  puts "Loading information for #{entry[:title].inspect}."
  
  security_export_cmd = "security find-internet-password -g -s \"#{entry[:service]}\" -a \"#{entry[:account]}\""
  debug("   <#{security_export_cmd}>")
  
  data = `#{security_export_cmd} 2>&1`
  
  # Important bits:
  # =>  password: "XXX"
  # =>  attributes:
  # =>      0x00000007 <blob>="daw2.apple.com (dteare)"
  # =>      "acct"<blob>="dteare"
  # =>      "ptcl"<uint32>="htps"
  # =>      "srvr"<blob>="daw2.apple.com"
  password, title, username, protocol, server = $1, $2, $3, $4, $5 if data =~ /password:(.*?)\n.*class: "inet"\nattributes:\n\s+0x00000007 <blob>="(.*?)"\n.*"acct"<blob>="(.*?)"\n.*"ptcl"<uint32>="(.*)"\n.*"srvr"<blob>="(.*?)"/m

  real_password = nil
  real_password = $1 if password =~ /^\s"(.*)"$/
  if (title)
    url = server
    url = "http://" + url if protocol == "http"
    url = "https://" + url if protocol == "htps"
    safari_logins << [title, url, username, real_password]
  else
    puts "WARNING: Skipping <#{entry[:title]}> because format wasn't as expected:\n#{data}.inspect"
  end
end

puts "Saving #{safari_logins.length} Safari logins to ~/Desktop/SafariLogins.csv. You can import these into 1Password by using the File > Import... menu, specify 'CSV or Delimited Text' as the Import Format, and click Continue. On the next screen click Choose File and select the SafariLogins.csv file from your Desktop folder."

File.open(File.expand_path("~/Desktop/SafariLogins.csv"), 'w') do |file| 
  safari_logins.each do |login|
    file.write(login * "\t")
    file.write("\n")
  end
end