#! /usr/bin/env ruby
require File.dirname(__FILE__) + '/lib/base'
require File.dirname(__FILE__) + '/lib/csv'

class SplashIdImporter < Importer

  TYPES = {
    "Web Logins" => [], # Needed even though we hardcode it below. See simplified_csv for details
    "Bank Accts" => ["Account #: ", "PIN: ", "Name: ", "Branch: ", "Phone #: "],
    "Birthdays" => ["Date: ", "", "", "", ""],
    "Calling Cards" => ["Access #: ", "PIN: ", "", "", ""],
    "Clothes Size" => ["Shirt Size: ", "Pant Size: ", "Shoe Size: ", "Dress Size: ", ""],
    "Combinations" => ["Code: ", "", "", "", ""],
    "Credit Cards" => ["Card #: ", "Expir. Date: ", "Name: ", "PIN: ", "Bank: "],
    "Email Accts" => ["Username: ", "Password: ", "POP3 Host: ", "SMTP Host: ", ""],
    "Emergency Info" => ["Phone #: ", "", "", "", ""],
    "Frequent Flyer" => ["Number: ", "Name: ", "Date: ", "", ""],
    "Identification" => ["Number: ", "Name: ", "Date: ", "", ""],
    "Insurance" => ["Policy #: ", "Group #:", "Insured: ", "Date: ", "Phone #: "],
    "Memberships" => ["Acct #: ", "Name: ", "Date: ", "", ""],
    "Phone Numbers" => ["Phone #: ", "", "", "", ""],
    "Prescriptions" => ["Rx #: ", "Name: ", "Doctor: ", "Pharmacy: ", "Phone #: "],
    "Serial Numbers" => ["Serial #: ", "Date: ", "Reseller: ", "", ""],
    "Vehicle Info" => ["License #: ", "VIN #: ", "", "", ""],
    "Voice Mail" => ["Access #: ", "PIN: ", "", "", ""],
  }

  UNFILED = ["", "", "", "", ""]

  def process_contents(contents)
    contents.gsub!(/\r/, "\n")
    cursor_index = 0
    rows = []
    begin 
      items = []
      parsed_cells, cursor_index = CSV.parse_row(contents, cursor_index, items)
      if items.size < 9
    		add_error "Failed to parse line. Actual items: #{items.inspect}"
    		next
    	end
    	rows << items
    end while parsed_cells > 0
    cursor_index = 0
    current_entries = []
    while rows[cursor_index][0] != "T" do
      cursor_index += 1
    end
    begin
      current_type = rows[cursor_index]
      begin
        cursor_index += 1
        current_entries << rows[cursor_index] unless rows[cursor_index].nil? || rows[cursor_index][0] != "F"
      end while rows[cursor_index] and rows[cursor_index][0] == "F"
      add_objects_for_entries_of_type(current_entries, current_type)
      current_type = current_entries = []
    end while cursor_index < rows.length
  end
  
  def add_objects_for_entries_of_type(entries, type)
    relevant_field_types = type.slice(3..-1)
    type_string = type[2] || ""
    
    entries.each do |items|
      relevant_fields = items.slice(2..-1)
      category = items[-2] || ""
      description = items[2] || ""
      notes = items[-1].to_s
      type.slice(2..-1).each_index do |index|
        notes += "\n#{relevant_field_types[index]}: #{relevant_fields[index]}" if relevant_fields[index].to_s != ""
      end
      
      item = nil
      if type_string == "Web Logins"
        item = WebForm.new
        item.name = type_string + "\\" + category + "\\" + description
        item.add_login(items[3], items[4])
        item.url = items[5]
      elsif type_string == "Credit Cards"
        item = AGCreditCard.new
        item.ccnum = items[3]
        item.title = description
        item.pin = items[6]
        item.bank = items[7]
        item.expiration_date = items[4]
        item.cardholder = items[5]
      elsif type_string == "Bank Accts"
        item = AGBankAccountUS.new
        item.accountNo = items[3]
        item.title = description
        item.branchPhone = items[7]
      elsif type_string == "Serial Numbers"
        item = AGLicense.new
        item.title = description
        item.reg_code = items[3]
        item.order_date = items[4]
        item.publisher_name = items[5]
      else
        item = SecureNote.new
        best_title_for_note = description
        unless category.to_s == "" and type_string.to_s == ""
          best_title_for_note += " ("
          best_title_for_note += "#{category} - " unless category.to_s == ""
          best_title_for_note += type_string unless type_string.to_s == ""
          best_title_for_note += ")"
        end
        item.name=best_title_for_note
      end
      item.notes = notes
      add_item(item)
    end
  end
end

SplashIdImporter.new.run
