#! /usr/bin/env ruby
require File.dirname(__FILE__) + '/lib/base'
require File.dirname(__FILE__) + '/lib/csv'

class PasswordsPlusImporter < Importer
  
  def process_contents(contents)
    contents = contents.gsub("\r", "\n")
    reader = CSV::Reader.create(contents, nil, nil)
    while true
      row = []
      parsed_cells = reader.get_row(row) rescue nil
      break if parsed_cells == 0
      
      next unless row || row.size < 3
      next if row[0] != "0"
      row.shift
      if row[2] == "URL" and row[5] == "Username" and row[8] == "Password"
        add_row_as_login row
      elsif row[2] == "Card Number" and row[5] == "Expiration Date" and row[8] == "CVV/Security Code" and row[11] == "Name on Card"
        add_row_as_credit_card row
      else
        add_row_as_secure_note row
      end
      
    end
  end
  
  # Data format for login:
  # Website,,URL,,0,Username,,0,Password,,0,Security Question,,0,Security Answer,,0,
  def add_row_as_login row
    item = WebForm.new
    item.url = row[3]
    item.name = row[0]
    username, password = row[6], row[9]
    username ||= ""
    password ||= ""
    item.add_login(username, password)
    
    folder = row[1]
    folder = "" if folder == "Unfiled"
    item.folderPath = folder
    
    security_question, security_answer = row[12], row[15]
    item.add_field(security_question, security_answer, "P") if security_question or security_answer
    
    row = row.slice(17..-1)
    item.notes = notes_from_row_fields(row)
    
    add_item(item)
    
  end
  
  # Data format for credit card:
  # Credit Card,,Card Number,,0,Expiration Date,,0,CVV/Security Code,,0,Name on Card,,0,URL,,0,Username,,0,Password,,1,Phone Number,,0,
  def add_row_as_credit_card row
    item = AGCreditCard.new
    item.folderPath = row[1]
    item.ccnum = row[3]
    item.title = row[0]
    item.expiration_date = row[6]
    item.cardholder = row[12]
    item.cvv = row[9]
    
    login = WebForm.new
    login.url=row[15]
    login.name = row[0]
    username, password = row[18], row[21]
    username ||= ""
    password ||= ""
    login.add_login(username, password)
    
    row = row[23..-1]
    item.notes = notes_from_row_fields row
    login.notes = notes_from_row_fields row
    add_item(item)
    add_item(login)
  end
  
  def add_row_as_secure_note row
    title = row.shift
    folder = row.shift
    folder = "" if folder == "Unfiled"
      
    item = SecureNote.new
    item.name = title
    item.folderPath = folder
    item.notes = notes_from_row_fields row
    add_item(item)
  end
  
  def notes_from_row_fields row
    s = ""
    while row.size >= 3 
      s +="#{row[0]}: #{row[1]}\n" if row[0] && row[1] && row[1].strip != ""
      3.times { row.shift }
    end
    
    if row.size == 1 && row[0] 
      s += "\n" + row[0]
    end
    return s
  end
  
end

PasswordsPlusImporter.new.run
