#! /usr/bin/env ruby
require File.dirname(__FILE__) + '/lib/base'
require File.dirname(__FILE__) + '/lib/csv'

class AutoIdImporter < Importer
  
  def process_contents(contents)
    lines = contents.split("\r\n")
    
    lines.shift
    
    for line in lines do
      process_line(line)
    end
  end
  
  def process_line(line)
    items = CSV::parse_line(line, ",")

  	if items.size < 11
  		add_error "Failed to parse line: #{line}"; 
  		return;
  	end

    for i in 0..10
      items[i] ||= ""
    end


    url = items[0].gsub(/^"/, "")
    username = items[1]
    password = items[2]
    serial = items[3]
    ccnum = items[4]
    ccexp = items[5]
    ccsec = items[6]
    notes = items[8] 
    
    title = "autoID(#{url||username||ccnum})"
    
    notes = "-----\n" + notes if notes != ""
    notes = "Sec Code: #{ccsec}\n" + notes if ccsec != ""
    notes = "Exp. Date: #{ccexp}\n" + notes if ccexp != ""
    notes = "Credit Card: #{ccnum}\n" + notes if ccnum != ""
    notes = "Serial: #{serial}\n" + notes if serial != ""
      
  	if url.length < 4
        notes = "Password: #{password}\n" + notes if password != ""
        notes = "Name or ID: #{username}\n" + notes if username != ""
        notes = "Web Link: #{url}\n" + notes if url != ""

        n = SecureNote.new
        n.name = title
        n.notes = notes
        add_item n
    	else
        f = WebForm.new
        f.name = title
        f.url = url
        f.add_login(username, password)
        f.notes = notes
        add_item f
    end
    
  end
  
end

AutoIdImporter.new.run
