#! /usr/bin/env ruby
require File.dirname(__FILE__) + '/lib/base'
require File.dirname(__FILE__) + '/lib/csv'

class SplashIdImporter < Importer

  TYPES = {
    "Bank Accts" => ["Account #: ", "PIN: ", "Name: ", "Branch: ", "Phone #: "],
    "Birthdays" => ["Date: ", "", "", "", ""],
    "Calling Cards" => ["Access #: ", "PIN: ", "", "", ""],
    "Clothes Size" => ["Shirt Size: ", "Pant Size: ", "Shoe Size: ", "Dress Size: ", ""],
    "Combinations" => ["Code: ", "", "", "", ""],
    "Credit Cards" => ["Card #: ", "Expir. Date: ", "Name: ", "PIN: ", "Bank: "],
    "Email Accts" => ["Username: ", "Password: ", "POP3 Host: ", "SMTP Host: ", ""],
    "Emergency Info" => ["Phone #: ", "", "", "", ""],
    "Frequent Flyer" => ["Number: ", "Name: ", "Date: ", "", ""],
    "Identification" => ["Number: ", "Name: ", "Date: ", "", ""],
    "Insurance" => ["Policy #: ", "Group #:", "Insured: ", "Date: ", "Phone #: "],
    "Memberships" => ["Acct #: ", "Name: ", "Date: ", "", ""],
    "Phone Numbers" => ["Phone #: ", "", "", "", ""],
    "Prescriptions" => ["Rx #: ", "Name: ", "Doctor: ", "Pharmacy: ", "Phone #: "],
    "Serial Numbers" => ["Serial #: ", "Date: ", "Reseller: ", "", ""],
    "Vehicle Info" => ["License #: ", "VIN #: ", "", "", ""],
    "Voice Mail" => ["Access #: ", "PIN: ", "", "", ""],
  }

  UNFILED = ["", "", "", "", ""]
  
  def process_contents(contents)
    lines = contents.gsub("\r\n", "\n").gsub("\n\r", "\n").gsub("\r", "\n").split("\n")
    lines.shift
    
    for line in lines do
      process_line(line)
    end
  end
  
  def process_line(line)
    items = CSV::parse_line(line)
    
  	if items.size < 9
  		add_error "Failed to parse line: #{line}"; 
  		return;
  	end
    
    for i in 0..7
      items[i] ||= ""
    end

    type = items[0] || ""
    category = items[8] || ""
    description = items[1] || ""
    notes = (items[11] || "").gsub("\x0B", "\n")
    
    item = nil
    
    if type == "Web Logins"
      item = WebForm.new
      item.name = category + "\\" + type + "\\" + description
      item.add_login(items[2], items[3])
      item.url = items[4]

      s = ""
      s += items[5] + "\n" if items[5] != ""
      s += items[6] + "\n" if items[6] != ""
      if notes != ""
        s += "-----\n" if s != ""
        s += notes
      end

      item.notes = s
      
    elsif type == "Credit Cards"
      item = AGCreditCard.new
      item.ccnum = items[2]
      item.title = items[4]
      item.pin = items[5]
      item.bank = items[6]
      item.notes = notes
      
    elsif type == "Bank Accts"
      item = AGBankAccountUS.new
      item.accountNo = items[2]
      notes = "PIN: #{items[3]}\n" + notes
      item.title = items[4]
      item.routingNo = items[5]
      item.branchPhone = items[6]
      item.notes = notes
      
    elsif type == "Serial Numbers"
      item = AGLicense.new
      item.title = items[4]
      item.reg_code = items[2]
      item.order_date = items[3]
      item.publisher_name = items[4]
      
      notes = items[5] + "\n" + notes if items[5] != "" 
      notes = items[6] + "\n" + notes if items[6] != "" 
      item.notes = notes
      
    else
      item = SecureNote.new
      item.name = category + "\\" + type + "\\" + description
      
      field_names = TYPES[type] || UNFILED
      
      s = ""
      s += "#{field_names[0]}#{items[2]}\n" if items[2] != ""
      s += "#{field_names[1]}#{items[3]}\n" if items[3] != ""
      s += "#{field_names[2]}#{items[4]}\n" if items[4] != ""
      s += "#{field_names[3]}#{items[5]}\n" if items[5] != ""
      s += "#{field_names[4]}#{items[6]}\n" if items[6] != ""
      if notes != ""
        s += "-----\n" if s != ""
        s += notes
      end

      item.notes = s
    end
    
    
    add_item item
  end
  
end

SplashIdImporter.new.run
