#! /usr/bin/env ruby
require File.dirname(__FILE__) + '/lib/base'

class RoboFormImporter < Importer

  def process_contents(contents)
    s = contents.gsub('<WBR>', "").gsub("&amp;", "&").gsub("&lt;", "<").gsub("&gt;", ">").gsub("&nbsp;", " ").gsub("&apos;", "'").gsub("&quot;", '"')
    
    items = s.split("<TBODY>")
    for item in items do
      process_item(item)
    end
  end
  
  def process_item(s)
    return if s.nil?

    name = nil
    if s =~ /TD class=caption[^>]+>([^<]+)<(.*)/im
      name = $1
      s = $2
    end

    value = nil
    if s =~ %r{TD class=wordbreakfield[^>]+>(.+)</TD></TR></TBODY></TABLE></TD(.*)}im
      value = $1 || ""
      s = $2
    end
    
    return if name.nil? || value.nil?
    
    note = SecureNote.new
    note.title = name
    note.notes = value.gsub("<BR>", "\n")
    add_item(note)
  end
  
end

RoboFormImporter.new.run