#! /usr/bin/env ruby
require File.dirname(__FILE__) + '/lib/base'
require File.dirname(__FILE__) + '/lib/plist'
require 'jcode'
$KCODE = 'UTF-8'

class AppShelf < Importer
  
  def process_contents(contents)
    r = Plist::parse_xml(contents)
    r.each { |item|
      license = AGLicense.new
      license.title = item["appName"].gsub(/\.app/i, "")
      license.product_name = item["appName"]
      license.price = item["price"]
      license.product_version = item["purchasedVersion"]
      license.reg_name = item["registrationName"]
      license.reg_code = item["registrationSerialKey"]
      license.reg_email = item["registrationEmail"]
      license.publisher_website = item["wherePurchased"]
      license.notes = item["details"]
      add_item(license)
    }
  end
end

AppShelf.new.run unless ENV['TESTING'] == "true"
