/* This demo program is loosely based on the following version of
   Rod's Color Pattern in C by Dr. John B. Matthews:

   http://home.roadrunner.com/~jbmatthews/apple2.html#rp1c

   Which in turn is based on Rod's Color Pattern, written in Basic
   by Randy Wigginton, which originally appeared on page 55 of the Red Book
   distributed by Apple Computer, Inc. circa 1978. It was described as
   "a simple but eloquent program. It generates a continuous flow of colored
   mosaic-like patterns in a 40 high by 40 wide block matrix.
   Many of the patterns generated by this program are pleasing to the eye
   and will dazzle the mind for minutes at a time."

   At any rate this particular version sets pixels directly in the
   lores display (using the function setlopixel) rather than
   use the monitor routines. Also this particular version works
   in DOS 3.3 which Dr. John's doesn't as well as ProDOS 8.

   Bill Buckels
   December 2009

 */
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <peekpoke.h>

/* base addresses for primary text page */
/* also the base addresses for the 48 scanline pairs */
/* for lores graphics mode 40 x 48 x 16 colors */
int textbase[24]={
    0x0400,
    0x0480,
    0x0500,
    0x0580,
    0x0600,
    0x0680,
    0x0700,
    0x0780,
    0x0428,
    0x04A8,
    0x0528,
    0x05A8,
    0x0628,
    0x06A8,
    0x0728,
    0x07A8,
    0x0450,
    0x04D0,
    0x0550,
    0x05D0,
    0x0650,
    0x06D0,
    0x0750,
    0x07D0};

void setlopixel(int color,int x,int y,int page)
{
     unsigned char *crt, c1, c2;
     int y1;


     y1 = y / 2;
     if (page !=0) x = x + 1024;



     c2 = (unsigned char ) (color & 15);


     if (y%2 == 0) {
		 /* even rows in low nibble */
		 /* mask value to preserve high nibble */
		 c1 = 240;
	 }
	 else {
		 /* odd rows in high nibble */
		 /* mask value to preserve low nibble */
		 c1 = 15;
		 c2 = c2 * 16;
	 }

     crt = (unsigned char *)(textbase[y1]+x);
     crt[0] &= c1;
     crt[0] |= c2;

}



void setcrtmode(unsigned int CRTMODE)
{
	/* note: the following constants must be hex values
	         or cc65 complains that the constant is a long */
    switch(CRTMODE)
        {
    case 0:
                   POKE(0xc051,0);  /* text */
                   POKE(0xc054,0);  /* page 1 */
                   break;
    case 1:
                  POKE(0xc056,0);   /* lo res */
                  POKE(0xc054,0);   /* page 1 */
                  POKE(0xc050,0);   /* set graphics */
                  POKE(0xc052,0);   /* full graphics */
                  break;
    case 2:
    default:
                  POKE(0xc057,0);   /* hi res */
                  POKE(0xc054,0);   /* page 1 */
                  POKE(0xc050,0);   /* set graphics */
                  POKE(0xc052,0);   /* full graphics */

        }

}


void loclear(unsigned ch)
{
  int idx;
  for (idx = 0; idx < 24; idx++)
    memset ((char *)textbase[idx], ch, 40);
}


int khit()
{
  unsigned char *KP = (unsigned char*)0xC000;
  unsigned char c;

  /* read the keyboard buffer    */
  /* and return 0 if no character is waiting */

   c = KP[0];
   if(c<128)return 0;
   return (int)c;
}

void clearkey()
{

/* return the last key press  */
unsigned char *KEYPRESS = (unsigned char*)0xC000;
/* clear the last key press   */
unsigned char *KEYCLEAR = (unsigned char*)0xC010;

	/* clear stragglers from the keyboard buffer */
	while(KEYPRESS[0] > 127)KEYCLEAR[0]=0;
}




int lrod ()
{

    int i, j, k, w, fmi, fmk, color, c=0;

	for (w = 3; w < 51; w++) {
		for (i = 1; i < 20; i++) {
			for (j = 0; j < 20; j++) {
				k = i + j;
				color = (j * 3) / (i + 3) + i * w / 12;
				fmi = 40 - i;
				fmk = 40 - k;
				setlopixel(color, i, k, 0);
				setlopixel(color, k, i, 0);

				setlopixel(color, fmi, fmk, 0);
				setlopixel(color, fmk, fmi, 0);

				setlopixel(color, k, fmi, 0);
				setlopixel(color, fmi, k, 0);

				setlopixel(color, i, fmk, 0);
				setlopixel(color, fmk, i, 0);
				if ((c = khit()) > 0) {
					clearkey();
					return c-128;

				}
			}
		}
	}

	if ((c = khit()) > 0) {
		clearkey();
		c-=128;
	}
	return c;

}



int main()
{


    setcrtmode(1);
    clearkey();
    for (;;) {
        loclear(0);
		if (lrod()==27)break;

    }
    loclear(32+128);
	setcrtmode(0);
	clrscr();
	return EXIT_SUCCESS;

}

