#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define TOK_C64_SYS 0x9E /* Commodore BASIC "SYS" token */
#define TOK_FP_CALL 0x8C /* Applesoft BASIC "CALL" token */
#define TOK_JMP     0x4C /* 6502 JMP opcode */

signed long int unhex (char *s)
{
 unsigned long int x, t;

 unsigned char *hexits="0123456789ABCDEF";

 x=0;

 for (t=0; t<strlen(s); t++)
 {
  char u, v;

  v=255;

  for (u=0; u<16; u++) if (toupper(hexits[u])==toupper(s[t])) v=u;
  if (v==255) return -1;
  x<<=4;
  x+=v;
 }

 return x;
}

void die (void)
{
 fprintf (stderr, "usage: automiz2 [-s] FILENAME1#06addr BASENAME\n"
                  "       The CiderPress tail is required of the source only.\n"
                  "         -s  Attempt to move an initial JMP to the decompressor stub.\n");
 exit(1);
}

int main (int argc, char **argv)
{
 FILE *file;

 static unsigned char data[49152];
 unsigned char cmd[256], realname[512];
 unsigned char tmpfold[1024];
 unsigned int addr, realaddr, t;
 long len;
 int strip;
 int base_arg;
 char *cptail, *base_ptr;

 base_arg=0;
 strip=0;

 if (argc==1) die();
 if (!strcmp(argv[1], "-s"))
 {
  base_arg++;
  strip=1;
 }

 if ((argc-base_arg)!=3) die();

 if (getenv("TEMP"))
  strcpy(tmpfold, getenv("TEMP"));
 else
  strcpy(tmpfold, "/tmp");

 sprintf(cmd, "%s/program.inp", tmpfold);
 remove(cmd);
 sprintf(cmd, "%s/program.out", tmpfold);
 remove(cmd);

 cptail=strrchr(argv[base_arg+1],'#');
 if (!cptail)
 {
  fprintf (stderr, "CiderPress tail is missing!\n");
  die();
 }

 if (strlen(cptail)!=7)
 {
  fprintf (stderr, "CiderPress tail is incorrectly formatted!\n");
  die();
 }

 if ((cptail[1]!='0')||(cptail[2]!='6'))
 {
  fprintf (stderr, "WARNING: CiderPress tail indicates file is not of BIN type.\n"
                   "         Resulting file may be unusable.\n");
 }

 addr=unhex(&(cptail[3]));
 if (addr>0xBFFF)
 {
  fprintf (stderr, "CiderPress tail address tag is not a valid hex value (%s)\n", &(cptail[3]));
  return 3;
 }

 file=fopen(argv[base_arg+1], "rb");
 if (!file)
 {
  perror(argv[base_arg+1]);
  return 2;
 }

 fseek(file,0,SEEK_END);
 len=ftell(file);
 fseek(file,0,SEEK_SET);
 fread(data,1,len,file);
 fclose(file);

 base_ptr=data;
 realaddr=addr;
 if ((*base_ptr==TOK_JMP)&&(strip))
 {
  realaddr=data[2];
  realaddr<<=8;
  realaddr&=0xFF00;
  realaddr+=data[1];
  base_ptr+=3;
  addr+=3;
  len-=3;
  printf ("Found initial jump from %04X to %04X.\n", addr-3, realaddr);
 }
 else if (strip) printf ("Did not find a JMP at the beginning of the image.\n");

 sprintf(cmd, "%s/program.inp", tmpfold);
 file=fopen(cmd, "wb");
 if (!file)
 {
  fprintf (stderr, "Could not open the first temp file.  Is '%s' writable?\n", tmpfold);
  perror(cmd);
  return 4;
 }

 fprintf (file, "%c%c", addr&0xFF, ((addr&0xFF00)>>8)&0xFF);
 fwrite (base_ptr,1,len,file);
 fclose(file);
 sprintf(cmd, "exomizer sfx 0x%04X -n -o %s/program.out %s/program.inp", realaddr,
         tmpfold, tmpfold);
 printf ("Executing: %s\n", cmd);
 system (cmd);

 strcpy (realname, argv[base_arg+2]);
 for (t=0; t<strlen(realname); t++)
 {
  realname[t]=toupper(realname[t]);
  if (realname[t]=='_') realname[t]=' ';
 }
 strcat(realname, "#fc0801"); /* FPBASIC */
 sprintf(cmd, "%s/program.out", tmpfold);
 file=fopen(cmd,"rb");
 if (!file)
 {
  fprintf (stderr, "Could not open the second temp file.\n");
  perror (cmd);
  return 5;
 }
 fseek(file,0,SEEK_END);
 len=ftell(file);
 len-=2;
 fseek(file,2,SEEK_SET);
 fread(data,1,len,file);
 fclose(file);
 printf ("Got %d bytes from the output file.\n", len);

 if (data[4]==TOK_C64_SYS)
 {
  printf ("Located and patching the C64 'SYS' call.\n");
  data[4]=TOK_FP_CALL;
 }
 else
  fprintf (stderr, "WARNING: C64 'SYS' call not where expected\n");

 file=fopen(realname,"wb");
 if (!file)
 {
  perror(realname);
  return 6;
 }
 fwrite(data,1,len,file);
 fclose(file);
 return 0;
}

