/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit.io;

import java.io.IOException;
import java.io.OutputStream;

public class RleOutputStream
extends OutputStream {
    private OutputStream os;
    private int escapeChar;
    private int repeatedByte;
    private int numBytes = -1;

    public RleOutputStream(OutputStream outputStream) {
        this(outputStream, 219);
    }

    public RleOutputStream(OutputStream outputStream, int n) {
        this.os = outputStream;
        this.escapeChar = n;
    }

    public void write(int n) throws IOException {
        if (this.numBytes == -1) {
            this.repeatedByte = n;
            ++this.numBytes;
        } else if (this.repeatedByte == n) {
            ++this.numBytes;
            if (this.numBytes > 255) {
                this.flush();
            }
        } else {
            this.flush();
            this.repeatedByte = n;
            ++this.numBytes;
        }
    }

    public void flush() throws IOException {
        if (this.numBytes != -1) {
            if (this.numBytes == 0 && this.escapeChar != this.repeatedByte) {
                this.os.write(this.repeatedByte);
            } else {
                this.os.write(this.escapeChar);
                this.os.write(this.repeatedByte);
                this.os.write(this.numBytes);
            }
            this.numBytes = -1;
        }
    }

    public void close() throws IOException {
        this.flush();
        this.os.close();
    }
}

