/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit.io;

import com.webcodepro.shrinkit.CRC16;
import com.webcodepro.shrinkit.io.BitInputStream;
import com.webcodepro.shrinkit.io.LittleEndianByteInputStream;
import com.webcodepro.shrinkit.io.LzwInputStream;
import com.webcodepro.shrinkit.io.RleInputStream;
import java.io.IOException;
import java.io.InputStream;

public class NufxLzw2InputStream
extends InputStream {
    private LittleEndianByteInputStream dataStream;
    private LzwInputStream lzwStream;
    private RleInputStream rleStream;
    private InputStream lzwRleStream;
    private InputStream decompressionStream;
    private int bytesLeftInChunk;
    private int volumeNumber = -1;
    private int rleCharacter;
    private CRC16 dataCrc = new CRC16();

    public NufxLzw2InputStream(LittleEndianByteInputStream littleEndianByteInputStream) {
        this.dataStream = littleEndianByteInputStream;
    }

    public int read() throws IOException {
        int n;
        if (this.volumeNumber == -1) {
            this.volumeNumber = this.dataStream.readByte();
            this.rleCharacter = this.dataStream.readByte();
            this.lzwStream = new LzwInputStream(new BitInputStream(this.dataStream, 9));
            this.rleStream = new RleInputStream(this.dataStream, this.rleCharacter);
            this.lzwRleStream = new RleInputStream(this.lzwStream);
        }
        if (this.bytesLeftInChunk == 0) {
            this.bytesLeftInChunk = 4096;
            this.lzwStream.clearData();
            n = this.dataStream.readWord();
            int n2 = n & Short.MAX_VALUE;
            int n3 = n & 0x8000;
            if (n3 == 0) {
                this.lzwStream.clearDictionary();
            } else {
                this.dataStream.readWord();
            }
            int n4 = (n3 == 0 ? 0 : 1) + (n2 == 4096 ? 0 : 2);
            switch (n4) {
                case 0: {
                    this.decompressionStream = this.dataStream;
                    break;
                }
                case 1: {
                    this.decompressionStream = this.lzwStream;
                    break;
                }
                case 2: {
                    this.decompressionStream = this.rleStream;
                    break;
                }
                case 3: {
                    this.decompressionStream = this.lzwRleStream;
                    break;
                }
                default: {
                    throw new IOException("Unknown type of decompression, flag = " + n4);
                }
            }
        }
        n = this.decompressionStream.read();
        --this.bytesLeftInChunk;
        this.dataCrc.update(n);
        return n;
    }

    public int getVolumeNumber() {
        return this.volumeNumber;
    }

    public void setVolumeNumber(int n) {
        this.volumeNumber = n;
    }

    public int getRleCharacter() {
        return this.rleCharacter;
    }

    public void setRleCharacter(int n) {
        this.rleCharacter = n;
    }

    public long getDataCrc() {
        return this.dataCrc.getValue();
    }
}

