/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit.io;

import com.webcodepro.shrinkit.io.BitInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class LzwInputStream
extends InputStream {
    private BitInputStream is;
    private List<int[]> dictionary;
    private Queue<Integer> outputBuffer = new ConcurrentLinkedQueue<Integer>();
    private boolean newBuffer = true;
    private int k;
    private int[] w;
    private int[] entry;

    public LzwInputStream(BitInputStream bitInputStream) {
        this.is = bitInputStream;
    }

    public int read() throws IOException {
        if (this.outputBuffer.isEmpty()) {
            this.fillBuffer();
        }
        return this.outputBuffer.remove();
    }

    public void fillBuffer() throws IOException {
        if (this.dictionary == null) {
            this.is.setRequestedNumberOfBits(9);
            this.dictionary = new ArrayList<int[]>();
            for (int n = 0; n < 256; n = (int)((short)(n + 1))) {
                this.dictionary.add(new int[]{n});
            }
            this.dictionary.add(new int[]{256});
        }
        if (this.newBuffer) {
            this.k = this.is.read();
            this.outputBuffer.add(this.k);
            if (this.k == -1) {
                return;
            }
            this.w = new int[]{this.k};
            this.newBuffer = false;
        }
        this.k = this.is.read();
        if (this.k == -1) {
            this.outputBuffer.add(this.k);
            return;
        }
        if (this.k == 256) {
            this.dictionary = null;
            this.is.setRequestedNumberOfBits(9);
            this.k = 0;
            this.w = null;
            this.entry = null;
            this.newBuffer = true;
            this.fillBuffer();
            return;
        }
        if (this.k < this.dictionary.size()) {
            this.entry = this.dictionary.get(this.k);
        } else if (this.k == this.dictionary.size()) {
            this.entry = new int[this.w.length + 1];
            System.arraycopy(this.w, 0, this.entry, 0, this.w.length);
            this.entry[this.w.length] = this.w[0];
        } else {
            throw new IOException("Invalid code of <" + this.k + "> encountered");
        }
        for (int n : this.entry) {
            this.outputBuffer.add(n);
        }
        int[] nArray = new int[this.w.length + 1];
        System.arraycopy(this.w, 0, nArray, 0, this.w.length);
        nArray[this.w.length] = this.entry[0];
        this.dictionary.add(nArray);
        this.w = this.entry;
        if ((this.dictionary.size() ^ this.is.getBitMask()) == 0) {
            this.is.increaseRequestedNumberOfBits();
        }
    }

    public void clearDictionary() {
        this.dictionary = null;
        this.is.setRequestedNumberOfBits(9);
        this.is.clearRemainingBitsOfData();
        this.outputBuffer.clear();
        this.k = 0;
        this.w = null;
        this.entry = null;
        this.newBuffer = true;
    }

    public void clearData() {
        this.is.clearRemainingBitsOfData();
        this.outputBuffer.clear();
    }
}

