/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit.io;

import com.webcodepro.shrinkit.io.BitConstants;
import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream
extends OutputStream
implements BitConstants {
    private OutputStream os;
    private int requestedNumberOfBits;
    private int bitMask;
    private int data = 0;
    private int bitsOfData = 0;

    public BitOutputStream(OutputStream outputStream, int n) {
        this.os = outputStream;
        this.setRequestedNumberOfBits(n);
    }

    public void setRequestedNumberOfBits(int n) {
        this.requestedNumberOfBits = n;
        this.bitMask = BIT_MASKS[n];
    }

    public void increaseRequestedNumberOfBits() {
        this.setRequestedNumberOfBits(this.requestedNumberOfBits + 1);
    }

    public int getBitMask() {
        return this.bitMask;
    }

    public void write(int n) throws IOException {
        n &= this.bitMask;
        this.data |= (n <<= this.bitsOfData);
        this.bitsOfData += this.requestedNumberOfBits;
        while (this.bitsOfData >= 8) {
            this.os.write(this.data & 0xFF);
            this.data >>= 8;
            this.bitsOfData -= 8;
        }
    }

    public void clearRemainingBitsOfData() {
        this.bitsOfData = 0;
        this.data = 0;
    }

    public void close() throws IOException {
        if (this.bitsOfData > 0) {
            this.write(0);
        }
    }
}

