/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit;

import com.webcodepro.shrinkit.ThreadClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ThreadKind {
    ASCII_TEXT,
    ALLOCATED_SPACE,
    APPLE_IIGS_ICON,
    CREATE_DIRECTORY,
    DATA_FORK,
    DISK_IMAGE,
    RESOURCE_FORK,
    FILENAME;


    public static ThreadKind find(int n, ThreadClass threadClass) {
        switch (threadClass) {
            case MESSAGE: {
                switch (n) {
                    case 0: {
                        return ASCII_TEXT;
                    }
                    case 1: {
                        return ALLOCATED_SPACE;
                    }
                    case 2: {
                        return APPLE_IIGS_ICON;
                    }
                }
                throw new IllegalArgumentException("Unknown thread_kind " + n + " for message thread_class of " + (Object)((Object)threadClass));
            }
            case CONTROL: {
                if (n == 0) {
                    return CREATE_DIRECTORY;
                }
                throw new IllegalArgumentException("Unknown thread_kind " + n + " for control thread_class of " + (Object)((Object)threadClass));
            }
            case DATA: {
                switch (n) {
                    case 0: {
                        return DATA_FORK;
                    }
                    case 1: {
                        return DISK_IMAGE;
                    }
                    case 2: {
                        return RESOURCE_FORK;
                    }
                }
                throw new IllegalArgumentException("Unknown thread_kind " + n + " for data thread_class of " + (Object)((Object)threadClass));
            }
            case FILENAME: {
                if (n == 0) {
                    return FILENAME;
                }
                throw new IllegalArgumentException("Unknown thread_kind " + n + " for filename thread_class of " + (Object)((Object)threadClass));
            }
        }
        throw new IllegalArgumentException("Unknown thread_class of " + (Object)((Object)threadClass));
    }
}

