/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util;

public class BusinessBASICToken {
    private int lineNumber;
    private byte tokenValue;
    private String tokenString;
    private String stringValue;

    public BusinessBASICToken(int n) {
        this.lineNumber = n;
    }

    public BusinessBASICToken(byte by, String string) {
        this.tokenValue = by;
        this.tokenString = string;
    }

    public BusinessBASICToken(String string) {
        this.stringValue = string;
    }

    public boolean isCommandSeparator() {
        return ":".equals(this.stringValue);
    }

    public boolean isLineNumber() {
        return !this.isToken() && !this.isString();
    }

    public boolean isEndOfCommand() {
        return this.isLineNumber() || this.isCommandSeparator();
    }

    public boolean isToken() {
        return this.tokenString != null;
    }

    public boolean isString() {
        return this.stringValue != null;
    }

    public boolean isExpressionSeparator() {
        return this.isCommandSeparator() || ",".equals(this.stringValue) || ";".equals(this.stringValue);
    }

    public boolean isIndenter() {
        return this.isToken() && this.tokenString.equals("FOR");
    }

    public boolean isOutdenter() {
        return this.isToken() && this.tokenString.equals("NEXT");
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public byte getTokenValue() {
        return this.tokenValue;
    }

    public String toString() {
        if (this.isLineNumber()) {
            return Integer.toString(this.getLineNumber());
        }
        if (this.isToken()) {
            return this.getTokenString() + " " + Integer.toHexString(this.getTokenValue());
        }
        return this.getStringValue();
    }
}

