/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.physical;

public class ByteArrayImageLayout {
    private byte[] diskImage;
    private boolean changed;

    public ByteArrayImageLayout(byte[] byArray) {
        this.setDiskImage(byArray);
    }

    public ByteArrayImageLayout(byte[] byArray, boolean bl) {
        this.setDiskImage(byArray);
        this.changed = bl;
    }

    public ByteArrayImageLayout(int n) {
        this.diskImage = new byte[n];
        this.changed = true;
    }

    public byte[] getDiskImage() {
        return this.diskImage;
    }

    public void setDiskImage(byte[] byArray) {
        this.diskImage = byArray;
        this.changed = true;
    }

    public int getPhysicalSize() {
        return this.diskImage != null ? this.diskImage.length : 0;
    }

    public byte[] readBytes(int n, int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.diskImage, n, byArray, 0, n2);
        return byArray;
    }

    public void writeBytes(int n, byte[] byArray) {
        this.changed = true;
        System.arraycopy(byArray, 0, this.diskImage, n, byArray.length);
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }
}

