/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.prodos;

import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.util.AppleUtil;
import java.util.Date;

public class ProdosCommonEntry {
    public static final int ENTRY_LENGTH = 39;
    private ProdosFormatDisk disk;
    private int block;
    private int offset;

    public ProdosCommonEntry(ProdosFormatDisk prodosFormatDisk, int n, int n2) {
        this.disk = prodosFormatDisk;
        this.block = n;
        this.offset = n2;
    }

    protected int getFileEntryBlock() {
        return this.block;
    }

    protected ProdosFormatDisk getDisk() {
        return this.disk;
    }

    protected byte[] readFileEntry() {
        byte[] byArray = this.disk.readBlock(this.block);
        byte[] byArray2 = new byte[39];
        System.arraycopy(byArray, this.offset, byArray2, 0, 39);
        return byArray2;
    }

    public boolean isEmpty() {
        byte[] byArray = this.readFileEntry();
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 0) continue;
            return false;
        }
        return true;
    }

    protected void writeFileEntry(byte[] byArray) {
        byte[] byArray2 = this.disk.readBlock(this.block);
        System.arraycopy(byArray, 0, byArray2, this.offset, 39);
        this.disk.writeBlock(this.block, byArray2);
    }

    protected int getStorageType() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[0]) >> 4;
    }

    public void setStorageType(int n) {
        byte[] byArray = this.readFileEntry();
        int n2 = AppleUtil.getUnsignedByte(byArray[0]);
        n2 = n2 & 0xF | (n & 0xF) << 4;
        byArray[0] = (byte)n2;
        this.writeFileEntry(byArray);
    }

    public boolean isSeedlingFile() {
        return this.getStorageType() == 1;
    }

    public void setSeedlingFile() {
        this.setStorageType(1);
    }

    public boolean isSaplingFile() {
        return this.getStorageType() == 2;
    }

    public void setSaplingFile() {
        this.setStorageType(2);
    }

    public boolean isTreeFile() {
        return this.getStorageType() == 3;
    }

    public void setTreeFile() {
        this.setStorageType(3);
    }

    public boolean isSubdirectory() {
        return this.getStorageType() == 13;
    }

    public void setSubdirectory() {
        this.setStorageType(13);
    }

    public boolean isSubdirectoryHeader() {
        return this.getStorageType() == 14;
    }

    public void setSubdirectoryHeader() {
        this.setStorageType(14);
    }

    public boolean isVolumeHeader() {
        return this.getStorageType() == 15;
    }

    public void setVolumeHeader() {
        this.setStorageType(15);
    }

    public Date getCreationDate() {
        return AppleUtil.getProdosDate(this.readFileEntry(), 24);
    }

    public void setCreationDate(Date date) {
        byte[] byArray = this.readFileEntry();
        AppleUtil.setProdosDate(byArray, 24, date);
        this.writeFileEntry(byArray);
    }

    public int getProdosVersion() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[28]);
    }

    public void setProdosVersion(int n) {
        byte[] byArray = this.readFileEntry();
        byArray[28] = (byte)n;
        this.writeFileEntry(byArray);
    }

    public int getMinimumProdosVersion() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[29]);
    }

    public void setMinimumProdosVersion(int n) {
        byte[] byArray = this.readFileEntry();
        byArray[29] = (byte)n;
        this.writeFileEntry(byArray);
    }

    protected byte getAccess() {
        return this.readFileEntry()[30];
    }

    protected void setAccess(int n, boolean bl) {
        byte[] byArray = this.readFileEntry();
        byte by = byArray[30];
        by = bl ? AppleUtil.setBit(by, n) : AppleUtil.clearBit(by, n);
        byArray[30] = by;
        this.writeFileEntry(byArray);
    }

    public boolean canDestroy() {
        return AppleUtil.isBitSet(this.getAccess(), 7);
    }

    public void setCanDestroy(boolean bl) {
        this.setAccess(7, bl);
    }

    public boolean canRename() {
        return AppleUtil.isBitSet(this.getAccess(), 6);
    }

    public void setCanRename(boolean bl) {
        this.setAccess(6, bl);
    }

    public boolean hasChanged() {
        return AppleUtil.isBitSet(this.getAccess(), 5);
    }

    public void setHasChanged(boolean bl) {
        this.setAccess(5, bl);
    }

    public boolean canWrite() {
        return AppleUtil.isBitSet(this.getAccess(), 1);
    }

    public void setCanWrite(boolean bl) {
        this.setAccess(1, bl);
    }

    public boolean canRead() {
        return AppleUtil.isBitSet(this.getAccess(), 0);
    }

    public void setCanRead(boolean bl) {
        this.setAccess(0, bl);
    }

    public FormattedDisk getFormattedDisk() {
        return this.disk;
    }
}

