/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.gutenberg;

import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.filters.GutenbergFileFilter;
import com.webcodepro.applecommander.storage.os.gutenberg.GutenbergFormatDisk;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class GutenbergFileEntry
implements FileEntry {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int FILE_DESCRIPTIVE_ENTRY_LENGTH = 16;
    private GutenbergFormatDisk disk;
    private int track;
    private int sector;
    private int offset;

    public GutenbergFileEntry(GutenbergFormatDisk gutenbergFormatDisk, int n, int n2, int n3) {
        this.disk = gutenbergFormatDisk;
        this.track = n;
        this.sector = n2;
        this.offset = n3;
    }

    protected byte[] readFileEntry() {
        byte[] byArray = this.disk.readSector(this.track, this.sector);
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, this.offset, byArray2, 0, byArray2.length);
        return byArray2;
    }

    protected void writeFileEntry(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException(this.textBundle.format("GutenbergFileEntry.GutenbergFileEntryLengthError", 16));
        }
        byte[] byArray2 = this.disk.readSector(this.track, this.sector);
        System.arraycopy(byArray, 0, byArray2, this.offset, byArray.length);
        this.disk.writeSector(this.track, this.sector, byArray2);
    }

    public int getMaximumFilenameLength() {
        return 12;
    }

    public String getFilename() {
        return AppleUtil.getString(this.readFileEntry(), 0, this.getMaximumFilenameLength()).trim();
    }

    public void setFilename(String string) {
        byte[] byArray = this.readFileEntry();
        AppleUtil.setString(byArray, 0, string.toUpperCase(), this.getMaximumFilenameLength());
        this.writeFileEntry(byArray);
    }

    public String getFiletype() {
        return "T";
    }

    public void setFiletype(String string) {
    }

    public boolean isLocked() {
        return true;
    }

    public void setLocked(boolean bl) {
    }

    public int getSize() {
        int n = this.getSectorsUsed() * 256;
        return n;
    }

    public int getSectorsUsed() {
        int n = this.getTrack();
        int n2 = this.getSector();
        int n3 = 0;
        while (n < 128) {
            byte[] byArray = this.disk.readSector(n, n2);
            n = AppleUtil.getUnsignedByte(byArray[4]);
            n2 = AppleUtil.getUnsignedByte(byArray[5]);
            ++n3;
        }
        return n3;
    }

    public void setSectorsUsed(int n) {
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isDeleted() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[13]) == 64;
    }

    public void delete() {
    }

    public List getFileColumnData(int n) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (n) {
            case 2: {
                arrayList.add(this.isLocked() ? "*" : " ");
                arrayList.add(this.getFiletype());
                numberFormat.setMinimumIntegerDigits(3);
                arrayList.add(numberFormat.format(this.getSectorsUsed()));
                arrayList.add(this.getFilename());
                break;
            }
            case 3: {
                arrayList.add(this.isLocked() ? "*" : " ");
                arrayList.add(this.getFiletype());
                arrayList.add(this.getFilename());
                arrayList.add(numberFormat.format(this.getSize()));
                numberFormat.setMinimumIntegerDigits(3);
                arrayList.add(numberFormat.format(this.getSectorsUsed()));
                arrayList.add(this.isDeleted() ? this.textBundle.get("Deleted") : "");
                arrayList.add("T" + this.getTrack() + " S" + this.getSector());
                break;
            }
            default: {
                arrayList.add(this.getFilename());
                arrayList.add(this.getFiletype());
                arrayList.add(numberFormat.format(this.getSize()));
                arrayList.add(this.isLocked() ? this.textBundle.get("Locked") : "");
            }
        }
        return arrayList;
    }

    public int getTrack() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[12]);
    }

    public void setTrack(int n) {
        byte[] byArray = this.readFileEntry();
        byArray[12] = (byte)n;
        this.writeFileEntry(byArray);
    }

    public int getSector() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[13]);
    }

    public void setSector(int n) {
        byte[] byArray = this.readFileEntry();
        byArray[13] = (byte)n;
        this.writeFileEntry(byArray);
    }

    public byte[] getFileData() {
        return this.disk.getFileData(this);
    }

    public void setFileData(byte[] byArray) throws DiskFullException {
        this.disk.setFileData(this, byArray);
    }

    public FileFilter getSuggestedFilter() {
        return new GutenbergFileFilter();
    }

    public boolean isAssemblySourceFile() {
        return false;
    }

    public FormattedDisk getFormattedDisk() {
        return this.disk;
    }

    public boolean needsAddress() {
        return false;
    }

    public void setAddress(int n) {
    }

    public boolean canCompile() {
        return false;
    }
}

