/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.cpm;

import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.filters.BinaryFileFilter;
import com.webcodepro.applecommander.storage.filters.TextFileFilter;
import com.webcodepro.applecommander.storage.os.cpm.CpmFormatDisk;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class CpmFileEntry
implements FileEntry {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int ENTRY_LENGTH = 32;
    public static final int MAX_EXTENTS_PER_ENTRY = 128;
    public static final int ALL_RECORDS_FILLED_SIZE = 16384;
    public static final int USER_NUMBER_OFFSET = 0;
    public static final int FILENAME_OFFSET = 1;
    public static final int FILENAME_LENGTH = 8;
    public static final int FILETYPE_OFFSET = 9;
    public static final int FILETYPE_LENGTH = 3;
    public static final int FILETYPE_T1_OFFSET = 9;
    public static final int FILETYPE_T2_OFFSET = 10;
    public static final int FILETYPE_T3_OFFSET = 11;
    public static final int EXTENT_COUNTER_OFFSET = 12;
    public static final int RECORD_COUNT_OFFSET = 15;
    public static final int ALLOCATION_OFFSET = 16;
    public static final String[] TEXT_FILETYPES = new String[]{"TXT", "ASM", "MAC", "DOC", "PRN", "PAS", "ME", "INC", "HLP"};
    private CpmFormatDisk disk;
    private List offsets = new ArrayList();

    public CpmFileEntry(CpmFormatDisk cpmFormatDisk, int n) {
        this.disk = cpmFormatDisk;
        this.addOffset(n);
    }

    public void addOffset(int n) {
        this.offsets.add(new Integer(n));
    }

    protected byte[] readFileEntry(int n) {
        byte[] byArray = new byte[2048];
        System.arraycopy(this.disk.readCpmBlock(0), 0, byArray, 0, 1024);
        System.arraycopy(this.disk.readCpmBlock(1), 0, byArray, 1024, 1024);
        byte[] byArray2 = new byte[32];
        int n2 = (Integer)this.offsets.get(n);
        System.arraycopy(byArray, n2, byArray2, 0, 32);
        return byArray2;
    }

    protected void writeFileEntry(int n, byte[] byArray) {
        byte[] byArray2 = new byte[1024];
        System.arraycopy(byArray, 0, byArray2, 0, 1024);
        this.disk.writeCpmBlock(0, byArray2);
        System.arraycopy(byArray, 0, byArray2, 1024, 1024);
        this.disk.writeCpmBlock(1, byArray2);
    }

    public String getFilename() {
        return AppleUtil.getString(this.readFileEntry(0), 1, 8).trim();
    }

    public void setFilename(String string) {
        for (int i = 0; i < this.offsets.size(); ++i) {
            byte[] byArray = this.readFileEntry(i);
            AppleUtil.setString(byArray, 1, string, 8, false);
            this.writeFileEntry(i, byArray);
        }
    }

    public String getFiletype() {
        return AppleUtil.getString(this.readFileEntry(0), 9, 3).trim();
    }

    public void setFiletype(String string) {
        for (int i = 0; i < this.offsets.size(); ++i) {
            byte by = this.getFileTypeT1(i);
            byte by2 = this.getFileTypeT2(i);
            byte by3 = this.getFileTypeT3(i);
            byte[] byArray = this.readFileEntry(i);
            AppleUtil.setString(byArray, 9, string, 3, false);
            byArray[9] = (byte)(byArray[9] | (by > 127 ? 128 : 0));
            byArray[10] = (byte)(byArray[10] | (by2 > 127 ? 128 : 0));
            byArray[10] = (byte)(byArray[10] | (by3 > 127 ? 128 : 0));
        }
    }

    public boolean isLocked() {
        return AppleUtil.isBitSet(this.getFileTypeT1(0), 7);
    }

    public byte getFileTypeT1(int n) {
        return this.readFileEntry(n)[9];
    }

    public void setFileTypeT1(int n, int n2) {
        byte[] byArray = this.readFileEntry(n);
        byArray[9] = (byte)n2;
        this.writeFileEntry(n, byArray);
    }

    public byte getFileTypeT2(int n) {
        return this.readFileEntry(n)[10];
    }

    public void setFileTypeT2(int n, int n2) {
        byte[] byArray = this.readFileEntry(n);
        byArray[10] = (byte)n2;
        this.writeFileEntry(n, byArray);
    }

    public byte getFileTypeT3(int n) {
        return this.readFileEntry(n)[11];
    }

    public void setFileTypeT3(int n, int n2) {
        byte[] byArray = this.readFileEntry(n);
        byArray[11] = (byte)n2;
        this.writeFileEntry(n, byArray);
    }

    public void setLocked(boolean bl) {
        for (int i = 0; i < this.offsets.size(); ++i) {
            if (bl) {
                this.setFileTypeT1(i, this.getFileTypeT1(i) | 0x80);
                continue;
            }
            this.setFileTypeT1(i, this.getFileTypeT1(i) & 0x7F);
        }
    }

    public int getExtentCounterLow(int n) {
        return AppleUtil.getUnsignedByte(this.readFileEntry(n)[12]);
    }

    public int getSize() {
        int n = this.findLargestExtent();
        return this.getExtentCounterLow(n) * 16384 + this.getNumberOfRecordsUsed(n) * 128;
    }

    protected int findLargestExtent() {
        int n = -1;
        for (int i = 0; i < this.offsets.size(); ++i) {
            if (n < 0) {
                n = i;
                continue;
            }
            int n2 = this.getExtentCounterLow(n);
            int n3 = this.getExtentCounterLow(i);
            if (n3 <= n2) continue;
            n = i;
        }
        return n;
    }

    public int getBlocksUsed() {
        int n = this.findLargestExtent();
        return this.getExtentCounterLow(n) * 16384 + (this.getNumberOfRecordsUsed(n) - 1) / 8 + 1;
    }

    public int getNumberOfRecordsUsed(int n) {
        return AppleUtil.getUnsignedByte(this.readFileEntry(n)[15]);
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isDeleted() {
        return 229 == this.getUserNumber(0);
    }

    public int getUserNumber(int n) {
        return AppleUtil.getUnsignedByte(this.readFileEntry(n)[0]);
    }

    public void setUserNumber(int n, int n2) {
        byte[] byArray = this.readFileEntry(n);
        byArray[0] = (byte)n2;
        this.writeFileEntry(n, byArray);
    }

    public void delete() {
        for (int i = 0; i < this.offsets.size(); ++i) {
            this.setUserNumber(i, 229);
        }
    }

    public List getFileColumnData(int n) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (n) {
            case 2: {
                arrayList.add(this.getFilename());
                arrayList.add(this.getFiletype());
                break;
            }
            case 3: {
                arrayList.add(this.getFilename());
                arrayList.add(this.getFiletype());
                arrayList.add(numberFormat.format(this.getSize()));
                arrayList.add("0x" + AppleUtil.getFormattedByte(this.getUserNumber(0)));
                arrayList.add(this.isDeleted() ? this.textBundle.get("Deleted") : "");
                arrayList.add(this.isLocked() ? this.textBundle.get("Locked") : "");
                break;
            }
            default: {
                arrayList.add(this.getFilename());
                arrayList.add(this.getFiletype());
                arrayList.add(numberFormat.format(this.getSize()));
                arrayList.add(this.isLocked() ? this.textBundle.get("Locked") : "");
            }
        }
        return arrayList;
    }

    public byte[] getFileData() {
        return this.disk.getFileData(this);
    }

    public void setFileData(byte[] byArray) throws DiskFullException {
    }

    public FileFilter getSuggestedFilter() {
        String string = this.getFiletype();
        for (int i = 0; i < TEXT_FILETYPES.length; ++i) {
            if (!TEXT_FILETYPES[i].equals(string)) continue;
            return new TextFileFilter();
        }
        return new BinaryFileFilter();
    }

    public FormattedDisk getFormattedDisk() {
        return this.disk;
    }

    public int getMaximumFilenameLength() {
        return 8;
    }

    public boolean needsAddress() {
        return this.disk.needsAddress(this.getFiletype());
    }

    public void setAddress(int n) {
    }

    public boolean canCompile() {
        return false;
    }

    public boolean isEmpty() {
        byte[] byArray = this.readFileEntry(0);
        for (int i = 0; i < 32; ++i) {
            int n = AppleUtil.getUnsignedByte(byArray[i]);
            if (n == 229) continue;
            return false;
        }
        return true;
    }

    public int[] getAllocations() {
        int n = this.getBlocksUsed();
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < this.offsets.size(); ++i) {
            byte[] byArray = this.readFileEntry(i);
            int n3 = 16;
            while (n2 < n && n3 < 32) {
                nArray[n2++] = AppleUtil.getUnsignedByte(byArray[n3++]);
            }
        }
        return nArray;
    }
}

