/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class AssemblySourceFileFilter
implements FileFilter {
    private int[] tabStops = new int[]{10, 15};
    private int commentTabStop = 25;
    private String tabChars = "\t ";
    private String commentTabChars = ";";
    private String commentNoTabChars = "*";

    public byte[] filter(FileEntry fileEntry) {
        byte[] byArray = fileEntry.getFileData();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < byArray.length; ++i) {
            char c = (char)(byArray[i] & 0x7F);
            if (c == '\u0000') continue;
            if (c == '\r') {
                printWriter.println();
                n = 0;
                n2 = 0;
                bl = false;
                continue;
            }
            if (!bl && this.tabChars.indexOf(c) > -1) {
                if (n >= this.tabStops.length) continue;
                int n3 = this.tabStops[n];
                printWriter.print(' ');
                ++n2;
                while (n2 < n3) {
                    printWriter.print(' ');
                    ++n2;
                }
                continue;
            }
            if (!bl && this.commentTabChars.indexOf(c) > -1) {
                while (n2 < this.commentTabStop) {
                    printWriter.print(' ');
                    ++n2;
                }
                printWriter.print(c);
                ++n2;
                continue;
            }
            if (n2 == 0 && this.commentNoTabChars.indexOf(c) > -1) {
                bl = true;
                printWriter.print(c);
                ++n2;
                continue;
            }
            printWriter.print(c);
            ++n2;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String getSuggestedFileName(FileEntry fileEntry) {
        String string = fileEntry.getFilename().trim();
        if (!string.toLowerCase().endsWith(".s")) {
            string = string + ".s";
        }
        return string;
    }
}

